from django.db import models
from django.utils.translation import ugettext_lazy as _
from radmin.backend import RedisBackend
from django.db.models import signals


class Redis(models.Model):
    key = models.CharField(_('key'), max_length=1000, primary_key=True)
    value = models.TextField(_('value'), null=True)

    def __unicode__(self):
        return self.key

    class Meta:
        verbose_name = _('key value pair')
        verbose_name_plural = _('key value pairs')


def pre_delete(instance, sender, **kwargs):
    RedisBackend().connection.delete(instance.key)

def post_save(instance, sender, **kwargs):
    RedisBackend().connection.set(instance.key, instance.value)

signals.pre_delete.connect(pre_delete, sender=Redis)
signals.post_save.connect(post_save, sender=Redis)

