#coding=utf-8
import re
from django.contrib import admin
from radmin.models import Redis
from radmin.backend import RedisBackend
from django.utils.translation import ugettext_lazy as _
from django import forms


class RedisAdmin(admin.ModelAdmin):
    prefix = ''
    search_fields = ['key', 'value']

    def __init__(self, *args, **kwargs):
        self.connection = RedisBackend().connection
        self.key_pat = re.compile(r'^%s(.*)$' % self.prefix)
        super(RedisAdmin, self).__init__(*args, **kwargs)

    def save_model(self, request, obj, form, change):
        if not obj.key.startswith(self.prefix):
            obj.key = '%s%s' % (self.prefix, obj.key)
        obj.save()

    def get_object(self, request, key):
        if self.key_pat.match(key):
            value = self.connection.get(key)
            if value is not None:
                obj = self.model.objects.get_or_create(key=key)[0]
                obj.value = value
                obj.save()
                return obj

    def queryset(self, request):
        pattern = '%s*' % self.prefix
        qs = self.model.objects.filter(key__startswith=self.prefix)
        redis_keys = set(self.connection.keys(pattern=pattern))
        model_keys = set(qs.values_list('key', flat=True))
        orphans = model_keys - redis_keys
        new_keys = redis_keys - model_keys
        self.model.objects.filter(key__in=orphans).delete()
        for key in new_keys:
            self.model.objects.create(key=key, value=None)
        return qs


admin.site.register(Redis, RedisAdmin)

