from django.core.mail.backends.base import BaseEmailBackend

from .engine import add_message_to_queue


class RedisBackend(BaseEmailBackend):
    def send_messages(self, email_messages):
        num_sent = 0
        for email in email_messages:
            add_message_to_queue(email)
            num_sent += 1
        return num_sent
