import base64
import pickle

from django.conf import settings
from django.core.mail import get_connection
from redis import Redis

from .utils import memoize


@memoize
def get_redis_connection():
    conf = getattr(settings, 'REDIS_MAILER_LOCATION', '127.0.0.1:6379:1')
    return Redis(*conf.split(':'))


def add_message_to_queue(email):
    r = get_redis_connection()
    key = getattr(settings, 'REDIS_MAILER_KEY', 'mail_queue')
    data = base64.encodestring(pickle.dumps(email))
    r.rpush(key, data)


def get_messages_from_queue():
    r = get_redis_connection()
    key = getattr(settings, 'REDIS_MAILER_KEY', 'mail_queue')
    while True:
        data = r.lpop(key)
        if not data:
            return
        yield pickle.loads(base64.decodestring(data))


def process_messages():
    EMAIL_BACKEND = getattr(
        settings,
        'REDIS_EMAIL_BACKEND',
        'django.core.mail.backends.smtp.EmailBackend'
    )
    connection = get_connection(backend=EMAIL_BACKEND)
    for email in get_messages_from_queue():
        email.connection = connection
        email.send()
