from functools import wraps


def memoize(f):
    f.cached_result = None

    @wraps(f)
    def wrapper(*args, **kwargs):
        if not f.cached_result:
            f.cached_result = f(*args, **kwargs)
        return f.cached_result
    return wrapper
