import os

from setuptools import setup


def read(fname):
    with open(os.path.join(os.path.dirname(__file__), fname)) as f:
        return f.read()

setup(
    name='django-redis-mailer',
    version='0.2',
    url='https://github.com/Bulv1ne/django-redis-mailer',
    license='MIT',
    author='Niels Lemmens',
    author_email='draso.odin@gmail.com',
    description='A django mail queue',
    long_description=read('README.md'),
    packages=['django_redis_mailer'],
    platforms='any',
    install_requires=[
        'django>=1.7',
        'redis>=2.10'
    ],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
