django-redis-mailer
===================

[![Coverage Status](https://img.shields.io/coveralls/bulv1ne/django-redis-mailer.svg)](https://coveralls.io/r/bulv1ne/django-redis-mailer)
[![Build Status](https://travis-ci.org/bulv1ne/django-redis-mailer.svg?branch=master)](https://travis-ci.org/bulv1ne/django-redis-mailer)

django-redis-mailer is based on [django-mailer](https://github.com/pinax/django-mailer).
The differences are that it works with redis as a queue, and it is a simplified version (no database models).

The project is in the early stages, it is not recommended to use this in production.

In `settings.py`:

```python
EMAIL_BACKEND = 'django_redis_mailer.backend.RedisBackend'
```

Optional settings:

```python
REDIS_MAILER_LOCATION = '127.0.0.1:6379:1'  # host:port:db number
REDIS_MAILER_KEY = 'mail_queue'  # The key in redis to use
```

In a cron file:

```
* * * * * (/path/to/your/python /path/to/your/manage.py send_mail >> ~/cron_mail.log 2>&1)
```
