from django.core.mail import send_mail
from django.core.management import call_command
from django.test import TestCase

from .engine import get_messages_from_queue, get_redis_connection


class TestBackend(TestCase):
    def test_queue_length(self):
        with self.settings(
                EMAIL_BACKEND='django_redis_mailer.backend.RedisBackend',
                REDIS_MAILER_KEY='mail_queue'):
            r = get_redis_connection()
            # Remove the queue first
            r.delete('mail_queue')
            self.assertEqual(r.llen('mail_queue'), 0)
            send_mail(
                'Subject',
                'Body',
                'sender@example.com',
                ['recipient@example.com']
            )
            self.assertEqual(r.llen('mail_queue'), 1)


class TestMailer(TestCase):
    def test_something(self):
        with self.settings(
                EMAIL_BACKEND='django_redis_mailer.backend.RedisBackend',
                REDIS_MAILER_KEY='mail_queue'):
            r = get_redis_connection()
            # Remove the queue first
            r.delete('mail_queue')
            send_mail(
                'My Subject',
                'Body',
                'sender@example.com',
                ['recipient@example.com']
            )
            queue = get_messages_from_queue()
            email = next(queue)
            self.assertEqual(email.subject, 'My Subject')
            with self.assertRaises(StopIteration):
                next(queue)

    def test_command(self):
        with self.settings(
                EMAIL_BACKEND='django_redis_mailer.backend.RedisBackend',
                REDIS_MAILER_KEY='mail_queue'):
            r = get_redis_connection()
            # Remove the queue first
            r.delete('mail_queue')
            self.assertEqual(r.llen('mail_queue'), 0)
            send_mail(
                'Subject',
                'Body',
                'sender@example.com',
                ['recipient@example.com']
            )
            self.assertEqual(r.llen('mail_queue'), 1)
            call_command('send_mail')
            self.assertEqual(r.llen('mail_queue'), 0)
