/*!
 * Handsontable 0.12.2
 * Handsontable is a JavaScript library for editable tables with basic copy-paste compatibility with Excel and Google Docs
 *
 * Copyright 2012-2014 Marcin Warpechowski
 * Licensed under the MIT license.
 * http://handsontable.com/
 *
 * Date: Mon Dec 08 2014 10:47:06 GMT+0100 (CET)
 */
var Handsontable=function(a,b){b=b||{};var c=new Handsontable.Core(a,b);return c.init(),c};Handsontable.helper={},Handsontable.plugins={},function(a,b){"use strict";function c(){this.refCounter=0,this.init()}function d(){function a(){var a=this;a._registerTimeout(setTimeout(function(){a.updateSettings({observeChanges:!0})},0))}function c(a){return function(b,c){return"string"==typeof b[1]&&(b[1]=b[1].toLowerCase()),"string"==typeof c[1]&&(c[1]=c[1].toLowerCase()),b[1]===c[1]?0:null===b[1]||""===b[1]?1:null===c[1]||""===c[1]?-1:b[1]<c[1]?a?-1:1:b[1]>c[1]?a?1:-1:0}}function d(a){return function(b,c){if(b[1]===c[1])return 0;if(null===b[1])return 1;if(null===c[1])return-1;var d=new Date(b[1]),e=new Date(c[1]);return e>d?a?-1:1:d>e?a?1:-1:0}}function e(a){return"undefined"!=typeof a.sortColumn}var f=this;this.init=function(b){var c,d,e=this,g=e.getSettings().columnSorting;if(e.sortingEnabled=!!g,e.sortingEnabled){e.sortIndex=[];var j=h.call(e);"undefined"!=typeof j?(c=j.sortColumn,d=j.sortOrder):(c=g.column,d=g.sortOrder),f.sortByColumn.call(e,c,d),e.sort=function(){var a=Array.prototype.slice.call(arguments);return f.sortByColumn.apply(e,a)},"undefined"==typeof e.getSettings().observeChanges&&a.call(e),"afterInit"==b&&(i.call(e),e.addHook("afterCreateRow",f.afterCreateRow),e.addHook("afterRemoveRow",f.afterRemoveRow),e.addHook("afterLoadData",f.init))}else delete e.sort,e.removeHook("afterCreateRow",f.afterCreateRow),e.removeHook("afterRemoveRow",f.afterRemoveRow),e.removeHook("afterLoadData",f.init)},this.setSortingColumn=function(a,b){var c=this;return"undefined"==typeof a?(delete c.sortColumn,void delete c.sortOrder):(c.sortOrder=c.sortColumn===a&&"undefined"==typeof b?!c.sortOrder:"undefined"!=typeof b?b:!0,void(c.sortColumn=a))},this.sortByColumn=function(a,c){var d=this;f.setSortingColumn.call(d,a,c),"undefined"!=typeof d.sortColumn&&(b.hooks.run(d,"beforeColumnSort",d.sortColumn,d.sortOrder),f.sort.call(d),d.render(),g.call(d),b.hooks.run(d,"afterColumnSort",d.sortColumn,d.sortOrder))};var g=function(){var a=this,c={};"undefined"!=typeof a.sortColumn&&(c.sortColumn=a.sortColumn),"undefined"!=typeof a.sortOrder&&(c.sortOrder=a.sortOrder),(c.hasOwnProperty("sortColumn")||c.hasOwnProperty("sortOrder"))&&b.hooks.run(a,"persistentStateSave","columnSorting",c)},h=function(){var a=this,c={};return b.hooks.run(a,"persistentStateLoad","columnSorting",c),c.value},i=function(){function a(){var a=d.view.TBODY.querySelector("tr").querySelectorAll("th");return a.length}function c(c){var d=b.Dom.closest(c,"TH");return b.Dom.index(d)-a()}var d=this,e=b.eventManager(d);e.addEventListener(d.rootElement,"click",function(a){if(b.Dom.hasClass(a.target,"columnSorting")){var e=c(a.target);f.sortByColumn.call(d,e)}})};this.sort=function(){var a=this;if("undefined"!=typeof a.sortOrder){a.sortingEnabled=!1,a.sortIndex.length=0;for(var b=this.colOffset(),e=0,f=this.countRows()-a.getSettings().minSpareRows;f>e;e++)this.sortIndex.push([e,a.getDataAtCell(e,this.sortColumn+b)]);var g,h=a.getCellMeta(0,a.sortColumn);switch(h.type){case"date":g=d;break;default:g=c}this.sortIndex.sort(g(a.sortOrder));for(var e=this.sortIndex.length;e<a.countRows();e++)this.sortIndex.push([e,a.getDataAtCell(e,this.sortColumn+b)]);a.sortingEnabled=!0}},this.translateRow=function(a){var b=this;return b.sortingEnabled&&b.sortIndex&&b.sortIndex.length&&b.sortIndex[a]?b.sortIndex[a][0]:a},this.untranslateRow=function(a){var b=this;if(b.sortingEnabled&&b.sortIndex&&b.sortIndex.length)for(var c=0;c<b.sortIndex.length;c++)if(b.sortIndex[c][0]==a)return c},this.getColHeader=function(a,c){this.getSettings().columnSorting&&a>=0&&b.Dom.addClass(c.querySelector(".colHeader"),"columnSorting")},this.afterCreateRow=function(a,b){var c=this;if(e(c)){for(var d=0;d<c.sortIndex.length;d++)c.sortIndex[d][0]>=a&&(c.sortIndex[d][0]+=b);for(var d=0;b>d;d++)c.sortIndex.splice(a+d,0,[a+d,c.getData()[a+d][c.sortColumn+c.colOffset()]]);g.call(c)}},this.afterRemoveRow=function(a,b){var c=this;if(e(c)){var d=f.translateRow.call(c,a);c.sortIndex.splice(a,b);for(var h=0;h<c.sortIndex.length;h++)c.sortIndex[h][0]>d&&(c.sortIndex[h][0]-=b);g.call(c)}},this.afterChangeSort=function(a){var b=this,c=!1,d={};if(a){for(var e=0;e<a.length;e++)if(a[e][1]==b.sortColumn){c=!0,d.row=f.translateRow.call(b,a[e][0]),d.col=a[e][1];break}c&&b._registerTimeout(setTimeout(function(){f.sort.call(b),b.render(),b.selectCell(f.untranslateRow.call(b,d.row),d.col)},0))}}}function e(a){var c=b.eventManager(a),d=function(a,b,c,d){d.setCellMeta(a,b,"comment",c),d.render()},e=function(a,b,c){d(a.from.row,a.from.col,b,c)},f=function(){var a=j();a.style.display="none",a.value=""},g=function(d){function g(b){if(c.removeEventListener(document,"mouseover"),"htCommentTextArea"!=b.target.className&&-1==b.target.innerHTML.indexOf("Comment")){var g=document.querySelector(".htCommentTextArea").value;g.trim().length>1&&e(d,g,a),h(),f()}}c.addEventListener(document,"mousedown",b.helper.proxy(g))},h=function(){c.removeEventListener(document,"mousedown"),c.addEventListener(document,"mousedown",b.helper.proxy(k))},i=function(c,d){var e=a.view.wt.wtTable.getCell(c.from),f=b.Dom.offset(e),h=a.getColWidth(c.from.col);d.style.position="absolute",d.style.left=f.left+h+"px",d.style.top=f.top+"px",d.style.zIndex=2,g(c,d)},j=function(a){var c=document.querySelector(".htComments");if(!c){c=document.createElement("DIV");var d=document.createElement("TEXTAREA");b.Dom.addClass(d,"htCommentTextArea"),c.appendChild(d),b.Dom.addClass(c,"htComments"),document.getElementsByTagName("body")[0].appendChild(c)}return a=a||"",document.querySelector(".htCommentTextArea").value=a,c},k=function(c){if(-1!=c.target.className.indexOf("htCommentCell")){h();var d=a.view.wt.wtTable.getCoords(c.target),e={from:new l(d.row,d.col)};b.Comments.showComment(e)}else"htCommentTextArea"!=c.target.className&&f()};return{init:function(){c.addEventListener(document,"mouseover",b.helper.proxy(k))},showComment:function(b){var c=a.getCellMeta(b.from.row,b.from.col),d="";c.comment&&(d=c.comment);var e=j(d);e.style.display="block",i(b,e)},removeComment:function(b,c){a.removeCellMeta(b,c,"comment"),a.render()},checkSelectionCommentsConsistency:function(){var b=!1,c=a.getSelectedRange().from;return a.getCellMeta(c.row,c.col).comment&&(b=!0),b}}}function f(b){var c,d=function(){a.localStorage[b+"__persistentStateKeys"]=JSON.stringify(c)},e=function(){var d=a.localStorage[b+"__persistentStateKeys"],e="string"==typeof d?JSON.parse(d):void 0;c=e?e:[]},f=function(){c=[],d()};e(),this.saveValue=function(e,f){a.localStorage[b+"_"+e]=JSON.stringify(f),-1==c.indexOf(e)&&(c.push(e),d())},this.loadValue=function(c,d){c="undefined"!=typeof c?c:d;var e=a.localStorage[b+"_"+c];return"undefined"==typeof e?void 0:JSON.parse(e)},this.reset=function(c){a.localStorage.removeItem(b+"_"+c)},this.resetAll=function(){for(var d=0;d<c.length;d++)a.localStorage.removeItem(b+"_"+c[d]);f()}}function g(){this.boundaries=null,this.callback=null}function h(){var a=[];return a.getInfo=function(a,b){for(var c=0,d=this.length;d>c;c++)if(this[c].row<=a&&this[c].row+this[c].rowspan-1>=a&&this[c].col<=b&&this[c].col+this[c].colspan-1>=b)return this[c]},a.setInfo=function(a){for(var b=0,c=this.length;c>b;b++)if(this[b].row===a.row&&this[b].col===a.col)return void(this[b]=a);this.push(a)},a.removeInfo=function(a,b){for(var c=0,d=this.length;d>c;c++)if(this[c].row===a&&this[c].col===b){this.splice(c,1);break}},a}function i(a){if(this.mergedCellInfoCollection=new h,b.helper.isArray(a))for(var c=0,d=a.length;d>c;c++)this.mergedCellInfoCollection.setInfo(a[c])}function j(){}function k(a,c){var d,e=function(){this.selectionHandles={topLeft:document.createElement("DIV"),topLeftHitArea:document.createElement("DIV"),bottomRight:document.createElement("DIV"),bottomRightHitArea:document.createElement("DIV")};var a=10,b=40;this.selectionHandles.topLeft.className="topLeftSelectionHandle",this.selectionHandles.topLeftHitArea.className="topLeftSelectionHandle-HitArea",this.selectionHandles.bottomRight.className="bottomRightSelectionHandle",this.selectionHandles.bottomRightHitArea.className="bottomRightSelectionHandle-HitArea",this.selectionHandles.styles={topLeft:this.selectionHandles.topLeft.style,topLeftHitArea:this.selectionHandles.topLeftHitArea.style,bottomRight:this.selectionHandles.bottomRight.style,bottomRightHitArea:this.selectionHandles.bottomRightHitArea.style};var c={position:"absolute",height:b+"px",width:b+"px","border-radius":parseInt(b/1.5,10)+"px"};for(var d in c)this.selectionHandles.styles.bottomRightHitArea[d]=c[d],this.selectionHandles.styles.topLeftHitArea[d]=c[d];var e={position:"absolute",height:a+"px",width:a+"px","border-radius":parseInt(a/1.5,10)+"px",background:"#F5F5FF",border:"1px solid #4285c8"};for(var d in e)this.selectionHandles.styles.bottomRight[d]=e[d],this.selectionHandles.styles.topLeft[d]=e[d];this.main.appendChild(this.selectionHandles.topLeft),this.main.appendChild(this.selectionHandles.bottomRight),this.main.appendChild(this.selectionHandles.topLeftHitArea),this.main.appendChild(this.selectionHandles.bottomRightHitArea)};if(c){var f=b.eventManager(a);this.instance=a,this.settings=c,this.main=document.createElement("div"),d=this.main.style,d.position="absolute",d.top=0,d.left=0;for(var g=["top","left","bottom","right","corner"],h=0;5>h;h++){var i=g[h],j=document.createElement("DIV");j.className="wtBorder "+(this.settings.className||""),this.settings[i]&&this.settings[i].hide&&(j.className+=" hidden"),d=j.style,d.backgroundColor=this.settings[i]&&this.settings[i].color?this.settings[i].color:c.border.color,d.height=this.settings[i]&&this.settings[i].width?this.settings[i].width+"px":c.border.width+"px",d.width=this.settings[i]&&this.settings[i].width?this.settings[i].width+"px":c.border.width+"px",this.main.appendChild(j)}this.top=this.main.childNodes[0],this.left=this.main.childNodes[1],this.bottom=this.main.childNodes[2],this.right=this.main.childNodes[3],this.topStyle=this.top.style,this.leftStyle=this.left.style,this.bottomStyle=this.bottom.style,this.rightStyle=this.right.style,this.corner=this.main.childNodes[4],this.corner.className+=" corner",this.cornerStyle=this.corner.style,this.cornerStyle.width="5px",this.cornerStyle.height="5px",this.cornerStyle.border="2px solid #FFF",b.mobileBrowser&&e.call(this),this.disappear(),a.wtTable.bordersHolder||(a.wtTable.bordersHolder=document.createElement("div"),a.wtTable.bordersHolder.className="htBorders",a.wtTable.hider.appendChild(a.wtTable.bordersHolder)),a.wtTable.bordersHolder.insertBefore(this.main,a.wtTable.bordersHolder.firstChild);var k=!1;f.addEventListener(document.body,"mousedown",function(){k=!0}),f.addEventListener(document.body,"mouseup",function(){k=!1});for(var l=0,m=this.main.childNodes.length;m>l;l++)f.addEventListener(this.main.childNodes[l],"mouseenter",function(b){if(k&&a.getSetting("hideBorderOnMouseDownOver")){b.preventDefault(),b.stopImmediatePropagation();var c=this.getBoundingClientRect();this.style.display="none";var d=function(a){return a.clientY<Math.floor(c.top)?!0:a.clientY>Math.ceil(c.top+c.height)?!0:a.clientX<Math.floor(c.left)?!0:a.clientX>Math.ceil(c.left+c.width)?!0:void 0},e=function(a){d(a)&&(f.removeEventListener(document.body,"mousemove",e),this.style.display="block")};f.addEventListener(document.body,"mousemove",e)}})}}function l(a,b){"undefined"!=typeof a&&"undefined"!=typeof b?(this.row=a,this.col=b):(this.row=null,this.col=null)}function m(a,b,c){this.highlight=a,this.from=b,this.to=c}function n(a,b){this.total=a,this.countTH=b}function o(a,b,c,d){var e,f=0;for(this.instance=a,this.containerSizeFn=b,this.cellSizesSum=0,this.cellSizes=[],this.cellStretch=[],this.cellCount=0,this.visibleCellCount=0,this.remainingSize=0,this.strategy=d;;){if(e=c(f),void 0===e)break;this.cellSizesSum<this.getContainerSize()&&this.visibleCellCount++,this.cellSizes.push(e),this.cellSizesSum+=e,this.cellCount++,f++}var g=this.getContainerSize();this.remainingSize=this.cellSizesSum-g}function p(a){var c=[];if(this.guid="wt_"+s(),a.cloneSource?(this.cloneSource=a.cloneSource,this.cloneOverlay=a.cloneOverlay,this.wtSettings=a.cloneSource.wtSettings,this.wtTable=new B(this,a.table),this.wtScroll=new u(this),this.wtViewport=a.cloneSource.wtViewport,this.wtEvent=new r(this),this.selections=this.cloneSource.selections):(this.wtSettings=new A(this,a),this.wtTable=new B(this,a.table),this.wtScroll=new u(this),this.wtViewport=new D(this),this.wtEvent=new r(this),this.selections=this.getSetting("selections"),this.wtScrollbars=new y(this)),this.wtTable.THEAD.childNodes.length&&this.wtTable.THEAD.childNodes[0].childNodes.length){for(var d=0,e=this.wtTable.THEAD.childNodes[0].childNodes.length;e>d;d++)c.push(this.wtTable.THEAD.childNodes[0].childNodes[d].innerHTML);this.getSetting("columnHeaders").length||this.update("columnHeaders",[function(a,d){b.Dom.fastInnerText(d,c[a])}])}this.drawn=!1,this.drawInterrupted=!1}function q(a){this.instance=a,this.init(),this.clone=this.makeClone("debug"),this.clone.wtTable.holder.style.opacity=.4,this.clone.wtTable.holder.style.textShadow="0 0 2px #ff0000",this.lastTimeout=null,b.Dom.addClass(this.clone.wtTable.holder.parentNode,"wtDebugVisible")}function r(c){var d=this,e=b.eventManager(c);this.instance=c;var f=[null,null];this.dblClickTimeout=[null,null];var g,h,i=function(a){var c=d.parentCell(a.target);b.Dom.hasClass(a.target,"corner")?d.instance.getSetting("onCellCornerMouseDown",a,a.target):c.TD&&d.instance.hasSetting("onCellMouseDown")&&d.instance.getSetting("onCellMouseDown",a,c.coords,c.TD,d.instance),2!==a.button&&c.TD&&(f[0]=c.TD,clearTimeout(d.dblClickTimeout[0]),d.dblClickTimeout[0]=setTimeout(function(){f[0]=null},1e3))},j=function(){d.instance.touchMoving=!0},k=function(a){e.addEventListener(this,"touchmove",j),d.checkIfTouchMove=setTimeout(function(){return 1==d.instance.touchMoving?(d.instance.touchMoving=void 0,void e.removeEventListener("touchmove",j,!1)):void i(a)},30)},l=function(a){if(d.instance.hasSetting("onCellMouseOver")){var c=d.instance.wtTable.TABLE,e=b.Dom.closest(a.target,["TD","TH"],c);e&&e!==h&&b.Dom.isChildOf(e,c)&&(h=e,d.instance.getSetting("onCellMouseOver",a,d.instance.wtTable.getCoords(e),e,d.instance))}},m=function(a){if(2!==a.button){var c=d.parentCell(a.target);c.TD===f[0]&&c.TD===f[1]?(b.Dom.hasClass(a.target,"corner")?d.instance.getSetting("onCellCornerDblClick",a,c.coords,c.TD,d.instance):d.instance.getSetting("onCellDblClick",a,c.coords,c.TD,d.instance),f[0]=null,f[1]=null):c.TD===f[0]&&(f[1]=c.TD,clearTimeout(d.dblClickTimeout[1]),d.dblClickTimeout[1]=setTimeout(function(){f[1]=null},500))}},n=function(a){clearTimeout(g),a.preventDefault(),m(a)};if(e.addEventListener(this.instance.wtTable.holder,"mousedown",i),e.addEventListener(this.instance.wtTable.TABLE,"mouseover",l),e.addEventListener(this.instance.wtTable.holder,"mouseup",m),this.instance.wtTable.holder.parentNode.parentNode&&b.mobileBrowser){var o="."+this.instance.wtTable.holder.parentNode.className.split(" ").join(".");e.addEventListener(this.instance.wtTable.holder.parentNode.parentNode,"touchstart",function(a){d.instance.touchApplied=!0,b.Dom.isChildOf(a.target,o)&&k.call(a.target,a)}),e.addEventListener(this.instance.wtTable.holder.parentNode.parentNode,"touchend",function(a){d.instance.touchApplied=!1,b.Dom.isChildOf(a.target,o)&&n.call(a.target,a)}),d.instance.momentumScrolling||(d.instance.momentumScrolling={}),e.addEventListener(this.instance.wtTable.holder.parentNode.parentNode,"scroll",function(){clearTimeout(d.instance.momentumScrolling._timeout),d.instance.momentumScrolling.ongoing||d.instance.getSetting("onBeforeTouchScroll"),d.instance.momentumScrolling.ongoing=!0,d.instance.momentumScrolling._timeout=setTimeout(function(){d.instance.touchApplied||(d.instance.momentumScrolling.ongoing=!1,d.instance.getSetting("onAfterMomentumScroll"))},200)})}e.addEventListener(a,"resize",function(){d.instance.draw()}),this.destroy=function(){clearTimeout(this.dblClickTimeout[0]),clearTimeout(this.dblClickTimeout[1]),e.clear()}}function s(){function a(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return a()+a()+a()+a()}function t(a,b,c){this.offset=a,this.total=b,this.countTH=c}function u(a){this.instance=a}function v(a){this.instance=a,this.type="corner",this.init(),this.clone=this.makeClone("corner")}function w(a){this.instance=a,this.type="horizontal",this.cellSize=50,this.offset=0,this.init(),this.clone=this.makeClone("left")}function x(a){this.instance=a,this.type="vertical",this.init(),this.clone=this.makeClone("top")}function y(a){this.instance=a,a.update("scrollbarWidth",b.Dom.getScrollbarWidth()),a.update("scrollbarHeight",b.Dom.getScrollbarWidth()),this.vertical=new x(a),this.horizontal=new w(a),this.corner=new v(a),a.getSetting("debug")&&(this.debug=new q(a)),this.registerListeners()}function z(a,b){this.settings=a,this.cellRange=b||null,this.instanceBorders={}}function A(a,c){var d=this;this.instance=a,this.defaults={table:void 0,debug:!1,stretchH:"none",currentRowClassName:null,currentColumnClassName:null,data:void 0,fixedColumnsLeft:0,fixedRowsTop:0,rowHeaders:function(){return[]},columnHeaders:function(){return[]},totalRows:void 0,totalColumns:void 0,cellRenderer:function(a,c,e){var f=d.getSetting("data",a,c);b.Dom.fastInnerText(e,void 0===f||null===f?"":f)},columnWidth:50,rowHeight:function(){},defaultRowHeight:23,selections:null,hideBorderOnMouseDownOver:!1,viewportRowCalculatorOverride:null,onCellMouseDown:null,onCellMouseOver:null,onCellDblClick:null,onCellCornerMouseDown:null,onCellCornerDblClick:null,beforeDraw:null,onDraw:null,onBeforeDrawBorders:null,onScrollVertically:null,onScrollHorizontally:null,onBeforeTouchScroll:null,onAfterMomentumScroll:null,scrollbarWidth:10,scrollbarHeight:10,renderAllRows:!1,groups:!1},this.settings={};for(var e in this.defaults)if(this.defaults.hasOwnProperty(e))if(void 0!==c[e])this.settings[e]=c[e];else{if(void 0===this.defaults[e])throw new Error('A required setting "'+e+'" was not provided');this.settings[e]=this.defaults[e]}}function B(a,c){this.instance=a,this.TABLE=c,b.Dom.removeTextNodes(this.TABLE);var d=this.TABLE.parentNode;if(!d||1!==d.nodeType||!b.Dom.hasClass(d,"wtHolder")){var e=document.createElement("DIV");e.className="wtSpreader",d&&d.insertBefore(e,this.TABLE),e.appendChild(this.TABLE)}if(this.spreader=this.TABLE.parentNode,d=this.spreader.parentNode,!d||1!==d.nodeType||!b.Dom.hasClass(d,"wtHolder")){var f=document.createElement("DIV");f.className="wtHider",d&&d.insertBefore(f,this.spreader),f.appendChild(this.spreader)}if(this.hider=this.spreader.parentNode,this.hiderStyle=this.hider.style,this.hiderStyle.position="relative",d=this.hider.parentNode,!d||1!==d.nodeType||!b.Dom.hasClass(d,"wtHolder")){var g=document.createElement("DIV");g.style.position="relative",g.className="wtHolder",a.cloneSource||(g.className+=" ht_master"),d&&d.insertBefore(g,this.hider),g.appendChild(this.hider)}if(this.holder=this.hider.parentNode,this.isWorkingOnClone()||(this.holder.parentNode.style.position="relative"),this.TBODY=this.TABLE.getElementsByTagName("TBODY")[0],this.TBODY||(this.TBODY=document.createElement("TBODY"),this.TABLE.appendChild(this.TBODY)),this.THEAD=this.TABLE.getElementsByTagName("THEAD")[0],this.THEAD||(this.THEAD=document.createElement("THEAD"),this.TABLE.insertBefore(this.THEAD,this.TBODY)),this.COLGROUP=this.TABLE.getElementsByTagName("COLGROUP")[0],this.COLGROUP||(this.COLGROUP=document.createElement("COLGROUP"),this.TABLE.insertBefore(this.COLGROUP,this.THEAD)),this.instance.getSetting("columnHeaders").length&&!this.THEAD.childNodes.length){var h=document.createElement("TR");this.THEAD.appendChild(h)}this.colgroupChildrenLength=this.COLGROUP.childNodes.length,this.theadChildrenLength=this.THEAD.firstChild?this.THEAD.firstChild.childNodes.length:0,this.tbodyChildrenLength=this.TBODY.childNodes.length,this.rowFilter=null,this.columnFilter=null,this.columnWidthCache=[]}function C(a){this.wtTable=a,this.instance=a.instance,this.rowFilter=a.rowFilter,this.columnFilter=a.columnFilter,this.TABLE=a.TABLE,this.THEAD=a.THEAD,this.TBODY=a.TBODY,this.COLGROUP=a.COLGROUP,this.utils=C.utils}function D(c){this.instance=c,this.oversizedRows=[];var d=this,e=b.eventManager(c);e.addEventListener(a,"resize",function(){d.clientHeight=d.getWorkspaceHeight()})}function E(a,b,c,d,e){this.scrollOffset=b,this.renderStartRow=null,this.renderStartPosition=null,this.renderEndRow=null,this.countRendered=0,this.visibleStartRow=null,this.visibleEndRow=null,this.countVisible=0;for(var f,g=0,h=!0,i=23,j=[],k=0;c>k;k++)if(f=d(k),void 0===f&&(f=i),b>=g&&(this.renderStartRow=k),g>=b&&b+a>=g+f&&(null==this.visibleStartRow&&(this.visibleStartRow=k),this.visibleEndRow=k),j.push(g),g+=f,this.renderEndRow=k,g>=b+a){h=!1;break}if(this.renderEndRow==c-1&&h)for(this.renderStartRow=this.renderEndRow,this.visibleStartRow=this.renderEndRow,this.visibleEndRow=this.renderEndRow;this.renderStartRow>0;){this.renderStartRow--;var l=j[this.renderEndRow]+f-j[this.renderStartRow];if(a>=l&&(this.visibleStartRow=this.renderStartRow),l>=a)break}null!==this.renderStartRow&&e&&e(this),this.renderStartPosition=j[this.renderStartRow],void 0==this.renderStartPosition&&(this.renderStartPosition=null),null!=this.renderStartRow&&(this.countRendered=this.renderEndRow-this.renderStartRow+1),null!=this.visibleStartRow&&(this.countVisible=this.visibleEndRow-this.visibleStartRow+1)}Array.prototype.indexOf||(Array.prototype.indexOf=function(a){var b=this.length>>>0,c=Number(arguments[1])||0;for(c=0>c?Math.ceil(c):Math.floor(c),0>c&&(c+=b);b>c;c++)if(c in this&&this[c]===a)return c;return-1}),Array.prototype.filter||(Array.prototype.filter=function(a,b){function c(a){return/NodeList/i.test(a.item)}function d(a){for(var b=[],c=0,d=a.length;d>c;c++)b[c]=a[c];return b}if("undefined"==typeof this||null===this)throw new TypeError;if("function"!=typeof a)throw new TypeError;b=b||this,c(b)&&(b=d(b));var e,f,g=b.length,h=[];for(e=0;g>e;e+=1)b.hasOwnProperty(e)&&(f=b[e],a.call(b,f,e,b)&&h.push(f));return h}),Array.isArray||(Array.isArray=function(a){return"[object Array]"===Object.prototype.toString.call(a)}),Object.keys||(Object.keys=function(){var a=Object.prototype.hasOwnProperty,b=!{toString:null}.propertyIsEnumerable("toString"),c=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],d=c.length;return function(e){if("object"!=typeof e&&("function"!=typeof e||null===e))throw new TypeError("Object.keys called on non-object");var f,g,h=[];for(f in e)a.call(e,f)&&h.push(f);if(b)for(g=0;d>g;g++)a.call(e,c[g])&&h.push(c[g]);return h}}()),"undefined"==typeof WeakMap&&!function(){var b=Object.defineProperty;try{var c=!0;b(function(){},"foo",{})}catch(d){c=!1}var e=+new Date%1e9,f=function(){this.name="__st"+(1e9*Math.random()>>>0)+(e++ +"__"),c||(this._wmCache=[])};f.prototype=c?{set:function(a,c){var d=a[this.name];d&&d[0]===a?d[1]=c:b(a,this.name,{value:[a,c],writable:!0})},get:function(a){var b;return(b=a[this.name])&&b[0]===a?b[1]:void 0},"delete":function(a){this.set(a,void 0)}}:{set:function(a,b){if("undefined"!=typeof a&&"undefined"!=typeof b){for(var c=0,d=this._wmCache.length;d>c;c++)if(this._wmCache[c].key==a)return void(this._wmCache[c].value=b);this._wmCache.push({key:a,value:b})}},get:function(a){if("undefined"!=typeof a)for(var b=0,c=this._wmCache.length;c>b;b++)if(this._wmCache[b].key==a)return this._wmCache[b].value},"delete":function(a){if("undefined"!=typeof a)for(var b=0,c=this._wmCache.length;c>b;b++)this._wmCache[b].key==a&&Array.prototype.slice.call(this._wmCache,b,1)}},a.WeakMap=f}(),b.activeGuid=null,b.Core=function(a,c){function d(){var a=!1;return{validatorsInQueue:0,addValidatorToQueue:function(){this.validatorsInQueue++,a=!1},removeValidatorFormQueue:function(){this.validatorsInQueue=this.validatorsInQueue-1<0?0:this.validatorsInQueue-1,this.checkIfQueueIsEmpty()},onQueueEmpty:function(){},checkIfQueueIsEmpty:function(){0==this.validatorsInQueue&&0==a&&(a=!0,this.onQueueEmpty())}}}function e(a,c,e){function f(){var d;a.length&&(d=b.hooks.execute(s,"beforeChange",a,c),"function"==typeof d?console.warn("Your beforeChange callback returns a function. It's not supported since Handsontable 0.12.1 (and the returned function will not be executed)."):d===!1&&a.splice(0,a.length)),e()}var g=new d;g.onQueueEmpty=f;for(var h=a.length-1;h>=0;h--)if(null===a[h])a.splice(h,1);else{var i=a[h][0],j=o.propToCol(a[h][1]),k=s.runHooksAndReturn("modifyCol",j),l=s.getCellMeta(i,k);if("numeric"===l.type&&"string"==typeof a[h][3]&&a[h][3].length>0&&(/^-?[\d\s]*(\.|\,)?\d*$/.test(a[h][3])||l.format)){var m=a[h][3].length;numeral.language("undefined"==typeof l.language?"en":a[h][3].indexOf(".")===m-3&&-1===a[h][3].indexOf(",")?"en":l.language),a[h][3]=numeral().unformat(a[h][3]||"0")}s.getCellValidator(l)&&(g.addValidatorToQueue(),s.validateCell(a[h][3],l,function(b,c){return function(d){if("boolean"!=typeof d)throw new Error("Validation error: result is not boolean");d===!1&&c.allowInvalid===!1&&(a.splice(b,1),c.valid=!0,--b),g.removeValidatorFormQueue()}}(h,l),c))}g.checkIfQueueIsEmpty()}function f(a,c){var d=a.length-1;if(!(0>d)){for(;d>=0;d--)if(null!==a[d]){if(null!=a[d][2]||null!=a[d][3]){if(n.settings.allowInsertRow)for(;a[d][0]>s.countRows()-1;)o.createRow();if("array"===s.dataType&&n.settings.allowInsertColumn)for(;o.propToCol(a[d][1])>s.countCols()-1;)o.createCol();o.set(a[d][0],a[d][1],a[d][3])}}else a.splice(d,1);s.forceFullRender=!0,p.adjustRowsAndCols(),b.hooks.run(s,"beforeChangeRender",a,c),q.refreshBorders(null,!0),b.hooks.run(s,"afterChange",a,c||"edit")}}function g(a,b,c){return"object"==typeof a?a:[[a,b,c]]}function h(a){if(a.hasOwnProperty("type")){var c,d={};if("object"==typeof a.type)c=a.type;else if("string"==typeof a.type&&(c=b.cellTypes[a.type],void 0===c))throw new Error('You declared cell type "'+a.type+'" as a string that is not mapped to a known object. Cell type must be an object or a string mapped to an object in Handsontable.cellTypes');for(var e in c)c.hasOwnProperty(e)&&!a.hasOwnProperty(e)&&(d[e]=c[e]);return d}}function i(a){return b.hooks.execute(s,"modifyRow",a)}function j(a){return b.hooks.execute(s,"modifyCol",a)}function k(){throw new Error("This method cannot be called because this Handsontable instance has been destroyed")}var n,o,p,q,r,s=this,t=function(){},u=b.eventManager(s);b.helper.extend(t.prototype,F.prototype),b.helper.extend(t.prototype,c),b.helper.extend(t.prototype,h(c)),this.rootElement=a,this.container=document.createElement("DIV"),this.container.className="htContainer",a.insertBefore(this.container,a.firstChild),this.guid="ht_"+b.helper.randomString(),this.rootElement.id&&"ht_"!==this.rootElement.id.substring(0,3)||(this.rootElement.id=this.guid),n={cellSettings:[],columnSettings:[],columnsSettingConflicts:["data","width"],settings:new t,selRange:null,isPopulated:null,scrollable:null,firstRun:!0},p={alter:function(a,c,d,e,f){var g;switch(d=d||1,a){case"insert_row":g=o.createRow(c,d),g&&(q.isSelected()&&n.selRange.from.row>=c?(n.selRange.from.row=n.selRange.from.row+g,q.transformEnd(g,0)):q.refreshBorders());break;case"insert_col":if(g=o.createCol(c,d)){if(b.helper.isArray(s.getSettings().colHeaders)){var h=[c,0];h.length+=g,Array.prototype.splice.apply(s.getSettings().colHeaders,h)}q.isSelected()&&n.selRange.from.col>=c?(n.selRange.from.col=n.selRange.from.col+g,q.transformEnd(0,g)):q.refreshBorders()}break;case"remove_row":c=s.runHooksAndReturn("modifyCol",c),o.removeRow(c,d),n.cellSettings.splice(c,d),p.adjustRowsAndCols(),q.refreshBorders();break;case"remove_col":o.removeCol(c,d);for(var i=0,j=o.getAll().length;j>i;i++)i in n.cellSettings&&n.cellSettings[i].splice(c,d);b.helper.isArray(s.getSettings().colHeaders)&&("undefined"==typeof c&&(c=-1),s.getSettings().colHeaders.splice(c,d)),p.adjustRowsAndCols(),q.refreshBorders();break;default:throw new Error('There is no such action "'+a+'"')}f||p.adjustRowsAndCols()},adjustRowsAndCols:function(){var a,b,c,d;if(b=s.countRows(),b<n.settings.minRows)for(a=0;a<n.settings.minRows-b;a++)o.createRow(s.countRows(),1,!0);if(c=s.countEmptyRows(!0),c<n.settings.minSpareRows)for(;c<n.settings.minSpareRows&&s.countRows()<n.settings.maxRows;c++)o.createRow(s.countRows(),1,!0);if(d=s.countEmptyCols(!0),!n.settings.columns&&s.countCols()<n.settings.minCols)for(;s.countCols()<n.settings.minCols;d++)o.createCol(s.countCols(),1,!0);if(!n.settings.columns&&"array"===s.dataType&&d<n.settings.minSpareCols)for(;d<n.settings.minSpareCols&&s.countCols()<n.settings.maxCols;d++)o.createCol(s.countCols(),1,!0);var e=s.countRows(),f=s.countCols();if((0===e||0===f)&&q.deselect(),q.isSelected()){var g,h=n.selRange.from.row,i=n.selRange.from.col,j=n.selRange.to.row,k=n.selRange.to.col;h>e-1?(h=e-1,g=!0,j>h&&(j=h)):j>e-1&&(j=e-1,g=!0,h>j&&(h=j)),i>f-1?(i=f-1,g=!0,k>i&&(k=i)):k>f-1&&(k=f-1,g=!0,i>k&&(i=k)),g&&s.selectCell(h,i,j,k)}},populateFromArray:function(a,c,d,e,f,g,h){var i,j,k,l,m=[],o={};if(j=c.length,0===j)return!1;var p,q,r,t;switch(f){case"shift_down":for(p=d?d.col-a.col+1:0,q=d?d.row-a.row+1:0,c=b.helper.translateRowsToColumns(c),k=0,l=c.length,r=Math.max(l,p);r>k;k++)if(l>k){for(i=0,j=c[k].length;q-j>i;i++)c[k].push(c[k][i%j]);c[k].unshift(a.col+k,a.row,0),s.spliceCol.apply(s,c[k])}else c[k%l][0]=a.col+k,s.spliceCol.apply(s,c[k%l]);break;case"shift_right":for(p=d?d.col-a.col+1:0,q=d?d.row-a.row+1:0,i=0,j=c.length,t=Math.max(j,q);t>i;i++)if(j>i){for(k=0,l=c[i].length;p-l>k;k++)c[i].push(c[i][k%l]);c[i].unshift(a.row+i,a.col,0),s.spliceRow.apply(s,c[i])}else c[i%j][0]=a.row+i,s.spliceRow.apply(s,c[i%j]);break;case"overwrite":default:o.row=a.row,o.col=a.col;var u={row:0,col:0},v={row:d&&a?d.row-a.row+1:1,col:d&&a?d.col-a.col+1:1};for(-1!==["up","left"].indexOf(g)?u={row:Math.ceil(v.row/j)||1,col:Math.ceil(v.col/c[0].length)||1}:-1!==["down","right"].indexOf(g)&&(u={row:1,col:1}),i=0;j>i&&!(d&&o.row>d.row||!n.settings.allowInsertRow&&o.row>s.countRows()-1||o.row>=n.settings.maxRows);i++){for(o.col=a.col,l=c[i]?c[i].length:0,k=0;l>k&&!(d&&o.col>d.col||!n.settings.allowInsertColumn&&o.col>s.countCols()-1||o.col>=n.settings.maxCols);k++){if(!s.getCellMeta(o.row,o.col).readOnly){var w,x=c[i][k],y={row:i,col:k};"autofill"===e&&(w=s.runHooksAndReturn("beforeAutofillInsidePopulate",y,g,c,h,u,v),w&&(u="undefined"!=typeof w.iterators?w.iterators:u,x="undefined"!=typeof w.value?w.value:x)),m.push([o.row,o.col,x])}o.col++,d&&k===l-1&&(k=-1,-1!==["down","right"].indexOf(g)?u.col++:-1!==["up","left"].indexOf(g)&&u.col>1&&u.col--)}o.row++,u.col=1,d&&i===j-1&&(i=-1,-1!==["down","right"].indexOf(g)?u.row++:-1!==["up","left"].indexOf(g)&&u.row>1&&u.row--)}s.setDataAtCell(m,null,null,e||"populateFromArray")}}},this.selection=q={inProgress:!1,selectedHeader:{cols:!1,rows:!1},setSelectedHeaders:function(a,b){s.selection.selectedHeader.rows=a,s.selection.selectedHeader.cols=b},begin:function(){s.selection.inProgress=!0},finish:function(){var a=s.getSelected();b.hooks.run(s,"afterSelectionEnd",a[0],a[1],a[2],a[3]),b.hooks.run(s,"afterSelectionEndByProp",a[0],s.colToProp(a[1]),a[2],s.colToProp(a[3])),s.selection.inProgress=!1},isInProgress:function(){return s.selection.inProgress},setRangeStart:function(a,c){b.hooks.run(s,"beforeSetRangeStart",a),n.selRange=new m(a,a,a),q.setRangeEnd(a,null,c)},setRangeEnd:function(a,c,d){b.hooks.run(s,"beforeSetRangeEnd",a),s.selection.begin(),n.selRange.to=new l(a.row,a.col),n.settings.multiSelect||(n.selRange.from=a),s.view.wt.selections.current.clear(),s.view.wt.selections.current.add(n.selRange.highlight),s.view.wt.selections.area.clear(),q.isMultiple()&&(s.view.wt.selections.area.add(n.selRange.from),s.view.wt.selections.area.add(n.selRange.to)),(n.settings.currentRowClassName||n.settings.currentColClassName)&&(s.view.wt.selections.highlight.clear(),s.view.wt.selections.highlight.add(n.selRange.from),s.view.wt.selections.highlight.add(n.selRange.to)),b.hooks.run(s,"afterSelection",n.selRange.from.row,n.selRange.from.col,n.selRange.to.row,n.selRange.to.col),b.hooks.run(s,"afterSelectionByProp",n.selRange.from.row,o.colToProp(n.selRange.from.col),n.selRange.to.row,o.colToProp(n.selRange.to.col)),c!==!1&&s.view.mainViewIsActive()&&s.view.scrollViewport(a),q.refreshBorders(null,d)
},refreshBorders:function(a,b){b||r.destroyEditor(a),s.view.render(),q.isSelected()&&!b&&r.prepareEditor()},isMultiple:function(){var a=!(n.selRange.to.col===n.selRange.from.col&&n.selRange.to.row===n.selRange.from.row),c=b.hooks.execute(s,"afterIsMultipleSelection",a);return a?c:void 0},transformStart:function(a,b,c,d){var e=new l(a,b);s.runHooks("modifyTransformStart",e),n.selRange.highlight.row+a>s.countRows()-1?c&&n.settings.minSpareRows>0?s.alter("insert_row",s.countRows()):n.settings.autoWrapCol&&(e.row=1-s.countRows(),e.col=n.selRange.highlight.col+e.col==s.countCols()-1?1-s.countCols():1):n.settings.autoWrapCol&&n.selRange.highlight.row+e.row<0&&n.selRange.highlight.col+e.col>=0&&(e.row=s.countRows()-1,e.col=n.selRange.highlight.col+e.col==0?s.countCols()-1:-1),n.selRange.highlight.col+e.col>s.countCols()-1?c&&n.settings.minSpareCols>0?s.alter("insert_col",s.countCols()):n.settings.autoWrapRow&&(e.row=n.selRange.highlight.row+e.row==s.countRows()-1?1-s.countRows():1,e.col=1-s.countCols()):n.settings.autoWrapRow&&n.selRange.highlight.col+e.col<0&&n.selRange.highlight.row+e.row>=0&&(e.row=n.selRange.highlight.row+e.row==0?s.countRows()-1:-1,e.col=s.countCols()-1);var f=s.countRows(),g=s.countCols(),h=new l(n.selRange.highlight.row+e.row,n.selRange.highlight.col+e.col);h.row<0?h.row=0:h.row>0&&h.row>=f&&(h.row=f-1),h.col<0?h.col=0:h.col>0&&h.col>=g&&(h.col=g-1),q.setRangeStart(h,d)},transformEnd:function(a,b){var c=new l(a,b);s.runHooks("modifyTransformEnd",c);var d=s.countRows(),e=s.countCols(),f=new l(n.selRange.to.row+c.row,n.selRange.to.col+c.col);f.row<0?f.row=0:f.row>0&&f.row>=d&&(f.row=d-1),f.col<0?f.col=0:f.col>0&&f.col>=e&&(f.col=e-1),q.setRangeEnd(f)},isSelected:function(){return null!==n.selRange},inInSelection:function(a){return q.isSelected()?n.selRange.includes(a):!1},deselect:function(){q.isSelected()&&(s.selection.inProgress=!1,n.selRange=null,s.view.wt.selections.current.clear(),s.view.wt.selections.area.clear(),(n.settings.currentRowClassName||n.settings.currentColClassName)&&s.view.wt.selections.highlight.clear(),r.destroyEditor(),q.refreshBorders(),b.hooks.run(s,"afterDeselect"))},selectAll:function(){n.settings.multiSelect&&(q.setRangeStart(new l(0,0)),q.setRangeEnd(new l(s.countRows()-1,s.countCols()-1),!1))},empty:function(){if(q.isSelected()){var a,b,c=n.selRange.getTopLeftCorner(),d=n.selRange.getBottomRightCorner(),e=[];for(a=c.row;a<=d.row;a++)for(b=c.col;b<=d.col;b++)s.getCellMeta(a,b).readOnly||e.push([a,b,""]);s.setDataAtCell(e)}}},this.init=function(){b.hooks.run(s,"beforeInit"),b.mobileBrowser&&b.Dom.addClass(s.rootElement,"mobile"),this.updateSettings(n.settings,!0),this.view=new b.TableView(this),r=new b.EditorManager(s,n,q,o),this.forceFullRender=!0,this.view.render(),"object"==typeof n.firstRun&&(b.hooks.run(s,"afterChange",n.firstRun[0],n.firstRun[1]),n.firstRun=!1),b.hooks.run(s,"afterInit")},this.validateCell=function(a,c,d,e){var f=s.getCellValidator(c);"[object RegExp]"===Object.prototype.toString.call(f)&&(f=function(a){return function(b,c){c(a.test(b))}}(f)),"function"==typeof f?(a=b.hooks.execute(s,"beforeValidate",a,c.row,c.prop,e),s._registerTimeout(setTimeout(function(){return f.call(c,a,function(f){c.valid=f,f=b.hooks.execute(s,"afterValidate",f,a,c.row,c.prop,e),d(f)}),a},0))):(c.valid=!0,d(!0))},this.setDataAtCell=function(a,b,c,d){var h,i,j,k=g(a,b,c),l=[];for(h=0,i=k.length;i>h;h++){if("object"!=typeof k[h])throw new Error("Method `setDataAtCell` accepts row number or changes array of arrays as its first parameter");if("number"!=typeof k[h][1])throw new Error("Method `setDataAtCell` accepts row and column number as its parameters. If you want to use object property name, use method `setDataAtRowProp`");j=o.colToProp(k[h][1]),l.push([k[h][0],j,o.get(k[h][0],j),k[h][2]])}d||"object"!=typeof a||(d=b),e(l,d,function(){f(l,d)})},this.setDataAtRowProp=function(a,b,c,d){var h,i,j=g(a,b,c),k=[];for(h=0,i=j.length;i>h;h++)k.push([j[h][0],j[h][1],o.get(j[h][0],j[h][1]),j[h][2]]);d||"object"!=typeof a||(d=b),e(k,d,function(){f(k,d)})},this.listen=function(){b.activeGuid=s.guid,document.activeElement&&document.activeElement!==document.body?document.activeElement.blur():document.activeElement||document.body.focus()},this.unlisten=function(){b.activeGuid=null},this.isListening=function(){return b.activeGuid===s.guid},this.destroyEditor=function(a){q.refreshBorders(a)},this.populateFromArray=function(a,b,c,d,e,f,g,h,i){if("object"!=typeof c||"object"!=typeof c[0])throw new Error("populateFromArray parameter `input` must be an array of arrays");return p.populateFromArray(new l(a,b),c,"number"==typeof d?new l(d,e):null,f,g,h,i)},this.spliceCol=function(){return o.spliceCol.apply(o,arguments)},this.spliceRow=function(){return o.spliceRow.apply(o,arguments)},this.getSelected=function(){return q.isSelected()?[n.selRange.from.row,n.selRange.from.col,n.selRange.to.row,n.selRange.to.col]:void 0},this.getSelectedRange=function(){return q.isSelected()?n.selRange:void 0},this.render=function(){s.view&&(s.forceFullRender=!0,q.refreshBorders(null,!0))},this.loadData=function(a){function c(){n.cellSettings.length=0}if("object"==typeof a&&null!==a)a.push&&a.splice||(a=[a]);else{if(null!==a)throw new Error("loadData only accepts array of objects or array of arrays ("+typeof a+" given)");a=[];for(var d,e=0,f=n.settings.startRows;f>e;e++){d=[];for(var g=0,h=n.settings.startCols;h>g;g++)d.push(null);a.push(d)}}n.isPopulated=!1,t.prototype.data=a,s.dataType=n.settings.dataSchema instanceof Array||a[0]instanceof Array?"array":"function"==typeof n.settings.dataSchema?"function":"object",o=new b.DataMap(s,n,t),c(),p.adjustRowsAndCols(),b.hooks.run(s,"afterLoadData"),n.firstRun?n.firstRun=[null,"loadData"]:(b.hooks.run(s,"afterChange",null,"loadData"),s.render()),n.isPopulated=!0},this.getData=function(a,b,c,d){return"undefined"==typeof a?o.getAll():o.getRange(new l(a,b),new l(c,d),o.DESTINATION_RENDERER)},this.getCopyableData=function(a,b,c,d){return o.getCopyableText(new l(a,b),new l(c,d))},this.updateSettings=function(a,c){var d,e;if("undefined"!=typeof a.rows)throw new Error("'rows' setting is no longer supported. do you mean startRows, minRows or maxRows?");if("undefined"!=typeof a.cols)throw new Error("'cols' setting is no longer supported. do you mean startCols, minCols or maxCols?");for(d in a)"data"!==d&&(void 0!==b.hooks.hooks[d]||void 0!==b.hooks.legacy[d]?("function"==typeof a[d]||b.helper.isArray(a[d]))&&s.addHook(d,a[d]):!c&&a.hasOwnProperty(d)&&(t.prototype[d]=a[d]));if(void 0===a.data&&void 0===n.settings.data?s.loadData(null):void 0!==a.data?s.loadData(a.data):void 0!==a.columns&&o.createMap(),e=s.countCols(),n.cellSettings.length=0,e>0){var f,g;for(d=0;e>d;d++)n.columnSettings[d]=b.helper.columnFactory(t,n.columnsSettingConflicts),f=n.columnSettings[d].prototype,t.prototype.columns&&(g=t.prototype.columns[d],b.helper.extend(f,g),b.helper.extend(f,h(g)))}if("undefined"!=typeof a.cell)for(d in a.cell){var i=a.cell[d];s.setCellMetaObject(i.row,i.col,i)}if(b.hooks.run(s,"afterCellMetaReset"),"undefined"!=typeof a.className&&(t.prototype.className&&b.Dom.removeClass(s.rootElement,t.prototype.className),a.className&&b.Dom.addClass(s.rootElement,a.className)),"undefined"!=typeof a.height){var j=a.height;"function"==typeof j&&(j=j()),s.rootElement.style.height=j+"px"}if("undefined"!=typeof a.width){var k=a.width;"function"==typeof k&&(k=k()),s.rootElement.style.width=k+"px"}j&&(s.rootElement.style.overflow="auto"),c||b.hooks.run(s,"afterUpdateSettings"),p.adjustRowsAndCols(),s.view&&!n.firstRun&&(s.forceFullRender=!0,q.refreshBorders(null,!0))},this.getValue=function(){var a=s.getSelected();if(t.prototype.getValue){if("function"==typeof t.prototype.getValue)return t.prototype.getValue.call(s);if(a)return s.getData()[a[0]][t.prototype.getValue]}else if(a)return s.getDataAtCell(a[0],a[1])},this.getSettings=function(){return n.settings},this.clear=function(){q.selectAll(),q.empty()},this.alter=function(a,b,c,d,e){p.alter(a,b,c,d,e)},this.getCell=function(a,b,c){return s.view.getCellAtCoords(new l(a,b),c)},this.getCoords=function(a){return this.view.wt.wtTable.getCoords.call(this.view.wt.wtTable,a)},this.colToProp=function(a){return o.colToProp(a)},this.propToCol=function(a){return o.propToCol(a)},this.getDataAtCell=function(a,b){return o.get(a,o.colToProp(b))},this.getDataAtRowProp=function(a,b){return o.get(a,b)},this.getDataAtCol=function(a){var b=[];return b.concat.apply(b,o.getRange(new l(0,a),new l(n.settings.data.length-1,a),o.DESTINATION_RENDERER))},this.getDataAtProp=function(a){var b=[];return b.concat.apply(b,o.getRange(new l(0,o.propToCol(a)),new l(n.settings.data.length-1,o.propToCol(a)),o.DESTINATION_RENDERER))},this.getSourceDataAtCol=function(a){for(var b=[],c=n.settings.data,d=0;d<c.length;d++)b.push(c[d][a]);return b},this.getSourceDataAtRow=function(a){return n.settings.data[a]},this.getDataAtRow=function(a){var b=o.getRange(new l(a,0),new l(a,this.countCols()-1),o.DESTINATION_RENDERER);return b[0]},this.removeCellMeta=function(a,b,c){var d=s.getCellMeta(a,b);void 0!=d[c]&&delete n.cellSettings[a][b][c]},this.setCellMetaObject=function(a,b,c){if("object"==typeof c)for(var d in c){var e=c[d];this.setCellMeta(a,b,d,e)}},this.setCellMeta=function(a,c,d,e){n.cellSettings[a]||(n.cellSettings[a]=[]),n.cellSettings[a][c]||(n.cellSettings[a][c]=new n.columnSettings[c]),n.cellSettings[a][c][d]=e,b.hooks.run(s,"afterSetCellMeta",a,c,d,e)},this.getCellMeta=function(a,c){var d,e=o.colToProp(c);if(a=i(a),c=j(c),n.columnSettings[c]||(n.columnSettings[c]=b.helper.columnFactory(t,n.columnsSettingConflicts)),n.cellSettings[a]||(n.cellSettings[a]=[]),n.cellSettings[a][c]||(n.cellSettings[a][c]=new n.columnSettings[c]),d=n.cellSettings[a][c],d.row=a,d.col=c,d.prop=e,d.instance=s,b.hooks.run(s,"beforeGetCellMeta",a,c,d),b.helper.extend(d,h(d)),d.cells){var f=d.cells.call(d,a,c,e);f&&(b.helper.extend(d,f),b.helper.extend(d,h(f)))}return b.hooks.run(s,"afterGetCellMeta",a,c,d),d};var v=b.helper.cellMethodLookupFactory("renderer");this.getCellRenderer=function(a,c){var d=v.call(this,a,c);return b.renderers.getRenderer(d)},this.getCellEditor=b.helper.cellMethodLookupFactory("editor"),this.getCellValidator=b.helper.cellMethodLookupFactory("validator"),this.validateCells=function(a){var b=new d;b.onQueueEmpty=a;for(var c=s.countRows()-1;c>=0;){for(var e=s.countCols()-1;e>=0;)b.addValidatorToQueue(),s.validateCell(s.getDataAtCell(c,e),s.getCellMeta(c,e),function(){b.removeValidatorFormQueue()},"validateCells"),e--;c--}b.checkIfQueueIsEmpty()},this.getRowHeader=function(a){if(void 0===a){for(var b=[],c=0,d=s.countRows();d>c;c++)b.push(s.getRowHeader(c));return b}return"[object Array]"===Object.prototype.toString.call(n.settings.rowHeaders)&&void 0!==n.settings.rowHeaders[a]?n.settings.rowHeaders[a]:"function"==typeof n.settings.rowHeaders?n.settings.rowHeaders(a):n.settings.rowHeaders&&"string"!=typeof n.settings.rowHeaders&&"number"!=typeof n.settings.rowHeaders?a+1:n.settings.rowHeaders},this.hasRowHeaders=function(){return!!n.settings.rowHeaders},this.hasColHeaders=function(){if(void 0!==n.settings.colHeaders&&null!==n.settings.colHeaders)return!!n.settings.colHeaders;for(var a=0,b=s.countCols();b>a;a++)if(s.getColHeader(a))return!0;return!1},this.getColHeader=function(a){if(void 0===a){for(var c=[],d=0,e=s.countCols();e>d;d++)c.push(s.getColHeader(d));return c}var f=a;return a=b.hooks.execute(s,"modifyCol",a),n.settings.columns&&n.settings.columns[a]&&n.settings.columns[a].title?n.settings.columns[a].title:"[object Array]"===Object.prototype.toString.call(n.settings.colHeaders)&&void 0!==n.settings.colHeaders[a]?n.settings.colHeaders[a]:"function"==typeof n.settings.colHeaders?n.settings.colHeaders(a):n.settings.colHeaders&&"string"!=typeof n.settings.colHeaders&&"number"!=typeof n.settings.colHeaders?b.helper.spreadsheetColumnLabel(f):n.settings.colHeaders},this._getColWidthFromSettings=function(a){var b=s.getCellMeta(0,a),c=b.width;if((void 0===c||c===n.settings.width)&&(c=b.colWidths),void 0!==c&&null!==c){switch(typeof c){case"object":c=c[a];break;case"function":c=c(a)}"string"==typeof c&&(c=parseInt(c,10))}return c},this.getColWidth=function(a){var c=s._getColWidthFromSettings(a);return c||(c=50),c=b.hooks.execute(s,"modifyColWidth",c,a)},this._getRowHeightFromSettings=function(a){var b=n.settings.rowHeights;if(void 0!==b&&null!==b){switch(typeof b){case"object":b=b[a];break;case"function":b=b(a)}"string"==typeof b&&(b=parseInt(b,10))}return b},this.getRowHeight=function(a){var c=s._getRowHeightFromSettings(a);return c=b.hooks.execute(s,"modifyRowHeight",c,a)},this.countRows=function(){return n.settings.data.length},this.countCols=function(){return"object"===s.dataType||"function"===s.dataType?n.settings.columns&&n.settings.columns.length?n.settings.columns.length:o.colToPropCache.length:"array"===s.dataType?n.settings.columns&&n.settings.columns.length?n.settings.columns.length:n.settings.data&&n.settings.data[0]&&n.settings.data[0].length?n.settings.data[0].length:0:void 0},this.rowOffset=function(){return s.view.wt.wtTable.getFirstRenderedRow()},this.colOffset=function(){return s.view.wt.wtTable.getFirstRenderedColumn()},this.countRenderedRows=function(){return s.view.wt.drawn?s.view.wt.wtTable.getRenderedRowsCount():-1},this.countVisibleRows=function(){return s.view.wt.drawn?s.view.wt.wtTable.getVisibleRowsCount():-1},this.countVisibleCols=function(){return s.view.wt.drawn?s.view.wt.wtTable.columnStrategy.countVisible():-1},this.countEmptyRows=function(a){for(var c,d=s.countRows()-1,e=0;d>=0;){if(c=b.hooks.execute(this,"modifyRow",d),s.isEmptyRow(c))e++;else if(a)break;d--}return e},this.countEmptyCols=function(a){if(s.countRows()<1)return 0;for(var b=s.countCols()-1,c=0;b>=0;){if(s.isEmptyCol(b))c++;else if(a)break;b--}return c},this.isEmptyRow=function(a){return n.settings.isEmptyRow.call(s,a)},this.isEmptyCol=function(a){return n.settings.isEmptyCol.call(s,a)},this.selectCell=function(a,b,c,d,e){if("number"!=typeof a||0>a||a>=s.countRows())return!1;if("number"!=typeof b||0>b||b>=s.countCols())return!1;if("undefined"!=typeof c){if("number"!=typeof c||0>c||c>=s.countRows())return!1;if("number"!=typeof d||0>d||d>=s.countCols())return!1}var f=new l(a,b);return n.selRange=new m(f,f,f),document.activeElement&&document.activeElement!==document.documentElement&&document.activeElement!==document.body&&document.activeElement.blur(),s.listen(),"undefined"==typeof c?q.setRangeEnd(n.selRange.from,e):q.setRangeEnd(new l(c,d),e),s.selection.finish(),!0},this.selectCellByProp=function(){return arguments[1]=o.propToCol(arguments[1]),"undefined"!=typeof arguments[3]&&(arguments[3]=o.propToCol(arguments[3])),s.selectCell.apply(s,arguments)},this.deselectCell=function(){q.deselect()},this.destroy=function(){s._clearTimeouts(),s.view&&s.view.destroy(),b.Dom.empty(s.rootElement),u.clear(),b.hooks.run(s,"afterDestroy"),b.hooks.destroy(s);for(var a in s)s.hasOwnProperty(a)&&("function"==typeof s[a]?"runHooks"!==a&&"runHooksAndReturn"!==a&&(s[a]=k):"guid"!==a&&(s[a]=null));n=null,o=null,p=null,q=null,r=null,s=null,t=null},this.getActiveEditor=function(){return r.getActiveEditor()},this.getInstance=function(){return s},this.addHook=function(a,c){b.hooks.add(a,c,s)},this.addHookOnce=function(a,c){b.hooks.once(a,c,s)},this.removeHook=function(a,c){b.hooks.remove(a,c,s)},this.runHooks=function(a,c,d,e,f,g,h){b.hooks.run(s,a,c,d,e,f,g,h)},this.runHooksAndReturn=function(a,c,d,e,f,g,h){return b.hooks.execute(s,a,c,d,e,f,g,h)},this.timeouts=[],this._registerTimeout=function(a){this.timeouts.push(a)},this._clearTimeouts=function(){for(var a=0,b=this.timeouts.length;b>a;a++)clearTimeout(this.timeouts[a])},this.version="0.12.2"};var F=function(){};if(F.prototype={data:void 0,dataSchema:void 0,width:void 0,height:void 0,startRows:5,startCols:5,rowHeaders:null,colHeaders:null,colWidths:void 0,columns:void 0,cells:void 0,cell:[],minRows:0,minCols:0,maxRows:1/0,maxCols:1/0,minSpareRows:0,minSpareCols:0,allowInsertRow:!0,allowInsertColumn:!0,allowRemoveRow:!0,allowRemoveColumn:!0,multiSelect:!0,fillHandle:!0,fixedRowsTop:0,fixedColumnsLeft:0,outsideClickDeselects:!0,enterBeginsEditing:!0,enterMoves:{row:1,col:0},tabMoves:{row:0,col:1},autoWrapRow:!1,autoWrapCol:!1,copyRowsLimit:1e3,copyColsLimit:1e3,pasteMode:"overwrite",currentRowClassName:void 0,currentColClassName:void 0,stretchH:"none",isEmptyRow:function(a){for(var b,c=0,d=this.countCols();d>c;c++)if(b=this.getDataAtCell(a,c),""!==b&&null!==b&&"undefined"!=typeof b)return!1;return!0},isEmptyCol:function(a){for(var b,c=0,d=this.countRows();d>c;c++)if(b=this.getDataAtCell(c,a),""!==b&&null!==b&&"undefined"!=typeof b)return!1;return!0},observeDOMVisibility:!0,allowInvalid:!0,invalidCellClassName:"htInvalid",placeholder:!1,placeholderCellClassName:"htPlaceholder",readOnlyCellClassName:"htDimmed",commentedCellClassName:"htCommentCell",fragmentSelection:!1,readOnly:!1,type:"text",copyable:!0,debug:!1,wordWrap:!0,noWordWrapClassName:"htNoWrap",contextMenu:void 0,undo:void 0,columnSorting:void 0,manualColumnMove:void 0,manualColumnResize:void 0,manualRowMove:void 0,manualRowResize:void 0,viewportRowRenderingOffset:10,groups:void 0},b.DefaultSettings=F,function(a){function b(){function a(a){return null!==a&&!c(a)&&("string"==typeof a||"number"==typeof a)}function b(a){return null!==a&&("object"==typeof a||"function"==typeof a)}function c(a){return a!==a}var d={arrayMap:[],weakMap:new WeakMap};return{get:function(c){return a(c)?d.arrayMap[c]:b(c)?d.weakMap.get(c):void 0},set:function(c,e){if(a(c))d.arrayMap[c]=e;else{if(!b(c))throw new Error("Invalid key type");d.weakMap.set(c,e)}},"delete":function(c){a(c)?delete d.arrayMap[c]:b(c)&&d.weakMap["delete"](c)}}}a.MultiMap||(a.MultiMap=b)}(a),!a.Handsontable)var b={};if(b.Dom={},b.Dom.enableImmediatePropagation=function(a){null!=a&&null==a.isImmediatePropagationEnabled&&(a.stopImmediatePropagation=function(){this.isImmediatePropagationEnabled=!1,this.cancelBubble=!0},a.isImmediatePropagationEnabled=!0,a.isImmediatePropagationStopped=function(){return!this.isImmediatePropagationEnabled})},b.Dom.closest=function(a,b,c){for(;null!=a&&a!==c;){if(1===a.nodeType&&b.indexOf(a.nodeName)>-1)return a;a=a.parentNode}return null},b.Dom.isChildOf=function(a,b){var c=a.parentNode,d=[];for("string"==typeof b?d=Array.prototype.slice.call(document.querySelectorAll(b),0):d.push(b);null!=c;){if(d.indexOf(c)>-1)return!0;c=c.parentNode}return!1},b.Dom.index=function(a){var b=0;if(a.previousSibling)for(;a=a.previousSibling;)++b;return b},document.documentElement.classList?(b.Dom.hasClass=function(a,b){return a.classList.contains(b)},b.Dom.addClass=function(a,b){b&&a.classList.add(b)},b.Dom.removeClass=function(a,b){a.classList.remove(b)}):(b.Dom.hasClass=function(a,b){return a.className.match(new RegExp("(\\s|^)"+b+"(\\s|$)"))},b.Dom.addClass=function(a,b){""==a.className?a.className=b:this.hasClass(a,b)||(a.className+=" "+b)},b.Dom.removeClass=function(a,b){if(this.hasClass(a,b)){var c=new RegExp("(\\s|^)"+b+"(\\s|$)");a.className=a.className.replace(c," ").trim()}}),b.Dom.removeTextNodes=function(a,b){if(3===a.nodeType)b.removeChild(a);else if(["TABLE","THEAD","TBODY","TFOOT","TR"].indexOf(a.nodeName)>-1)for(var c=a.childNodes,d=c.length-1;d>=0;d--)this.removeTextNodes(c[d],a)},b.Dom.empty=function(a){for(var b;b=a.lastChild;)a.removeChild(b)},b.Dom.HTML_CHARACTERS=/(<(.*)>|&(.*);)/,b.Dom.fastInnerHTML=function(a,b){this.HTML_CHARACTERS.test(b)?a.innerHTML=b:this.fastInnerText(a,b)},b.Dom.fastInnerText=document.createTextNode("test").textContent?function(a,b){var c=a.firstChild;c&&3===c.nodeType&&null===c.nextSibling?c.textContent=b:(this.empty(a),a.appendChild(document.createTextNode(b)))}:function(a,b){var c=a.firstChild;c&&3===c.nodeType&&null===c.nextSibling?c.data=b:(this.empty(a),a.appendChild(document.createTextNode(b)))},b.Dom.isVisible=function(a){for(var c=a;c!==document.documentElement;){if(null===c)return!1;if(11===c.nodeType){if(c.host){if(c.host.impl)return b.Dom.isVisible(c.host.impl);if(c.host)return b.Dom.isVisible(c.host);throw new Error("Lost in Web Components world")}return!1}if("none"===c.style.display)return!1;c=c.parentNode}return!0},b.Dom.offset=function(b){if(this.hasCaptionProblem()&&b.firstChild&&"CAPTION"===b.firstChild.nodeName){var c=b.getBoundingClientRect();return{top:c.top+(a.pageYOffset||document.documentElement.scrollTop)-(document.documentElement.clientTop||0),left:c.left+(a.pageXOffset||document.documentElement.scrollLeft)-(document.documentElement.clientLeft||0)}}for(var d=b.offsetLeft,e=b.offsetTop,f=b;(b=b.offsetParent)&&b!==document.body;)d+=b.offsetLeft,e+=b.offsetTop,f=b;return f&&"fixed"===f.style.position&&(d+=a.pageXOffset||document.documentElement.scrollLeft,e+=a.pageYOffset||document.documentElement.scrollTop),{left:d,top:e}},b.Dom.getWindowScrollTop=function(){var b=a.scrollY;return void 0==b&&(b=document.documentElement.scrollTop),b},b.Dom.getWindowScrollLeft=function(){var b=a.scrollX;return void 0==b&&(b=document.documentElement.scrollLeft),b},b.Dom.getScrollTop=function(c){return c===a?b.Dom.getWindowScrollTop(c):c.scrollTop},b.Dom.getScrollLeft=function(c){return c===a?b.Dom.getWindowScrollLeft(c):c.scrollLeft},b.Dom.getComputedStyle=function(a){return a.currentStyle||document.defaultView.getComputedStyle(a)},b.Dom.outerWidth=function(a){return a.offsetWidth},b.Dom.outerHeight=function(a){return this.hasCaptionProblem()&&a.firstChild&&"CAPTION"===a.firstChild.nodeName?a.offsetHeight+a.firstChild.offsetHeight:a.offsetHeight},b.Dom.innerHeight=function(a){return a.clientHeight||a.innerHeight},b.Dom.innerWidth=function(a){return a.clientWidth||a.innerWidth},b.Dom.addEvent=function(b,c,d){a.addEventListener?b.addEventListener(c,d,!1):b.attachEvent("on"+c,d)},b.Dom.removeEvent=function(b,c,d){a.removeEventListener?b.removeEventListener(c,d,!1):b.detachEvent("on"+c,d)},function(){function a(){var a=document.createElement("TABLE");a.style.borderSpacing=0,a.style.borderWidth=0,a.style.padding=0;var b=document.createElement("TBODY");a.appendChild(b),b.appendChild(document.createElement("TR")),b.firstChild.appendChild(document.createElement("TD")),b.firstChild.firstChild.innerHTML="<tr><td>t<br>t</td></tr>";var c=document.createElement("CAPTION");c.innerHTML="c<br>c<br>c<br>c",c.style.padding=0,c.style.margin=0,a.insertBefore(c,b),document.body.appendChild(a),d=a.offsetHeight<2*a.lastChild.offsetHeight,document.body.removeChild(a)}function c(){var a=document.createElement("p");a.style.width="100%",a.style.height="200px";var b=document.createElement("div");b.style.position="absolute",b.style.top="0px",b.style.left="0px",b.style.visibility="hidden",b.style.width="200px",b.style.height="150px",b.style.overflow="hidden",b.appendChild(a),(document.body||document.documentElement).appendChild(b);var c=a.offsetWidth;b.style.overflow="scroll";var d=a.offsetWidth;return c==d&&(d=b.clientWidth),(document.body||document.documentElement).removeChild(b),c-d}var d;b.Dom.hasCaptionProblem=function(){return void 0===d&&a(),d},b.Dom.getCaretPosition=function(a){if(a.selectionStart)return a.selectionStart;if(document.selection){a.focus();var b=document.selection.createRange();if(null==b)return 0;var c=a.createTextRange(),d=c.duplicate();return c.moveToBookmark(b.getBookmark()),d.setEndPoint("EndToStart",c),d.text.length}return 0},b.Dom.getSelectionEndPosition=function(a){if(a.selectionEnd)return a.selectionEnd;if(document.selection){var b=document.selection.createRange();if(null==b)return 0;var c=a.createTextRange();return c.text.indexOf(b.text)+b.text.length}},b.Dom.setCaretPosition=function(a,b,c){if(void 0===c&&(c=b),a.setSelectionRange)a.focus(),a.setSelectionRange(b,c);else if(a.createTextRange){var d=a.createTextRange();d.collapse(!0),d.moveEnd("character",c),d.moveStart("character",b),d.select()}};var e;b.Dom.getScrollbarWidth=function(){return void 0===e&&(e=c()),e};var f=!document.createTextNode("test").textContent;b.Dom.isIE8=function(){return f};var g=!!document.documentMode;b.Dom.isIE9=function(){return g};var h=/Safari/.test(navigator.userAgent)&&/Apple Computer/.test(navigator.vendor);b.Dom.isSafari=function(){return h},b.Dom.setOverlayPosition=function(a,b,c){f||g?(a.style.top=c,a.style.left=b):h?a.style["-webkit-transform"]="translate3d("+b+","+c+",0)":a.style.transform="translate3d("+b+","+c+",0)"},b.Dom.getCssTransform=function(a){var b;return a.style.transform&&""!=(b=a.style.transform)?["transform",b]:a.style["-webkit-transform"]&&""!=(b=a.style["-webkit-transform"])?["-webkit-transform",b]:-1},b.Dom.resetCssTransform=function(a){a.transform&&""!=a.transform?a.transform="":a["-webkit-transform"]&&""!=a["-webkit-transform"]&&(a["-webkit-transform"]="")}}(),!a.Handsontable)var b={};b.countEventManagerListeners=0,b.eventManager=function(c){if(!c)throw new Error("instance not defined");c.eventListeners||(c.eventListeners=[]);var d=function(d,e,f){var g=function(a){void 0==a.target&&void 0!=a.srcElement&&(a.definePoperty?a.definePoperty("target",{value:a.srcElement}):a.target=a.srcElement),void 0==a.preventDefault&&(a.definePoperty?a.definePoperty("preventDefault",{value:function(){this.returnValue=!1}}):a.preventDefault=function(){this.returnValue=!1}),f.call(this,a)};c.eventListeners.push({element:d,event:e,callback:f,callbackProxy:g}),a.addEventListener?d.addEventListener(e,g,!1):d.attachEvent("on"+e,g),b.countEventManagerListeners++},e=function(a,d,e){for(var f=c.eventListeners.length;f--;){var g=c.eventListeners[f];if(g.event==d&&g.element==a){if(e&&e!=g.callback)continue;c.eventListeners.splice(f,1),g.element.removeEventListener?g.element.removeEventListener(g.event,g.callbackProxy,!1):g.element.detachEvent("on"+g.event,g.callbackProxy),b.countEventManagerListeners--}}},f=function(){for(var a=c.eventListeners.length;a--;){var b=c.eventListeners[a];e(b.element,b.event,b.callback)}},g=function(b,c){var d,e={bubbles:!0,cancelable:"mousemove"!==c,view:a,detail:0,screenX:0,screenY:0,clientX:1,clientY:1,ctrlKey:!1,altKey:!1,shiftKey:!1,metaKey:!1,button:0,relatedTarget:void 0};document.createEvent?(d=document.createEvent("MouseEvents"),d.initMouseEvent(c,e.bubbles,e.cancelable,e.view,e.detail,e.screenX,e.screenY,e.clientX,e.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,e.button,e.relatedTarget||document.body.parentNode)):d=document.createEventObject(),b.dispatchEvent?b.dispatchEvent(d):b.fireEvent("on"+c,d)};return{addEventListener:d,removeEventListener:e,clear:f,fireEvent:g}},b.TableView=function(c){var d=this;this.eventManager=b.eventManager(c),this.instance=c,this.settings=c.getSettings();var e=c.rootElement.getAttribute("style");e&&c.rootElement.setAttribute("data-originalstyle",e),b.Dom.addClass(c.rootElement,"handsontable");var f=document.createElement("TABLE");f.className="htCore",this.THEAD=document.createElement("THEAD"),f.appendChild(this.THEAD),this.TBODY=document.createElement("TBODY"),f.appendChild(this.TBODY),c.table=f,c.container.insertBefore(f,c.container.firstChild),this.eventManager.addEventListener(c.rootElement,"mousedown",function(b){d.isTextSelectionAllowed(b.target)||(h(),b.preventDefault(),a.focus())}),this.eventManager.addEventListener(document.documentElement,"keyup",function(a){c.selection.isInProgress()&&!a.shiftKey&&c.selection.finish()});var g;this.isMouseDown=function(){return g},this.eventManager.addEventListener(document.documentElement,"mouseup",function(a){c.selection.isInProgress()&&1===a.which&&c.selection.finish(),g=!1,b.helper.isOutsideInput(document.activeElement)&&c.unlisten()}),this.eventManager.addEventListener(document.documentElement,"mousedown",function(a){var b=a.target;if(!g){if(b!==d.wt.wtTable.spreader)for(;b!==document.documentElement;){if(null===b)return;if(b===c.rootElement)return;b=b.parentNode}d.settings.outsideClickDeselects?c.deselectCell():c.destroyEditor()}}),this.eventManager.addEventListener(f,"selectstart",function(a){d.settings.fragmentSelection||a.preventDefault()});var h=function(){a.getSelection?a.getSelection().empty?a.getSelection().empty():a.getSelection().removeAllRanges&&a.getSelection().removeAllRanges():document.selection&&document.selection.empty()},i=[new z({className:"current",border:{width:2,color:"#5292F7",cornerVisible:function(){return d.settings.fillHandle&&!d.isCellEdited()&&!c.selection.isMultiple()},multipleSelectionHandlesVisible:function(){return!d.isCellEdited()&&!c.selection.isMultiple()}}}),new z({className:"area",border:{width:1,color:"#89AFF9",cornerVisible:function(){return d.settings.fillHandle&&!d.isCellEdited()&&c.selection.isMultiple()},multipleSelectionHandlesVisible:function(){return!d.isCellEdited()&&c.selection.isMultiple()}}}),new z({className:"highlight",highlightRowClassName:d.settings.currentRowClassName,highlightColumnClassName:d.settings.currentColClassName}),new z({className:"fill",border:{width:1,color:"red"}})];i.current=i[0],i.area=i[1],i.highlight=i[2],i.fill=i[3];var j={debug:function(){return d.settings.debug},table:f,stretchH:this.settings.stretchH,data:c.getDataAtCell,totalRows:c.countRows,totalColumns:c.countCols,fixedColumnsLeft:function(){return d.settings.fixedColumnsLeft},fixedRowsTop:function(){return d.settings.fixedRowsTop},renderAllRows:d.settings.renderAllRows,rowHeaders:function(){var a=[];return c.hasRowHeaders()&&a.push(function(a,b){d.appendRowHeader(a,b)}),b.hooks.run(c,"afterGetRowHeaderRenderers",a),a},columnHeaders:function(){var a=[];return c.hasColHeaders()&&a.push(function(a,b){d.appendColHeader(a,b)}),b.hooks.run(c,"afterGetColumnHeaderRenderers",a),a},columnWidth:c.getColWidth,rowHeight:c.getRowHeight,cellRenderer:function(a,c,e){var f=d.instance.colToProp(c),g=d.instance.getCellMeta(a,c),h=d.instance.getCellRenderer(g),i=d.instance.getDataAtRowProp(a,f);h(d.instance,e,a,c,f,i,g),b.hooks.run(d.instance,"afterRenderer",e,a,c,f,i,g)},selections:i,hideBorderOnMouseDownOver:function(){return d.settings.fragmentSelection},onCellMouseDown:function(a,e,f,h){c.listen(),d.activeWt=h,g=!0,b.hooks.run(c,"beforeOnCellMouseDown",a,e,f),b.Dom.enableImmediatePropagation(a),a.isImmediatePropagationStopped()||(2===a.button&&c.selection.inInSelection(e)||(a.shiftKey?e.row>=0&&e.col>=0&&c.selection.setRangeEnd(e):e.row<0||e.col<0?(e.row<0&&(c.selectCell(0,e.col,c.countRows()-1,e.col),c.selection.setSelectedHeaders(!1,!0)),e.col<0&&(c.selectCell(e.row,0,e.row,c.countCols()-1),c.selection.setSelectedHeaders(!0,!1))):c.selection.setRangeStart(e)),b.hooks.run(c,"afterOnCellMouseDown",a,e,f),d.activeWt=d.wt)},onCellMouseOver:function(a,e,f,h){d.activeWt=h,e.row>=0&&e.col>=0?g&&c.selection.setRangeEnd(e):g&&(e.row<0&&(c.selection.setRangeEnd(new l(c.countRows()-1,e.col)),c.selection.setSelectedHeaders(!1,!0)),e.col<0&&(c.selection.setRangeEnd(new l(e.row,c.countCols()-1)),c.selection.setSelectedHeaders(!0,!1))),b.hooks.run(c,"afterOnCellMouseOver",a,e,f),d.activeWt=d.wt},onCellCornerMouseDown:function(a){a.preventDefault(),b.hooks.run(c,"afterOnCellCornerMouseDown",a)},beforeDraw:function(a){d.beforeRender(a)},onDraw:function(a){d.onDraw(a)},onScrollVertically:function(){c.runHooks("afterScrollVertically")},onScrollHorizontally:function(){c.runHooks("afterScrollHorizontally")},onBeforeDrawBorders:function(a,b){c.runHooks("beforeDrawBorders",a,b)},onBeforeTouchScroll:function(){c.runHooks("beforeTouchScroll")},onAfterMomentumScroll:function(){c.runHooks("afterMomentumScroll")},viewportRowCalculatorOverride:function(a){d.settings.viewportRowRenderingOffset&&(a.renderStartRow=Math.max(a.renderStartRow-d.settings.viewportRowRenderingOffset,0),a.renderEndRow=Math.min(a.renderEndRow+d.settings.viewportRowRenderingOffset,c.countRows()-1)),c.runHooks("afterViewportRowCalculatorOverride",a)}};b.hooks.run(c,"beforeInitWalkontable",j),this.wt=new p(j),this.activeWt=this.wt,this.eventManager.addEventListener(d.wt.wtTable.spreader,"mousedown",function(a){a.target===d.wt.wtTable.spreader&&3===a.which&&b.helper.stopPropagation(a)}),this.eventManager.addEventListener(d.wt.wtTable.spreader,"contextmenu",function(a){a.target===d.wt.wtTable.spreader&&3===a.which&&b.helper.stopPropagation(a)
}),this.eventManager.addEventListener(document.documentElement,"click",function(){d.settings.observeDOMVisibility&&d.wt.drawInterrupted&&(d.instance.forceFullRender=!0,d.render())})},b.TableView.prototype.isTextSelectionAllowed=function(a){return b.helper.isInput(a)?!0:this.settings.fragmentSelection&&b.Dom.isChildOf(a,this.TBODY)?!0:!1},b.TableView.prototype.isCellEdited=function(){var a=this.instance.getActiveEditor();return a&&a.isOpened()},b.TableView.prototype.beforeRender=function(a){a&&b.hooks.run(this.instance,"beforeRender",this.instance.forceFullRender)},b.TableView.prototype.onDraw=function(a){a&&b.hooks.run(this.instance,"afterRender",this.instance.forceFullRender)},b.TableView.prototype.render=function(){this.wt.draw(!this.instance.forceFullRender),this.instance.forceFullRender=!1},b.TableView.prototype.getCellAtCoords=function(a,b){var c=this.wt.getCell(a,b);return 0>c?null:c},b.TableView.prototype.scrollViewport=function(a){this.wt.scrollViewport(a)},b.TableView.prototype.appendRowHeader=function(a,c){var d=document.createElement("DIV"),e=document.createElement("SPAN");d.className="relative",e.className="rowHeader",a>-1?b.Dom.fastInnerHTML(e,this.instance.getRowHeader(a)):b.Dom.fastInnerText(e," "),d.appendChild(e),b.Dom.empty(c),c.appendChild(d),b.hooks.run(this.instance,"afterGetRowHeader",a,c)},b.TableView.prototype.appendColHeader=function(a,c){var d=document.createElement("DIV"),e=document.createElement("SPAN");d.className="relative",e.className="colHeader",a>-1?b.Dom.fastInnerHTML(e,this.instance.getColHeader(a)):b.Dom.fastInnerText(e," "),d.appendChild(e),b.Dom.empty(c),c.appendChild(d),b.hooks.run(this.instance,"afterGetColHeader",a,c)},b.TableView.prototype.maximumVisibleElementWidth=function(a){var b=this.wt.wtViewport.getWorkspaceWidth(),c=b-a;return c>0?c:0},b.TableView.prototype.maximumVisibleElementHeight=function(a){var b=this.wt.wtViewport.getWorkspaceHeight(),c=b-a;return c>0?c:0},b.TableView.prototype.mainViewIsActive=function(){return this.wt===this.activeWt},b.TableView.prototype.destroy=function(){this.wt.destroy(),this.eventManager.clear()},function(a){function b(a){var b,c;c={},b=a,this.getInstance=function(a){return a.guid in c||(c[a.guid]=new b(a)),c[a.guid]}}var c={},d=new WeakMap;a.editors={registerEditor:function(a,e){var f=new b(e);"string"==typeof a&&(c[a]=f),d.set(e,f)},getEditor:function(a,b){var e;if("function"==typeof a)d.get(a)||this.registerEditor(null,a),e=d.get(a);else{if("string"!=typeof a)throw Error('Only strings and functions can be passed as "editor" parameter ');e=c[a]}if(!e)throw Error('No editor registered under name "'+a+'"');return e.getInstance(b)}}}(b),function(a){a.EditorManager=function(b,c,d){var e,f=this,g=a.helper.keyCode,h=!1,i=a.eventManager(b),j=function(){function j(i){if(b.isListening()&&(a.hooks.run(b,"beforeKeyDown",i),!h&&(a.Dom.enableImmediatePropagation(i),!i.isImmediatePropagationStopped()&&(c.lastKeyCode=i.keyCode,d.isSelected())))){var j=(i.ctrlKey||i.metaKey)&&!i.altKey;if(!(e.isWaiting()||a.helper.isMetaKey(i.keyCode)||j||f.isEditorOpened()))return void f.openEditor("");var k=i.shiftKey?d.setRangeEnd:d.setRangeStart;switch(i.keyCode){case g.A:j&&(d.selectAll(),i.preventDefault(),a.helper.stopPropagation(i));break;case g.ARROW_UP:f.isEditorOpened()&&!e.isWaiting()&&f.closeEditorAndSaveChanges(j),n(i.shiftKey),i.preventDefault(),a.helper.stopPropagation(i);break;case g.ARROW_DOWN:f.isEditorOpened()&&!e.isWaiting()&&f.closeEditorAndSaveChanges(j),o(i.shiftKey),i.preventDefault(),a.helper.stopPropagation(i);break;case g.ARROW_RIGHT:f.isEditorOpened()&&!e.isWaiting()&&f.closeEditorAndSaveChanges(j),p(i.shiftKey),i.preventDefault(),a.helper.stopPropagation(i);break;case g.ARROW_LEFT:f.isEditorOpened()&&!e.isWaiting()&&f.closeEditorAndSaveChanges(j),q(i.shiftKey),i.preventDefault(),a.helper.stopPropagation(i);break;case g.TAB:var r="function"==typeof c.settings.tabMoves?c.settings.tabMoves(i):c.settings.tabMoves;i.shiftKey?d.transformStart(-r.row,-r.col):d.transformStart(r.row,r.col,!0),i.preventDefault(),a.helper.stopPropagation(i);break;case g.BACKSPACE:case g.DELETE:d.empty(i),f.prepareEditor(),i.preventDefault();break;case g.F2:f.openEditor(),i.preventDefault();break;case g.ENTER:f.isEditorOpened()?(e.state!==a.EditorState.WAITING&&f.closeEditorAndSaveChanges(j),m(i.shiftKey)):b.getSettings().enterBeginsEditing?f.openEditor():m(i.shiftKey),i.preventDefault(),i.stopImmediatePropagation();break;case g.ESCAPE:f.isEditorOpened()&&f.closeEditorAndRestoreOriginalValue(j),i.preventDefault();break;case g.HOME:k(i.ctrlKey||i.metaKey?new l(0,c.selRange.from.col):new l(c.selRange.from.row,0)),i.preventDefault(),a.helper.stopPropagation(i);break;case g.END:k(i.ctrlKey||i.metaKey?new l(b.countRows()-1,c.selRange.from.col):new l(c.selRange.from.row,b.countCols()-1)),i.preventDefault(),a.helper.stopPropagation(i);break;case g.PAGE_UP:d.transformStart(-b.countVisibleRows(),0),i.preventDefault(),a.helper.stopPropagation(i);break;case g.PAGE_DOWN:d.transformStart(b.countVisibleRows(),0),i.preventDefault(),a.helper.stopPropagation(i)}}}function k(a,b,c){"TD"==c.nodeName&&f.openEditor()}function m(a){var b="function"==typeof c.settings.enterMoves?c.settings.enterMoves(event):c.settings.enterMoves;a?d.transformStart(-b.row,-b.col):d.transformStart(b.row,b.col,!0)}function n(a){a?d.transformEnd(-1,0):d.transformStart(-1,0)}function o(a){a?d.transformEnd(1,0):d.transformStart(1,0)}function p(a){a?d.transformEnd(0,1):d.transformStart(0,1)}function q(a){a?d.transformEnd(0,-1):d.transformStart(0,-1)}b.addHook("afterDocumentKeyDown",function(a){j(a)}),i.addEventListener(document,"keydown",function(a){b.runHooks("afterDocumentKeyDown",a)}),b.view.wt.update("onCellDblClick",k),b.addHook("afterDestroy",function(){h=!0})};this.destroyEditor=function(a){this.closeEditor(a)},this.getActiveEditor=function(){return e},this.prepareEditor=function(){if(e&&e.isWaiting())return void this.closeEditor(!1,!1,function(a){a&&f.prepareEditor()});var d=c.selRange.highlight.row,g=c.selRange.highlight.col,h=b.colToProp(g),i=b.getCell(d,g),j=b.getDataAtCell(d,g),k=b.getCellMeta(d,g),l=b.getCellEditor(k);e=a.editors.getEditor(l,b),e.prepare(d,g,h,i,j,k)},this.isEditorOpened=function(){return e.isOpened()},this.openEditor=function(a){e.cellProperties.readOnly||e.beginEditing(a)},this.closeEditor=function(a,b,c){e?e.finishEditing(a,b,c):c&&c(!1)},this.closeEditorAndSaveChanges=function(a){return this.closeEditor(!1,a)},this.closeEditorAndRestoreOriginalValue=function(a){return this.closeEditor(!0,a)},j()}}(b),function(a){var b={};a.renderers={registerRenderer:function(a,c){b[a]=c},getRenderer:function(a){if("function"==typeof a)return a;if("string"!=typeof a)throw Error('Only strings and functions can be passed as "renderer" parameter ');if(!(a in b))throw Error('No editor registered under name "'+a+'"');return b[a]}}}(b),b.helper.isPrintableChar=function(a){return 32==a||a>=48&&57>=a||a>=96&&111>=a||a>=186&&192>=a||a>=219&&222>=a||a>=226||a>=65&&90>=a},b.helper.isMetaKey=function(a){var c=b.helper.keyCode,d=[c.ARROW_DOWN,c.ARROW_UP,c.ARROW_LEFT,c.ARROW_RIGHT,c.HOME,c.END,c.DELETE,c.BACKSPACE,c.F1,c.F2,c.F3,c.F4,c.F5,c.F6,c.F7,c.F8,c.F9,c.F10,c.F11,c.F12,c.TAB,c.PAGE_DOWN,c.PAGE_UP,c.ENTER,c.ESCAPE,c.SHIFT,c.CAPS_LOCK,c.ALT];return-1!=d.indexOf(a)},b.helper.isCtrlKey=function(a){var c=b.helper.keyCode;return-1!=[c.CONTROL_LEFT,224,c.COMMAND_LEFT,c.COMMAND_RIGHT].indexOf(a)},b.helper.stringify=function(a){switch(typeof a){case"string":case"number":return a+"";case"object":return null===a?"":a.toString();case"undefined":return"";default:return a.toString()}},b.helper.spreadsheetColumnLabel=function(a){for(var b,c=a+1,d="";c>0;)b=(c-1)%26,d=String.fromCharCode(65+b)+d,c=parseInt((c-b)/26,10);return d},b.helper.isNumeric=function(a){var b=typeof a;return"number"==b?!isNaN(a)&&isFinite(a):"string"==b?a.length?1==a.length?/\d/.test(a):/^\s*[+-]?\s*(?:(?:\d+(?:\.\d+)?(?:e[+-]?\d+)?)|(?:0x[a-f\d]+))\s*$/i.test(a):!1:"object"==b?!(!a||"number"!=typeof a.valueOf()||a instanceof Date):!1},b.helper.isDescendant=function(a,b){for(var c=b.parentNode;null!=c;){if(c==a)return!0;c=c.parentNode}return!1},b.helper.randomString=function(){return s()},b.helper.inherit=function(a,b){return b.prototype.constructor=b,a.prototype=new b,a.prototype.constructor=a,a},b.helper.extend=function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])},b.helper.deepExtend=function(a,c){for(var d in c)c.hasOwnProperty(d)&&(c[d]&&"object"==typeof c[d]?(a[d]||(a[d]=b.helper.isArray(c[d])?[]:{}),b.helper.deepExtend(a[d],c[d])):a[d]=c[d])},b.helper.deepClone=function(a){return"object"==typeof a?JSON.parse(JSON.stringify(a)):a},b.helper.getPrototypeOf=function(a){var b;if("object"==typeof a.__proto__)b=a.__proto__;else{var c,d=a.constructor;"function"==typeof a.constructor&&(c=d,delete a.constructor&&(d=a.constructor,a.constructor=c)),b=d?d.prototype:null}return b},b.helper.columnFactory=function(a,c){function d(){}b.helper.inherit(d,a);for(var e=0,f=c.length;f>e;e++)d.prototype[c[e]]=void 0;return d},b.helper.translateRowsToColumns=function(a){var b,c,d,e,f=[],g=0;for(b=0,c=a.length;c>b;b++)for(d=0,e=a[b].length;e>d;d++)d==g&&(f.push([]),g++),f[d].push(a[b][d]);return f},b.helper.to2dArray=function(a){for(var b=0,c=a.length;c>b;)a[b]=[a[b]],b++},b.helper.extendArray=function(a,b){for(var c=0,d=b.length;d>c;)a.push(b[c]),c++},b.helper.isInput=function(a){var b=["INPUT","SELECT","TEXTAREA"];return b.indexOf(a.nodeName)>-1},b.helper.isOutsideInput=function(a){return b.helper.isInput(a)&&-1==a.className.indexOf("handsontableInput")},b.helper.keyCode={MOUSE_LEFT:1,MOUSE_RIGHT:3,MOUSE_MIDDLE:2,BACKSPACE:8,COMMA:188,INSERT:45,DELETE:46,END:35,ENTER:13,ESCAPE:27,CONTROL_LEFT:91,COMMAND_LEFT:17,COMMAND_RIGHT:93,ALT:18,HOME:36,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,SPACE:32,SHIFT:16,CAPS_LOCK:20,TAB:9,ARROW_RIGHT:39,ARROW_LEFT:37,ARROW_UP:38,ARROW_DOWN:40,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,A:65,X:88,C:67,V:86},b.helper.isObject=function(a){return"[object Object]"==Object.prototype.toString.call(a)},b.helper.isArray=function(a){return Array.isArray?Array.isArray(a):"[object Array]"==Object.prototype.toString.call(a)},b.helper.pivot=function(a){var b=[];if(!a||0==a.length||!a[0]||0==a[0].length)return b;for(var c=a.length,d=a[0].length,e=0;c>e;e++)for(var f=0;d>f;f++)b[f]||(b[f]=[]),b[f][e]=a[e][f];return b},b.helper.proxy=function(a,b){return function(){return a.apply(b,arguments)}},b.helper.cellMethodLookupFactory=function(a,c){function d(a){var c=b.cellTypes[a];if("undefined"==typeof c)throw new Error('You declared cell type "'+a+'" as a string that is not mapped to a known object. Cell type must be an object or a string mapped to an object in Handsontable.cellTypes');return c}return c="undefined"==typeof c?!0:c,function(e,f){return function g(e){if(e){if(e.hasOwnProperty(a)&&void 0!==e[a])return e[a];if(e.hasOwnProperty("type")&&e.type){var f;if("string"!=typeof e.type)throw new Error("Cell type must be a string ");if(f=d(e.type),f.hasOwnProperty(a))return f[a];if(c)return}return g(b.helper.getPrototypeOf(e))}}("number"==typeof e?this.getCellMeta(e,f):e)}},b.helper.toString=function(a){return""+a},b.helper.isMobileBrowser=function(a){return a||(a=navigator.userAgent),/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(a)},b.helper.isTouchSupported=function(){return"ontouchstart"in a},b.helper.stopPropagation=function(a){"function"==typeof a.stopPropagation?a.stopPropagation():a.cancelBubble=!0},b.helper.pageX=function(a){if(a.pageX)return a.pageX;var c=b.Dom.getWindowScrollLeft(),d=a.clientX+c;return d},b.helper.pageY=function(a){if(a.pageY)return a.pageY;var c=b.Dom.getWindowScrollTop(),d=a.clientY+c;return d},function(a){a.DataMap=function(a,b,c){this.instance=a,this.priv=b,this.GridSettings=c,this.dataSource=this.instance.getSettings().data,this.duckSchema=this.dataSource[0]?this.recursiveDuckSchema(this.dataSource[0]):{},this.createMap()},a.DataMap.prototype.DESTINATION_RENDERER=1,a.DataMap.prototype.DESTINATION_CLIPBOARD_GENERATOR=2,a.DataMap.prototype.recursiveDuckSchema=function(b){var c;if(a.helper.isArray(b))c=[];else{c={};for(var d in b)b.hasOwnProperty(d)&&(c[d]="object"!=typeof b[d]||a.helper.isArray(b[d])?null:this.recursiveDuckSchema(b[d]))}return c},a.DataMap.prototype.recursiveDuckColumns=function(b,c,d){var e,f;if("undefined"==typeof c&&(c=0,d=""),"object"==typeof b&&!a.helper.isArray(b))for(f in b)b.hasOwnProperty(f)&&(null===b[f]?(e=d+f,this.colToPropCache.push(e),this.propToColCache.set(e,c),c++):c=this.recursiveDuckColumns(b[f],c,f+"."));return c},a.DataMap.prototype.createMap=function(){var a,b,c=this.getSchema();if("undefined"==typeof c)throw new Error("trying to create `columns` definition but you didnt' provide `schema` nor `data`");this.colToPropCache=[],this.propToColCache=new MultiMap;var d=this.instance.getSettings().columns;if(d)for(a=0,b=d.length;b>a;a++)"undefined"!=typeof d[a].data&&(this.colToPropCache[a]=d[a].data,this.propToColCache.set(d[a].data,a));else this.recursiveDuckColumns(c)},a.DataMap.prototype.colToProp=function(b){return b=a.hooks.execute(this.instance,"modifyCol",b),this.colToPropCache&&"undefined"!=typeof this.colToPropCache[b]?this.colToPropCache[b]:b},a.DataMap.prototype.propToCol=function(b){var c;return c="undefined"!=typeof this.propToColCache.get(b)?this.propToColCache.get(b):b,c=a.hooks.execute(this.instance,"modifyCol",c)},a.DataMap.prototype.getSchema=function(){var a=this.instance.getSettings().dataSchema;return a?"function"==typeof a?a():a:this.duckSchema},a.DataMap.prototype.createRow=function(b,c,d){var e,f,g=this.instance.countCols(),h=0;c||(c=1),("number"!=typeof b||b>=this.instance.countRows())&&(b=this.instance.countRows()),f=b;for(var i=this.instance.getSettings().maxRows;c>h&&this.instance.countRows()<i;){if("array"===this.instance.dataType){e=[];for(var j=0;g>j;j++)e.push(null)}else"function"===this.instance.dataType?e=this.instance.getSettings().dataSchema(b):(e={},a.helper.deepExtend(e,this.getSchema()));b===this.instance.countRows()?this.dataSource.push(e):this.dataSource.splice(b,0,e),h++,f++}return a.hooks.run(this.instance,"afterCreateRow",b,h,d),this.instance.forceFullRender=!0,h},a.DataMap.prototype.createCol=function(b,c,d){if("object"===this.instance.dataType||this.instance.getSettings().columns)throw new Error("Cannot create new column. When data source in an object, you can only have as much columns as defined in first data row, data schema or in the 'columns' setting.If you want to be able to add new columns, you have to use array datasource.");var e,f,g=this.instance.countRows(),h=this.dataSource,i=0;c||(c=1),f=b;for(var j=this.instance.getSettings().maxCols;c>i&&this.instance.countCols()<j;){if(e=a.helper.columnFactory(this.GridSettings,this.priv.columnsSettingConflicts),"number"!=typeof b||b>=this.instance.countCols()){for(var k=0;g>k;k++)"undefined"==typeof h[k]&&(h[k]=[]),h[k].push(null);this.priv.columnSettings.push(e)}else{for(var k=0;g>k;k++)h[k].splice(f,0,null);this.priv.columnSettings.splice(f,0,e)}i++,f++}return a.hooks.run(this.instance,"afterCreateCol",b,i,d),this.instance.forceFullRender=!0,i},a.DataMap.prototype.removeRow=function(b,c){c||(c=1),"number"!=typeof b&&(b=-c),b=(this.instance.countRows()+b)%this.instance.countRows();var d=this.physicalRowsToLogical(b,c),e=a.hooks.execute(this.instance,"beforeRemoveRow",b,c);if(e!==!1){var f=this.dataSource,g=f.filter(function(a,b){return-1==d.indexOf(b)});f.length=0,Array.prototype.push.apply(f,g),a.hooks.run(this.instance,"afterRemoveRow",b,c),this.instance.forceFullRender=!0}},a.DataMap.prototype.removeCol=function(b,c){if("object"===this.instance.dataType||this.instance.getSettings().columns)throw new Error("cannot remove column with object data source or columns option specified");c||(c=1),"number"!=typeof b&&(b=-c),b=(this.instance.countCols()+b)%this.instance.countCols();var d=a.hooks.execute(this.instance,"beforeRemoveCol",b,c);if(d!==!1){for(var e=this.dataSource,f=0,g=this.instance.countRows();g>f;f++)e[f].splice(b,c);this.priv.columnSettings.splice(b,c),a.hooks.run(this.instance,"afterRemoveCol",b,c),this.instance.forceFullRender=!0}},a.DataMap.prototype.spliceCol=function(b,c,d){var e=4<=arguments.length?[].slice.call(arguments,3):[],f=this.instance.getDataAtCol(b),g=f.slice(c,c+d),h=f.slice(c+d);a.helper.extendArray(e,h);for(var i=0;d>i;)e.push(null),i++;return a.helper.to2dArray(e),this.instance.populateFromArray(c,b,e,null,null,"spliceCol"),g},a.DataMap.prototype.spliceRow=function(b,c,d){var e=4<=arguments.length?[].slice.call(arguments,3):[],f=this.instance.getSourceDataAtRow(b),g=f.slice(c,c+d),h=f.slice(c+d);a.helper.extendArray(e,h);for(var i=0;d>i;)e.push(null),i++;return this.instance.populateFromArray(b,c,[e],null,null,"spliceRow"),g},a.DataMap.prototype.get=function(b,c){if(b=a.hooks.execute(this.instance,"modifyRow",b),"string"==typeof c&&c.indexOf(".")>-1){var d=c.split("."),e=this.dataSource[b];if(!e)return null;for(var f=0,g=d.length;g>f;f++)if(e=e[d[f]],"undefined"==typeof e)return null;return e}return"function"==typeof c?c(this.dataSource.slice(b,b+1)[0]):this.dataSource[b]?this.dataSource[b][c]:null};var b=a.helper.cellMethodLookupFactory("copyable",!1);a.DataMap.prototype.getCopyable=function(a,c){return b.call(this.instance,a,this.propToCol(c))?this.get(a,c):""},a.DataMap.prototype.set=function(b,c,d,e){if(b=a.hooks.execute(this.instance,"modifyRow",b,e||"datamapGet"),"string"==typeof c&&c.indexOf(".")>-1){for(var f=c.split("."),g=this.dataSource[b],h=0,i=f.length-1;i>h;h++)"undefined"==typeof g[f[h]]&&(g[f[h]]={}),g=g[f[h]];g[f[h]]=d}else"function"==typeof c?c(this.dataSource.slice(b,b+1)[0],d):this.dataSource[b][c]=d},a.DataMap.prototype.physicalRowsToLogical=function(b,c){for(var d,e=this.instance.countRows(),f=(e+b)%e,g=[],h=c;e>f&&h;)d=a.hooks.execute(this.instance,"modifyRow",f),g.push(d),h--,f++;return g},a.DataMap.prototype.clear=function(){for(var a=0;a<this.instance.countRows();a++)for(var b=0;b<this.instance.countCols();b++)this.set(a,this.colToProp(b),"")},a.DataMap.prototype.getAll=function(){return this.dataSource},a.DataMap.prototype.getRange=function(a,b,c){var d,e,f,g,h,i=[],j=c===this.DESTINATION_CLIPBOARD_GENERATOR?this.getCopyable:this.get;for(e=Math.max(a.row,b.row),g=Math.max(a.col,b.col),d=Math.min(a.row,b.row);e>=d;d++){for(h=[],f=Math.min(a.col,b.col);g>=f;f++)h.push(j.call(this,d,this.colToProp(f)));i.push(h)}return i},a.DataMap.prototype.getText=function(a,b){return SheetClip.stringify(this.getRange(a,b,this.DESTINATION_RENDERER))},a.DataMap.prototype.getCopyableText=function(a,b){return SheetClip.stringify(this.getRange(a,b,this.DESTINATION_CLIPBOARD_GENERATOR))}}(b),function(a){a.renderers.cellDecorator=function(b,c,d,e,f,g,h){h.className&&(c.className=c.className?c.className+" "+h.className:h.className),h.readOnly&&a.Dom.addClass(c,h.readOnlyCellClassName),h.valid===!1&&h.invalidCellClassName&&a.Dom.addClass(c,h.invalidCellClassName),h.wordWrap===!1&&h.noWordWrapClassName&&a.Dom.addClass(c,h.noWordWrapClassName),!g&&h.placeholder&&a.Dom.addClass(c,h.placeholderCellClassName)}}(b),function(a){var b=function(b,c,d,e,f,g,h){a.renderers.cellDecorator.apply(this,arguments),!g&&h.placeholder&&(g=h.placeholder);var i=a.helper.stringify(g);if(h.rendererTemplate){a.Dom.empty(c);var j=document.createElement("TEMPLATE");j.setAttribute("bind","{{}}"),j.innerHTML=h.rendererTemplate,HTMLTemplateElement.decorate(j),j.model=b.getSourceDataAtRow(d),c.appendChild(j)}else a.Dom.fastInnerText(c,i)};a.renderers.TextRenderer=b,a.renderers.registerRenderer("text",b)}(b),function(a){var b=document.createElement("DIV");b.className="htAutocompleteWrapper";var c=document.createElement("DIV");c.className="htAutocompleteArrow",c.appendChild(document.createTextNode("▼"));var d=function(d,e,f,g,h,i,j){var k=(b.cloneNode(!0),c.cloneNode(!0));if(a.renderers.TextRenderer(d,e,f,g,h,i,j),e.appendChild(k),a.Dom.addClass(e,"htAutocomplete"),e.firstChild||e.appendChild(document.createTextNode(" ")),!d.acArrowListener){var m=a.eventManager(d);d.acArrowListener=function(b){a.Dom.hasClass(b.target,"htAutocompleteArrow")&&d.view.wt.getSetting("onCellDblClick",null,new l(f,g),e)},m.addEventListener(d.rootElement,"mousedown",d.acArrowListener),d.addHookOnce("afterDestroy",function(){m.clear()})}};a.AutocompleteRenderer=d,a.renderers.AutocompleteRenderer=d,a.renderers.registerRenderer("autocomplete",d)}(b),function(a){var b=document.createElement("INPUT");b.className="htCheckboxRendererInput",b.type="checkbox",b.setAttribute("autocomplete","off");var c=function(c,d,e,f,g,h,i){var j=a.eventManager(c);"undefined"==typeof i.checkedTemplate&&(i.checkedTemplate=!0),"undefined"==typeof i.uncheckedTemplate&&(i.uncheckedTemplate=!1),a.Dom.empty(d);var k=b.cloneNode(!1);h===i.checkedTemplate||h===a.helper.stringify(i.checkedTemplate)?(k.checked=!0,d.appendChild(k)):h===i.uncheckedTemplate||h===a.helper.stringify(i.uncheckedTemplate)?d.appendChild(k):null===h?(k.className+=" noValue",d.appendChild(k)):a.Dom.fastInnerText(d,"#bad value#"),i.readOnly?j.addEventListener(k,"click",function(a){a.preventDefault()}):(j.addEventListener(k,"mousedown",function(b){a.helper.stopPropagation(b)}),j.addEventListener(k,"mouseup",function(b){a.helper.stopPropagation(b)}),j.addEventListener(k,"change",function(){this.checked?c.setDataAtRowProp(e,g,i.checkedTemplate):c.setDataAtRowProp(e,g,i.uncheckedTemplate)})),c.CheckboxRenderer&&c.CheckboxRenderer.beforeKeyDownHookBound||(c.CheckboxRenderer={beforeKeyDownHookBound:!0},c.addHook("beforeKeyDown",function(b){if(a.Dom.enableImmediatePropagation(b),b.keyCode==a.helper.keyCode.SPACE||b.keyCode==a.helper.keyCode.ENTER)for(var d,e,f,g=c.getSelectedRange(),h=g.getTopLeftCorner(),i=g.getBottomRightCorner(),k=h.row;k<=i.row;k++)for(var l=h.col;l<=i.col;l++)if(d=c.getCell(k,l),f=c.getCellMeta(k,l),e=d.querySelectorAll("input[type=checkbox]"),e.length>0&&!f.readOnly){b.isImmediatePropagationStopped()||(b.stopImmediatePropagation(),b.preventDefault());for(var m=0,n=e.length;n>m;m++)e[m].checked=!e[m].checked,j.fireEvent(e[m],"change")}}))};a.CheckboxRenderer=c,a.renderers.CheckboxRenderer=c,a.renderers.registerRenderer("checkbox",c)}(b),function(a){var b=function(b,c,d,e,f,g,h){a.helper.isNumeric(g)&&("undefined"!=typeof h.language&&numeral.language(h.language),g=numeral(g).format(h.format||"0"),a.Dom.addClass(c,"htNumeric")),a.renderers.TextRenderer(b,c,d,e,f,g,h)};a.NumericRenderer=b,a.renderers.NumericRenderer=b,a.renderers.registerRenderer("numeric",b)}(b),function(a){var c=function(a,c,d,e,f,g,h){b.renderers.TextRenderer.apply(this,arguments),g=c.innerHTML;var i,j=h.hashLength||g.length,k=h.hashSymbol||"*";for(i="";i.split(k).length-1<j;i+=k);b.Dom.fastInnerHTML(c,i)};a.PasswordRenderer=c,a.renderers.PasswordRenderer=c,a.renderers.registerRenderer("password",c)}(b),function(a){function b(b,c,d,e,f,g){a.renderers.cellDecorator.apply(this,arguments),a.Dom.fastInnerHTML(c,g)}a.renderers.registerRenderer("html",b),a.renderers.HtmlRenderer=b}(b),function(a){function b(b){this.instance=b,this.state=a.EditorState.VIRGIN,this._opened=!1,this._closeCallback=null,this.init()}a.EditorState={VIRGIN:"STATE_VIRGIN",EDITING:"STATE_EDITING",WAITING:"STATE_WAITING",FINISHED:"STATE_FINISHED"},b.prototype._fireCallbacks=function(a){this._closeCallback&&(this._closeCallback(a),this._closeCallback=null)},b.prototype.init=function(){},b.prototype.getValue=function(){throw Error("Editor getValue() method unimplemented")},b.prototype.setValue=function(){throw Error("Editor setValue() method unimplemented")},b.prototype.open=function(){throw Error("Editor open() method unimplemented")},b.prototype.close=function(){throw Error("Editor close() method unimplemented")},b.prototype.prepare=function(b,c,d,e,f,g){this.TD=e,this.row=b,this.col=c,this.prop=d,this.originalValue=f,this.cellProperties=g,this.state=a.EditorState.VIRGIN},b.prototype.extend=function(){function a(){c.apply(this,arguments)}function b(a,b){function c(){}return c.prototype=b.prototype,a.prototype=new c,a.prototype.constructor=a,a}var c=this.constructor;return b(a,c)},b.prototype.saveValue=function(a,b){if(b){var c,d=this.instance.getSelected();d[0]>d[2]&&(c=d[0],d[0]=d[2],d[2]=c),d[1]>d[3]&&(c=d[1],d[1]=d[3],d[3]=c),this.instance.populateFromArray(d[0],d[1],a,d[2],d[3],"edit")}else this.instance.populateFromArray(this.row,this.col,a,null,null,"edit")},b.prototype.beginEditing=function(b){this.state==a.EditorState.VIRGIN&&(this.instance.view.scrollViewport(new l(this.row,this.col)),this.instance.view.render(),this.state=a.EditorState.EDITING,b="string"==typeof b?b:this.originalValue,this.setValue(a.helper.stringify(b)),this.open(),this._opened=!0,this.focus(),this.instance.view.render())},b.prototype.finishEditing=function(b,c,d){if(d){var e=this._closeCallback;this._closeCallback=function(a){e&&e(a),d(a)}}if(!this.isWaiting()){if(this.state==a.EditorState.VIRGIN){var f=this;return void this.instance._registerTimeout(setTimeout(function(){f._fireCallbacks(!0)},0))}if(this.state==a.EditorState.EDITING){if(b)return void this.cancelChanges();var g=[[String.prototype.trim.call(this.getValue())]];if(this.state=a.EditorState.WAITING,this.saveValue(g,c),this.instance.getCellValidator(this.cellProperties)){var f=this;this.instance.addHookOnce("afterValidate",function(b){f.state=a.EditorState.FINISHED,f.discardEditor(b)})}else this.state=a.EditorState.FINISHED,this.discardEditor(!0)}}},b.prototype.cancelChanges=function(){this.state=a.EditorState.FINISHED,this.discardEditor()},b.prototype.discardEditor=function(b){this.state===a.EditorState.FINISHED&&(b===!1&&this.cellProperties.allowInvalid!==!0?(this.instance.selectCell(this.row,this.col),this.focus(),this.state=a.EditorState.EDITING,this._fireCallbacks(!1)):(this.close(),this._opened=!1,this.state=a.EditorState.VIRGIN,this._fireCallbacks(!0)))},b.prototype.isOpened=function(){return this._opened},b.prototype.isWaiting=function(){return this.state===a.EditorState.WAITING},a.editors.BaseEditor=b}(b),function(a){var b=a.editors.BaseEditor.prototype.extend();b.prototype.init=function(){var b=this;this.createElements(),this.eventManager=new a.eventManager(this),this.bindEvents(),this.autoResize=H(),this.instance.addHook("afterDestroy",function(){b.destroy()})},b.prototype.getValue=function(){return this.TEXTAREA.value},b.prototype.setValue=function(a){this.TEXTAREA.value=a};var c=function(b){var c=this,d=c.getActiveEditor(),e=a.helper.keyCode,f=(b.ctrlKey||b.metaKey)&&!b.altKey;if(a.Dom.enableImmediatePropagation(b),b.target===d.TEXTAREA&&!b.isImmediatePropagationStopped()){if(17===b.keyCode||224===b.keyCode||91===b.keyCode||93===b.keyCode)return void b.stopImmediatePropagation();switch(b.keyCode){case e.ARROW_RIGHT:a.Dom.getCaretPosition(d.TEXTAREA)!==d.TEXTAREA.value.length&&b.stopImmediatePropagation();break;case e.ARROW_LEFT:0!==a.Dom.getCaretPosition(d.TEXTAREA)&&b.stopImmediatePropagation();break;case e.ENTER:var g=d.instance.getSelected(),h=!(g[0]===g[2]&&g[1]===g[3]);(f&&!h||b.altKey)&&(d.isOpened()?(d.setValue(d.getValue()+"\n"),d.focus()):d.beginEditing(d.originalValue+"\n"),b.stopImmediatePropagation()),b.preventDefault();break;case e.A:case e.X:case e.C:case e.V:f&&b.stopImmediatePropagation();break;case e.BACKSPACE:case e.DELETE:case e.HOME:case e.END:b.stopImmediatePropagation()}}};b.prototype.open=function(){this.refreshDimensions(),this.instance.addHook("beforeKeyDown",c)},b.prototype.close=function(){this.textareaParentStyle.display="none",this.autoResize.unObserve(),document.activeElement===this.TEXTAREA&&this.instance.listen(),this.instance.removeHook("beforeKeyDown",c)},b.prototype.focus=function(){this.TEXTAREA.focus(),a.Dom.setCaretPosition(this.TEXTAREA,this.TEXTAREA.value.length)},b.prototype.createElements=function(){this.TEXTAREA=document.createElement("TEXTAREA"),a.Dom.addClass(this.TEXTAREA,"handsontableInput"),this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,this.TEXTAREA_PARENT=document.createElement("DIV"),a.Dom.addClass(this.TEXTAREA_PARENT,"handsontableInputHolder"),this.textareaParentStyle=this.TEXTAREA_PARENT.style,this.textareaParentStyle.top=0,this.textareaParentStyle.left=0,this.textareaParentStyle.display="none",this.TEXTAREA_PARENT.appendChild(this.TEXTAREA),this.instance.rootElement.appendChild(this.TEXTAREA_PARENT);var b=this;this.instance._registerTimeout(setTimeout(function(){b.refreshDimensions()},0))},b.prototype.checkEditorSection=function(){return this.row<this.instance.getSettings().fixedRowsTop?this.col<this.instance.getSettings().fixedColumnsLeft?"corner":"top":this.col<this.instance.getSettings().fixedColumnsLeft?"left":void 0},b.prototype.getEditedCell=function(){var a,b=this.checkEditorSection();switch(b){case"top":a=this.instance.view.wt.wtScrollbars.vertical.clone.wtTable.getCell({row:this.row,col:this.col}),this.textareaParentStyle.zIndex=101;break;case"corner":a=this.instance.view.wt.wtScrollbars.corner.clone.wtTable.getCell({row:this.row,col:this.col}),this.textareaParentStyle.zIndex=103;break;case"left":a=this.instance.view.wt.wtScrollbars.horizontal.clone.wtTable.getCell({row:this.row,col:this.col}),this.textareaParentStyle.zIndex=102;break;default:a=this.instance.getCell(this.row,this.col),this.textareaParentStyle.zIndex=""}return-1!=a&&-2!=a?a:void 0},b.prototype.refreshDimensions=function(){if(this.state===a.EditorState.EDITING&&(this.TD=this.getEditedCell(),this.TD)){var b,c=a.Dom.offset(this.TD),d=a.Dom.offset(this.instance.rootElement),e=c.top-d.top-1,f=c.left-d.left-1,g=this.instance.getSettings(),h=g.rowHeaders===!1?0:1,i=g.colHeaders===!1?0:1,j=this.checkEditorSection();switch(j){case"top":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.vertical.clone.wtTable.holder.parentNode);break;case"left":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.horizontal.clone.wtTable.holder.parentNode);break;case"corner":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.corner.clone.wtTable.holder.parentNode)}0>e&&(e=0),0>f&&(f=0),h>0&&parseInt(this.TD.style.borderTopWidth,10)>0&&(e+=1),i>0&&parseInt(this.TD.style.borderLeftWidth,10)>0&&(f+=1),b&&-1!=b?this.textareaParentStyle[b[0]]=b[1]:a.Dom.resetCssTransform(this.textareaParentStyle),this.textareaParentStyle.top=e+"px",this.textareaParentStyle.left=f+"px";var k=this.TD.offsetTop-this.instance.view.wt.wtScrollbars.vertical.getScrollPosition(),l=this.TD.offsetLeft-this.instance.view.wt.wtScrollbars.horizontal.getScrollPosition(),m=a.Dom.innerWidth(this.TD)-8,n=this.instance.view.maximumVisibleElementWidth(l)-10,o=a.Dom.outerHeight(this.TD)-4,p=this.instance.view.maximumVisibleElementHeight(k)-2;parseInt(this.TD.style.borderTopWidth,10)>0&&(o-=1),parseInt(this.TD.style.borderLeftWidth,10)>0&&h>0&&(m-=1),this.TEXTAREA.style.fontSize=a.Dom.getComputedStyle(this.TD).fontSize,this.TEXTAREA.style.fontFamily=a.Dom.getComputedStyle(this.TD).fontFamily,this.autoResize.init(this.TEXTAREA,{minHeight:Math.min(o,p),maxHeight:p,minWidth:Math.min(m,n),maxWidth:n}),this.textareaParentStyle.display="block"}},b.prototype.bindEvents=function(){var b=this;this.eventManager.addEventListener(this.TEXTAREA,"cut",function(b){a.helper.stopPropagation(b)}),this.eventManager.addEventListener(this.TEXTAREA,"paste",function(b){a.helper.stopPropagation(b)}),this.instance.addHook("afterScrollVertically",function(){b.refreshDimensions()}),this.instance.addHook("afterDestroy",function(){b.eventManager.clear()})},b.prototype.destroy=function(){this.eventManager.clear()},a.editors.TextEditor=b,a.editors.registerEditor("text",a.editors.TextEditor)}(b),function(b){var c=b.editors.BaseEditor.prototype.extend(),d={},e=function(){this.controls={},this.controls.leftButton=document.createElement("DIV"),this.controls.leftButton.className="leftButton",this.controls.rightButton=document.createElement("DIV"),this.controls.rightButton.className="rightButton",this.controls.upButton=document.createElement("DIV"),this.controls.upButton.className="upButton",this.controls.downButton=document.createElement("DIV"),this.controls.downButton.className="downButton";
for(var a in this.controls)this.positionControls.appendChild(this.controls[a])};c.prototype.valueChanged=function(){return this.initValue!=this.getValue()},c.prototype.init=function(){var a=this;this.eventManager=new b.eventManager(this.instance),this.createElements(),this.bindEvents(),this.instance.addHook("afterDestroy",function(){a.destroy()})},c.prototype.getValue=function(){return this.TEXTAREA.value},c.prototype.setValue=function(a){this.initValue=a,this.TEXTAREA.value=a},c.prototype.createElements=function(){this.editorContainer=document.createElement("DIV"),this.editorContainer.className="htMobileEditorContainer",this.cellPointer=document.createElement("DIV"),this.cellPointer.className="cellPointer",this.moveHandle=document.createElement("DIV"),this.moveHandle.className="moveHandle",this.inputPane=document.createElement("DIV"),this.inputPane.className="inputs",this.positionControls=document.createElement("DIV"),this.positionControls.className="positionControls",this.TEXTAREA=document.createElement("TEXTAREA"),b.Dom.addClass(this.TEXTAREA,"handsontableInput"),this.inputPane.appendChild(this.TEXTAREA),this.editorContainer.appendChild(this.cellPointer),this.editorContainer.appendChild(this.moveHandle),this.editorContainer.appendChild(this.inputPane),this.editorContainer.appendChild(this.positionControls),e.call(this),document.body.appendChild(this.editorContainer)},c.prototype.onBeforeKeyDown=function(a){var c=this,d=c.getActiveEditor();if(b.Dom.enableImmediatePropagation(a),a.target===d.TEXTAREA&&!a.isImmediatePropagationStopped()){var e=b.helper.keyCode;switch(a.keyCode){case e.ENTER:d.close(),a.preventDefault();break;case e.BACKSPACE:a.stopImmediatePropagation()}}},c.prototype.open=function(){this.instance.addHook("beforeKeyDown",this.onBeforeKeyDown),b.Dom.addClass(this.editorContainer,"active"),b.Dom.removeClass(this.cellPointer,"hidden"),this.updateEditorPosition()},c.prototype.focus=function(){this.TEXTAREA.focus(),b.Dom.setCaretPosition(this.TEXTAREA,this.TEXTAREA.value.length)},c.prototype.close=function(){this.TEXTAREA.blur(),this.instance.removeHook("beforeKeyDown",this.onBeforeKeyDown),b.Dom.removeClass(this.editorContainer,"active")},c.prototype.scrollToView=function(){var a=this.instance.getSelectedRange().highlight;this.instance.view.scrollViewport(a)},c.prototype.hideCellPointer=function(){b.Dom.hasClass(this.cellPointer,"hidden")||b.Dom.addClass(this.cellPointer,"hidden")},c.prototype.updateEditorPosition=function(c,e){if(c&&e)c=parseInt(c,10),e=parseInt(e,10),this.editorContainer.style.top=e+"px",this.editorContainer.style.left=c+"px";else{var f=this.instance.getSelected(),g=this.instance.getCell(f[0],f[1]);if(d.cellPointer||(d.cellPointer={height:b.Dom.outerHeight(this.cellPointer),width:b.Dom.outerWidth(this.cellPointer)}),d.editorContainer||(d.editorContainer={width:b.Dom.outerWidth(this.editorContainer)}),void 0!=g){var h=this.instance.view.wt.wtScrollbars.horizontal.scrollHandler==a?0:b.Dom.getScrollLeft(this.instance.view.wt.wtScrollbars.horizontal.scrollHandler),i=this.instance.view.wt.wtScrollbars.vertical.scrollHandler==a?0:b.Dom.getScrollTop(this.instance.view.wt.wtScrollbars.vertical.scrollHandler),j=b.Dom.offset(g),k=b.Dom.outerWidth(g),l={x:h,y:i};this.editorContainer.style.top=parseInt(j.top+b.Dom.outerHeight(g)-l.y+d.cellPointer.height,10)+"px",this.editorContainer.style.left=parseInt(a.innerWidth/2-d.editorContainer.width/2,10)+"px",j.left+k/2>parseInt(this.editorContainer.style.left,10)+d.editorContainer.width?this.editorContainer.style.left=a.innerWidth-d.editorContainer.width+"px":j.left+k/2<parseInt(this.editorContainer.style.left,10)+20&&(this.editorContainer.style.left="0px"),this.cellPointer.style.left=parseInt(j.left-d.cellPointer.width/2-b.Dom.offset(this.editorContainer).left+k/2-l.x,10)+"px"}}},c.prototype.updateEditorData=function(){var a=this.instance.getSelected(),b=this.instance.getDataAtCell(a[0],a[1]);this.row=a[0],this.col=a[1],this.setValue(b),this.updateEditorPosition()},c.prototype.prepareAndSave=function(){if(!this.valueChanged())return!0;var a=[[String.prototype.trim.call(this.getValue())]];this.saveValue(a)},c.prototype.bindEvents=function(){var c=this;this.eventManager.addEventListener(this.controls.leftButton,"touchend",function(a){c.prepareAndSave(),c.instance.selection.transformStart(0,-1,null,!0),c.updateEditorData(),a.preventDefault()}),this.eventManager.addEventListener(this.controls.rightButton,"touchend",function(a){c.prepareAndSave(),c.instance.selection.transformStart(0,1,null,!0),c.updateEditorData(),a.preventDefault()}),this.eventManager.addEventListener(this.controls.upButton,"touchend",function(a){c.prepareAndSave(),c.instance.selection.transformStart(-1,0,null,!0),c.updateEditorData(),a.preventDefault()}),this.eventManager.addEventListener(this.controls.downButton,"touchend",function(a){c.prepareAndSave(),c.instance.selection.transformStart(1,0,null,!0),c.updateEditorData(),a.preventDefault()}),this.eventManager.addEventListener(this.moveHandle,"touchstart",function(a){if(1==a.touches.length){var b=a.touches[0],d={x:c.editorContainer.offsetLeft,y:c.editorContainer.offsetTop},e={x:b.pageX-d.x,y:b.pageY-d.y};c.eventManager.addEventListener(this,"touchmove",function(a){var b=a.touches[0];c.updateEditorPosition(b.pageX-e.x,b.pageY-e.y),c.hideCellPointer(),a.preventDefault()})}}),this.eventManager.addEventListener(document.body,"touchend",function(a){b.Dom.isChildOf(a.target,c.editorContainer)||b.Dom.isChildOf(a.target,c.instance.rootElement)||c.close()}),this.eventManager.addEventListener(this.instance.view.wt.wtScrollbars.horizontal.scrollHandler,"scroll",function(){c.instance.view.wt.wtScrollbars.horizontal.scrollHandler!=a&&c.hideCellPointer()}),this.eventManager.addEventListener(this.instance.view.wt.wtScrollbars.vertical.scrollHandler,"scroll",function(){c.instance.view.wt.wtScrollbars.vertical.scrollHandler!=a&&c.hideCellPointer()})},c.prototype.destroy=function(){this.eventManager.clear(),this.editorContainer.parentNode.removeChild(this.editorContainer)},b.editors.MobileTextEditor=c,b.editors.registerEditor("mobile",b.editors.MobileTextEditor)}(b),function(a){var b=a.editors.BaseEditor.prototype.extend();b.prototype.beginEditing=function(){var a=this.TD.querySelector('input[type="checkbox"]');a&&a.click()},b.prototype.finishEditing=function(){},b.prototype.init=function(){},b.prototype.open=function(){},b.prototype.close=function(){},b.prototype.getValue=function(){},b.prototype.setValue=function(){},b.prototype.focus=function(){},a.editors.CheckboxEditor=b,a.editors.registerEditor("checkbox",b)}(b),function(a){var b,c=a.editors.TextEditor.prototype.extend();c.prototype.init=function(){if("undefined"==typeof jQuery)throw new Error("You need to include jQuery to your project in order to use the jQuery UI Datepicker.");if(b=jQuery,!b.datepicker)throw new Error("jQuery UI Datepicker dependency not found. Did you forget to include jquery-ui.custom.js or its substitute?");a.editors.TextEditor.prototype.init.apply(this,arguments),this.isCellEdited=!1;var c=this;this.instance.addHook("afterDestroy",function(){c.destroyElements()})},c.prototype.createElements=function(){a.editors.TextEditor.prototype.createElements.apply(this,arguments),this.datePicker=document.createElement("DIV"),a.Dom.addClass(this.datePicker,"htDatepickerHolder"),this.datePickerStyle=this.datePicker.style,this.datePickerStyle.position="absolute",this.datePickerStyle.top=0,this.datePickerStyle.left=0,this.datePickerStyle.zIndex=99,document.body.appendChild(this.datePicker),this.$datePicker=b(this.datePicker);var c=this,d={dateFormat:"yy-mm-dd",showButtonPanel:!0,changeMonth:!0,changeYear:!0,onSelect:function(a){c.setValue(a),c.finishEditing(!1)}};this.$datePicker.datepicker(d);var e=a.eventManager(this);e.addEventListener(this.datePicker,"mousedown",function(b){a.helper.stopPropagation(b)}),this.hideDatepicker()},c.prototype.destroyElements=function(){this.$datePicker.datepicker("destroy"),this.$datePicker.remove()},c.prototype.open=function(){a.editors.TextEditor.prototype.open.call(this),this.showDatepicker()},c.prototype.finishEditing=function(){this.hideDatepicker(),a.editors.TextEditor.prototype.finishEditing.apply(this,arguments)},c.prototype.showDatepicker=function(){var b=a.Dom.offset(this.TD);this.datePickerStyle.top=b.top+a.Dom.outerHeight(this.TD)+"px",this.datePickerStyle.left=b.left+"px";var c=function(){};c.prototype=this.cellProperties;var d=new c;d.defaultDate=this.originalValue||void 0,this.$datePicker.datepicker("option",d),this.originalValue&&this.$datePicker.datepicker("setDate",this.originalValue),this.datePickerStyle.display="block"},c.prototype.hideDatepicker=function(){this.datePickerStyle.display="none"},a.editors.DateEditor=c,a.editors.registerEditor("date",c)}(b),function(a){var b=a.editors.TextEditor.prototype.extend();b.prototype.createElements=function(){a.editors.TextEditor.prototype.createElements.apply(this,arguments);var b=document.createElement("DIV");b.className="handsontableEditor",this.TEXTAREA_PARENT.appendChild(b),this.htContainer=b,this.htEditor=new a(b),this.assignHooks()},b.prototype.prepare=function(b,c,d,e,f,g){a.editors.TextEditor.prototype.prepare.apply(this,arguments);var h=this,i={startRows:0,startCols:0,minRows:0,minCols:0,className:"listbox",copyPaste:!1,cells:function(){return{readOnly:!0}},fillHandle:!1,afterOnCellMouseDown:function(){var a=this.getValue();void 0!==a&&h.setValue(a),h.instance.destroyEditor()}};this.cellProperties.handsontable&&a.helper.extend(i,g.handsontable),this.htEditor&&this.htEditor.destroy(),this.htEditor=new a(this.htContainer,i)};var c=function(b){if(null!=b&&null==b.isImmediatePropagationEnabled&&(b.stopImmediatePropagation=function(){this.isImmediatePropagationEnabled=!1,this.cancelBubble=!0},b.isImmediatePropagationEnabled=!0,b.isImmediatePropagationStopped=function(){return!this.isImmediatePropagationEnabled}),!b.isImmediatePropagationStopped()){var c,d=this.getActiveEditor(),e=d.htEditor.getInstance();if(b.keyCode==a.helper.keyCode.ARROW_DOWN)if(e.getSelected()){var f=e.getSelected()[0],g=e.countRows()-1;c=Math.min(g,f+1)}else c=0;else if(b.keyCode==a.helper.keyCode.ARROW_UP&&e.getSelected()){var f=e.getSelected()[0];c=f-1}void 0!==c&&(0>c?e.deselectCell():e.selectCell(c,0),b.preventDefault(),b.stopImmediatePropagation(),d.instance.listen(),d.TEXTAREA.focus())}};b.prototype.open=function(){this.instance.addHook("beforeKeyDown",c),a.editors.TextEditor.prototype.open.apply(this,arguments),this.htEditor.render(),this.cellProperties.strict?(this.htEditor.selectCell(0,0),this.TEXTAREA.style.visibility="hidden"):(this.htEditor.deselectCell(),this.TEXTAREA.style.visibility="visible"),a.Dom.setCaretPosition(this.TEXTAREA,0,this.TEXTAREA.value.length)},b.prototype.close=function(){this.instance.removeHook("beforeKeyDown",c),this.instance.listen(),a.editors.TextEditor.prototype.close.apply(this,arguments)},b.prototype.focus=function(){this.instance.listen(),a.editors.TextEditor.prototype.focus.apply(this,arguments)},b.prototype.beginEditing=function(){var b=this.instance.getSettings().onBeginEditing;b&&b()===!1||a.editors.TextEditor.prototype.beginEditing.apply(this,arguments)},b.prototype.finishEditing=function(){if(this.htEditor.isListening()&&this.instance.listen(),this.htEditor.getSelected()){var b=this.htEditor.getInstance().getValue();void 0!==b&&this.setValue(b)}return a.editors.TextEditor.prototype.finishEditing.apply(this,arguments)},b.prototype.assignHooks=function(){var a=this;this.instance.addHook("afterDestroy",function(){a.htEditor&&a.htEditor.destroy()})},a.editors.HandsontableEditor=b,a.editors.registerEditor("handsontable",b)}(b),function(b){var c=b.editors.HandsontableEditor.prototype.extend();c.prototype.init=function(){b.editors.HandsontableEditor.prototype.init.apply(this,arguments);var a=this.htEditor.getInstance();a.updateSettings({height:1}),this.query=null,this.choices=[]},c.prototype.createElements=function(){b.editors.HandsontableEditor.prototype.createElements.apply(this,arguments);var c=function(){return-1!=a.navigator.platform.indexOf("Mac")?"htMacScroll":""};b.Dom.addClass(this.htContainer,"autocompleteEditor"),b.Dom.addClass(this.htContainer,c())};var d=!1,e=function(a){d=!1;var c=this.getActiveEditor(),e=b.helper.keyCode;if(b.helper.isPrintableChar(a.keyCode)||a.keyCode===e.BACKSPACE||a.keyCode===e.DELETE||a.keyCode===e.INSERT){var f=0;if(a.keyCode===e.C&&(a.ctrlKey||a.metaKey))return;c.isOpened()||(f+=10),c.instance._registerTimeout(setTimeout(function(){c.queryChoices(c.TEXTAREA.value),d=!0},f))}};c.prototype.prepare=function(){this.instance.addHook("beforeKeyDown",e),b.editors.HandsontableEditor.prototype.prepare.apply(this,arguments)},c.prototype.open=function(){b.editors.HandsontableEditor.prototype.open.apply(this,arguments),this.TEXTAREA.style.visibility="visible",this.focus();var a=this.htEditor.getInstance(),c=this;a.updateSettings({colWidths:[b.Dom.outerWidth(this.TEXTAREA)-2],afterRenderer:function(a,b,d,e,f){var g=this.getCellMeta(b,d).filteringCaseSensitive===!0;if(f){var h=g?f.indexOf(this.query):f.toLowerCase().indexOf(c.query.toLowerCase());if(-1!=h){var i=f.substr(h,c.query.length);a.innerHTML=f.replace(i,"<strong>"+i+"</strong>")}}}}),d&&(d=!1),c.instance._registerTimeout(setTimeout(function(){c.queryChoices(c.TEXTAREA.value)},0))},c.prototype.close=function(){b.editors.HandsontableEditor.prototype.close.apply(this,arguments)},c.prototype.queryChoices=function(a){if(this.query=a,"function"==typeof this.cellProperties.source){var c=this;this.cellProperties.source(a,function(a){c.updateChoicesList(a)})}else if(b.helper.isArray(this.cellProperties.source)){var d;if(a&&this.cellProperties.filter!==!1){var e=this.cellProperties.filteringCaseSensitive===!0,f=a.toLowerCase();d=this.cellProperties.source.filter(function(b){return e?-1!=b.indexOf(a):-1!=b.toLowerCase().indexOf(f)})}else d=this.cellProperties.source;this.updateChoicesList(d)}else this.updateChoicesList([])},c.prototype.updateChoicesList=function(a){var d,e=b.Dom.getCaretPosition(this.TEXTAREA),f=b.Dom.getSelectionEndPosition(this.TEXTAREA),g=c.sortByRelevance(this.getValue(),a,this.cellProperties.filteringCaseSensitive);if(0!=this.cellProperties.filter){for(var h=[],i=0,j=g.length;j>i;i++)h.push(a[g[i]]);d=0,a=h}else d=g[0];this.choices=a,this.htEditor.loadData(b.helper.pivot([a])),this.htEditor.updateSettings({height:this.getDropdownHeight()}),this.cellProperties.strict===!0&&this.highlightBestMatchingChoice(d),this.instance.listen(),this.TEXTAREA.focus(),b.Dom.setCaretPosition(this.TEXTAREA,e,e!=f?f:void 0)},c.prototype.finishEditing=function(a){a||this.instance.removeHook("beforeKeyDown",e),b.editors.HandsontableEditor.prototype.finishEditing.apply(this,arguments)},c.prototype.highlightBestMatchingChoice=function(a){"number"==typeof a?this.htEditor.selectCell(a,0):this.htEditor.deselectCell()},c.sortByRelevance=function(a,b,c){var d,e,f,g,h,i=[],j=a.length,k=[];if(0===j){for(g=0,h=b.length;h>g;g++)k.push(g);return k}for(g=0,h=b.length;h>g;g++)d=b[g],e=c?d.indexOf(a):d.toLowerCase().indexOf(a.toLowerCase()),-1!=e&&(f=d.length-e-j,i.push({baseIndex:g,index:e,charsLeft:f,value:d}));for(i.sort(function(a,b){return-1===b.index?-1:-1===a.index?1:a.index<b.index?-1:b.index<a.index?1:a.index===b.index?a.charsLeft<b.charsLeft?-1:a.charsLeft>b.charsLeft?1:0:void 0}),g=0,h=i.length;h>g;g++)k.push(i[g].baseIndex);return k},c.prototype.getDropdownHeight=function(){var a=this.htEditor.getInstance().getRowHeight(0)||23;return this.choices.length>=10?10*a:this.choices.length*a+8},b.editors.AutocompleteEditor=c,b.editors.registerEditor("autocomplete",c)}(b),function(a){var b=a.editors.TextEditor.prototype.extend();b.prototype.createElements=function(){a.editors.TextEditor.prototype.createElements.apply(this,arguments),this.TEXTAREA=document.createElement("input"),this.TEXTAREA.setAttribute("type","password"),this.TEXTAREA.className="handsontableInput",this.textareaStyle=this.TEXTAREA.style,this.textareaStyle.width=0,this.textareaStyle.height=0,a.Dom.empty(this.TEXTAREA_PARENT),this.TEXTAREA_PARENT.appendChild(this.TEXTAREA)},a.editors.PasswordEditor=b,a.editors.registerEditor("password",b)}(b),function(a){var b=a.editors.BaseEditor.prototype.extend();b.prototype.init=function(){this.select=document.createElement("SELECT"),a.Dom.addClass(this.select,"htSelectEditor"),this.select.style.display="none",this.instance.rootElement.appendChild(this.select)},b.prototype.prepare=function(){a.editors.BaseEditor.prototype.prepare.apply(this,arguments);var b,c=this.cellProperties.selectOptions;b=this.prepareOptions("function"==typeof c?c(this.row,this.col,this.prop):c),a.Dom.empty(this.select);for(var d in b)if(b.hasOwnProperty(d)){var e=document.createElement("OPTION");e.value=d,a.Dom.fastInnerHTML(e,b[d]),this.select.appendChild(e)}},b.prototype.prepareOptions=function(b){var c={};if(a.helper.isArray(b))for(var d=0,e=b.length;e>d;d++)c[b[d]]=b[d];else"object"==typeof b&&(c=b);return c},b.prototype.getValue=function(){return this.select.value},b.prototype.setValue=function(a){this.select.value=a};var c=function(b){var c=this,d=c.getActiveEditor();switch(b.keyCode){case a.helper.keyCode.ARROW_UP:var e=d.select.find("option:selected").prev();1==e.length&&e.prop("selected",!0),b.stopImmediatePropagation(),b.preventDefault();break;case a.helper.keyCode.ARROW_DOWN:var f=d.select.find("option:selected").next();1==f.length&&f.prop("selected",!0),b.stopImmediatePropagation(),b.preventDefault()}};b.prototype.checkEditorSection=function(){return this.row<this.instance.getSettings().fixedRowsTop?this.col<this.instance.getSettings().fixedColumnsLeft?"corner":"top":this.col<this.instance.getSettings().fixedColumnsLeft?"left":void 0},b.prototype.open=function(){var b,d=a.Dom.outerWidth(this.TD),e=a.Dom.outerHeight(this.TD),f=a.Dom.offset(this.instance.rootElement),g=a.Dom.offset(this.TD),h=this.checkEditorSection();switch(h){case"top":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.vertical.clone.wtTable.holder.parentNode);break;case"left":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.horizontal.clone.wtTable.holder.parentNode);break;case"corner":b=a.Dom.getCssTransform(this.instance.view.wt.wtScrollbars.corner.clone.wtTable.holder.parentNode)}var i=this.select.style;b&&-1!=b?i[b[0]]=b[1]:a.Dom.resetCssTransform(this.select),i.height=e+"px",i.minWidth=d+"px",i.top=g.top-f.top+"px",i.left=g.left-f.left+"px",i.margin="0px",i.display="",this.instance.addHook("beforeKeyDown",c)},b.prototype.close=function(){this.select.style.display="none",this.instance.removeHook("beforeKeyDown",c)},b.prototype.focus=function(){this.select.focus()},a.editors.SelectEditor=b,a.editors.registerEditor("select",b)}(b),function(a){var b=a.editors.AutocompleteEditor.prototype.extend();b.prototype.prepare=function(){a.editors.AutocompleteEditor.prototype.prepare.apply(this,arguments),this.cellProperties.filter=!1,this.cellProperties.strict=!0},a.editors.DropdownEditor=b,a.editors.registerEditor("dropdown",b)}(b),function(a){var b=a.editors.TextEditor.prototype.extend();b.prototype.beginEditing=function(b){var c=a.editors.TextEditor.prototype;if("undefined"==typeof b&&this.originalValue){var d=""+this.originalValue;"undefined"!=typeof this.cellProperties.language&&numeral.language(this.cellProperties.language);var e=numeral.languageData().delimiters.decimal;d=d.replace(".",e),c.beginEditing.apply(this,[d])}else c.beginEditing.apply(this,arguments)},a.editors.NumericEditor=b,a.editors.registerEditor("numeric",b)}(b),b.NumericValidator=function(a,b){null===a&&(a=""),b(/^-?\d*(\.|\,)?\d*$/.test(a))};var G=function(a,b){var c=a,d="string"==typeof c?c.toLowerCase():null;return function(a){for(var e=!1,f=0,g=a.length;g>f;f++){if(c===a[f]){e=!0;break}if(d===a[f].toLowerCase()){e=!0;break}}b(e)}};b.AutocompleteValidator=function(a,b){this.strict&&this.source?"function"==typeof this.source?this.source(a,G(a,b)):G(a,b)(this.source):b(!0)},b.mobileBrowser=b.helper.isMobileBrowser(),b.AutocompleteCell={editor:b.editors.AutocompleteEditor,renderer:b.renderers.AutocompleteRenderer,validator:b.AutocompleteValidator},b.CheckboxCell={editor:b.editors.CheckboxEditor,renderer:b.renderers.CheckboxRenderer},b.TextCell={editor:b.mobileBrowser?b.editors.MobileTextEditor:b.editors.TextEditor,renderer:b.renderers.TextRenderer},b.NumericCell={editor:b.editors.NumericEditor,renderer:b.renderers.NumericRenderer,validator:b.NumericValidator,dataType:"number"},b.DateCell={editor:b.editors.DateEditor,renderer:b.renderers.AutocompleteRenderer},b.HandsontableCell={editor:b.editors.HandsontableEditor,renderer:b.renderers.AutocompleteRenderer},b.PasswordCell={editor:b.editors.PasswordEditor,renderer:b.renderers.PasswordRenderer,copyable:!1},b.DropdownCell={editor:b.editors.DropdownEditor,renderer:b.renderers.AutocompleteRenderer,validator:b.AutocompleteValidator},b.cellTypes={text:b.TextCell,date:b.DateCell,numeric:b.NumericCell,checkbox:b.CheckboxCell,autocomplete:b.AutocompleteCell,handsontable:b.HandsontableCell,password:b.PasswordCell,dropdown:b.DropdownCell},b.cellLookup={validator:{numeric:b.NumericValidator,autocomplete:b.AutocompleteValidator}};var H=function(){var c,d={minHeight:200,maxHeight:300,minWidth:100,maxWidth:300},e=document.body,f=document.createTextNode(""),g=document.createElement("SPAN"),h=function(b,c,d){a.attachEvent?b.attachEvent("on"+c,d):b.addEventListener(c,d,!1)},i=function(b,c,d){a.removeEventListener?b.removeEventListener(c,d,!1):b.detachEvent("on"+c,d)},j=function(){void 0!==f.textContent?f.textContent=c.value:f.data=c.value,g.style.fontSize=b.Dom.getComputedStyle(c).fontSize,g.style.fontFamily=b.Dom.getComputedStyle(c).fontFamily,e.appendChild(g);var a=g.clientWidth;e.removeChild(g),c.style.height=d.minHeight+"px",c.style.width=d.minWidth>a?d.minWidth+"px":a>d.maxWidth?d.maxWidth+"px":a+"px";var h=c.scrollHeight;d.minHeight>h?c.style.height=d.minHeight+"px":d.maxHeight<h?(c.style.height=d.maxHeight+"px",c.style.overflowY="visible"):c.style.height=h+"px"},k=function(){a.setTimeout(j,0)},l=function(a){if(a&&a.minHeight)if("inherit"==a.minHeight)d.minHeight=c.clientHeight;else{var b=parseInt(a.minHeight);isNaN(b)||(d.minHeight=b)}if(a&&a.maxHeight)if("inherit"==a.maxHeight)d.maxHeight=c.clientHeight;else{var e=parseInt(a.maxHeight);isNaN(e)||(d.maxHeight=e)}if(a&&a.minWidth)if("inherit"==a.minWidth)d.minWidth=c.clientWidth;else{var h=parseInt(a.minWidth);isNaN(h)||(d.minWidth=h)}if(a&&a.maxWidth)if("inherit"==a.maxWidth)d.maxWidth=c.clientWidth;else{var i=parseInt(a.maxWidth);isNaN(i)||(d.maxWidth=i)}g.firstChild||(g.className="autoResize",g.style.display="inline-block",g.appendChild(f))},m=function(a,b){c=a,l(b),"TEXTAREA"==c.nodeName&&(c.style.resize="none",c.style.overflowY="",c.style.height=d.minHeight+"px",c.style.minWidth=d.minWidth+"px",c.style.maxWidth=d.maxWidth+"px",c.style.overflowY="hidden"),h(c,"change",j),h(c,"cut",k),h(c,"paste",k),h(c,"drop",k),h(c,"keydown",k),j()};return{init:function(a,b){m(a,b)},unObserve:function(){i(c,"change",j),i(c,"cut",k),i(c,"paste",k),i(c,"drop",k),i(c,"keydown",k)}}};!function(a){function b(a){return a.split('"').length-1}a.SheetClip={parse:function(a){var c,d,e,f,g,h,i,j=[],k=0;for(e=a.split("\n"),e.length>1&&""===e[e.length-1]&&e.pop(),c=0,d=e.length;d>c;c+=1){for(e[c]=e[c].split("	"),f=0,g=e[c].length;g>f;f+=1)j[k]||(j[k]=[]),h&&0===f?(i=j[k].length-1,j[k][i]=j[k][i]+"\n"+e[c][0],h&&1&b(e[c][0])&&(h=!1,j[k][i]=j[k][i].substring(0,j[k][i].length-1).replace(/""/g,'"'))):f===g-1&&0===e[c][f].indexOf('"')?(j[k].push(e[c][f].substring(1).replace(/""/g,'"')),h=!0):(j[k].push(e[c][f].replace(/""/g,'"')),h=!1);h||(k+=1)}return j},stringify:function(a){var b,c,d,e,f,g="";for(b=0,c=a.length;c>b;b+=1){for(d=0,e=a[b].length;e>d;d+=1)d>0&&(g+="	"),f=a[b][d],g+="string"==typeof f?f.indexOf("\n")>-1?'"'+f.replace(/"/g,'""')+'"':f:null===f||void 0===f?"":f;c-1>b&&(g+="\n")}return g}}}(a);var I=function(){var a;return{getInstance:function(){return a?a.hasBeenDestroyed()&&a.init():a=new c,a.refCounter++,a}}}();c.prototype.init=function(){var a,c,d=this;this.copyCallbacks=[],this.cutCallbacks=[],this.pasteCallbacks=[],this._eventManager=b.eventManager(this),c=document.body,document.getElementById("CopyPasteDiv")?(this.elDiv=document.getElementById("CopyPasteDiv"),this.elTextarea=this.elDiv.firstChild):(this.elDiv=document.createElement("DIV"),this.elDiv.id="CopyPasteDiv",a=this.elDiv.style,a.position="fixed",a.top="-10000px",a.left="-10000px",c.appendChild(this.elDiv),this.elTextarea=document.createElement("TEXTAREA"),this.elTextarea.className="copyPaste",this.elTextarea.onpaste=function(a){return"WebkitAppearance"in document.documentElement.style?(this.value=a.clipboardData.getData("Text"),!1):void 0},a=this.elTextarea.style,a.width="10000px",a.height="10000px",a.overflow="hidden",this.elDiv.appendChild(this.elTextarea),"undefined"!=typeof a.opacity&&(a.opacity=0)),this.keydownListener=function(a){var b=!1;if(a.metaKey?b=!0:a.ctrlKey&&-1===navigator.userAgent.indexOf("Mac")&&(b=!0),b){if(document.activeElement!==d.elTextarea&&(""!=d.getSelectionText()||-1!=["INPUT","SELECT","TEXTAREA"].indexOf(document.activeElement.nodeName)))return;d.selectNodeText(d.elTextarea),setTimeout(function(){d.selectNodeText(d.elTextarea)},0)}!b||67!==a.keyCode&&86!==a.keyCode&&88!==a.keyCode||(88===a.keyCode?setTimeout(function(){d.triggerCut(a)},0):86===a.keyCode&&setTimeout(function(){d.triggerPaste(a)},0))},this._eventManager.addEventListener(document.documentElement,"keydown",this.keydownListener,!1)},c.prototype.selectNodeText=function(a){a&&a.select()},c.prototype.getSelectionText=function(){var b="";return a.getSelection?b=a.getSelection().toString():document.selection&&"Control"!=document.selection.type&&(b=document.selection.createRange().text),b},c.prototype.copyable=function(a){if("string"!=typeof a&&void 0===a.toString)throw new Error("copyable requires string parameter");this.elTextarea.value=a},c.prototype.onCut=function(a){this.cutCallbacks.push(a)},c.prototype.onPaste=function(a){this.pasteCallbacks.push(a)},c.prototype.removeCallback=function(a){var b,c;for(b=0,c=this.copyCallbacks.length;c>b;b++)if(this.copyCallbacks[b]===a)return this.copyCallbacks.splice(b,1),!0;for(b=0,c=this.cutCallbacks.length;c>b;b++)if(this.cutCallbacks[b]===a)return this.cutCallbacks.splice(b,1),!0;for(b=0,c=this.pasteCallbacks.length;c>b;b++)if(this.pasteCallbacks[b]===a)return this.pasteCallbacks.splice(b,1),!0;return!1},c.prototype.triggerCut=function(a){var b=this;b.cutCallbacks&&setTimeout(function(){for(var c=0,d=b.cutCallbacks.length;d>c;c++)b.cutCallbacks[c](a)},50)},c.prototype.triggerPaste=function(a,b){var c=this;c.pasteCallbacks&&setTimeout(function(){for(var d=(b||c.elTextarea.value).replace(/\n$/,""),e=0,f=c.pasteCallbacks.length;f>e;e++)c.pasteCallbacks[e](d,a)},50)},c.prototype.destroy=function(){this.hasBeenDestroyed()||0!=--this.refCounter||(this.elDiv&&this.elDiv.parentNode&&(this.elDiv.parentNode.removeChild(this.elDiv),this.elDiv=null,this.elTextarea=null),this._eventManager.removeEventListener(document.documentElement,"keydown",this.keydownListener,!1))},c.prototype.hasBeenDestroyed=function(){return!this.refCounter};var J;!function(b){function c(a){return-1===a.indexOf("/")&&-1===a.indexOf("~")?a:a.replace(/~/g,"~0").replace(/\//g,"~1")}function d(a,b){var e;for(var f in a)if(a.hasOwnProperty(f)){if(a[f]===b)return c(f)+"/";if("object"==typeof a[f]&&(e=d(a[f],b),""!=e))return c(f)+"/"+e}return""}function e(a,b){if(a===b)return"/";var c=d(a,b);if(""===c)throw new Error("Object not found in root");return"/"+c}function f(a){for(var b=0,c=s.length;c>b;b++)if(s[b].obj===a)return s[b]}function g(a,b){for(var c=0,d=a.observers.length;d>c;c++)if(a.observers[c].callback===b)return a.observers[c].observer}function h(a,b){for(var c=0,d=a.observers.length;d>c;c++)if(a.observers[c].observer===b)return void a.observers.splice(c,1)}function i(a,b){m(b),Object.observe?l(b,a):clearTimeout(b.next);var c=f(a);h(c,b)}function j(b,c){var d,h=[],i=b,j=f(b);if(j?d=g(j,c):(j=new t(b),s.push(j)),d)return d;if(Object.observe)d=function(a){l(d,b),k(d,b);for(var f=0,g=a.length;g>f;){if(("length"!==a[f].name||!w(a[f].object))&&"__Jasmine_been_here_before__"!==a[f].name){var j=a[f].type;switch(j){case"new":j="add";break;case"deleted":j="delete";break;case"updated":j="update"}r[j].call(a[f],h,e(i,a[f].object))}f++}h&&c&&c(h),d.patches=h,h=[]};else if(d={},j.value=JSON.parse(JSON.stringify(b)),c){d.callback=c,d.next=null;var n=this.intervals||[100,1e3,1e4,6e4],o=0,p=function(){m(d)},q=function(){clearTimeout(d.next),d.next=setTimeout(function(){p(),o=0,d.next=setTimeout(v,n[o++])},0)},v=function(){p(),o==n.length&&(o=n.length-1),d.next=setTimeout(v,n[o++])};"undefined"!=typeof a&&(a.addEventListener?(a.addEventListener("mousedown",q),a.addEventListener("mouseup",q),a.addEventListener("keydown",q)):(a.attachEvent("onmousedown",q),a.attachEvent("onmouseup",q),a.attachEvent("onkeydown",q))),d.next=setTimeout(v,n[o++])}return d.patches=h,d.object=b,j.observers.push(new u(c,d)),k(d,b)}function k(a,b){if(Object.observe){Object.observe(b,a);for(var c in b)if(b.hasOwnProperty(c)){var d=b[c];d&&"object"==typeof d&&k(a,d)}}return a}function l(a,b){if(Object.observe){Object.unobserve(b,a);for(var c in b)if(b.hasOwnProperty(c)){var d=b[c];d&&"object"==typeof d&&l(a,d)}}return a}function m(a){if(Object.observe)Object.deliverChangeRecords(a);else{for(var b,c=0,d=s.length;d>c;c++)if(s[c].obj===a.object){b=s[c];break}n(b.value,a.object,a.patches,"")}var e=a.patches;return e.length>0&&(a.patches=[],a.callback&&a.callback(e)),e}function n(a,b,d,e){for(var f=v(b),g=v(a),h=!1,i=!1,j=g.length-1;j>=0;j--){var k=g[j],l=a[k];if(b.hasOwnProperty(k)){var m=b[k];l instanceof Object?n(l,m,d,e+"/"+c(k)):l!=m&&(h=!0,d.push({op:"replace",path:e+"/"+c(k),value:m}),a[k]=m)}else d.push({op:"remove",path:e+"/"+c(k)}),delete a[k],i=!0}if(i||f.length!=g.length)for(var j=0;j<f.length;j++){var k=f[j];a.hasOwnProperty(k)||(d.push({op:"add",path:e+"/"+c(k),value:b[k]}),a[k]=JSON.parse(JSON.stringify(b[k])))}}function o(a,b){for(var c,d=!1,e=0,f=b.length;f>e;){c=b[e];for(var g=c.path.split("/"),h=a,i=1,j=g.length;;)if(w(h)){var k=parseInt(g[i],10);if(i++,i>=j){d=q[c.op].call(c,h,k,a);break}h=h[k]}else{var l=g[i];if(-1!=l.indexOf("~")&&(l=l.replace(/~1/g,"/").replace(/~0/g,"~")),i++,i>=j){d=p[c.op].call(c,h,l,a);break}h=h[l]}e++}return d}var p={add:function(a,b){return a[b]=this.value,!0},remove:function(a,b){return delete a[b],!0},replace:function(a,b){return a[b]=this.value,!0},move:function(a,b,c){var d={op:"_get",path:this.from};return o(c,[d]),o(c,[{op:"remove",path:this.from}]),o(c,[{op:"add",path:this.path,value:d.value}]),!0},copy:function(a,b,c){var d={op:"_get",path:this.from};return o(c,[d]),o(c,[{op:"add",path:this.path,value:d.value}]),!0},test:function(a,b){return JSON.stringify(a[b])===JSON.stringify(this.value)},_get:function(a,b){this.value=a[b]}},q={add:function(a,b){return a.splice(b,0,this.value),!0},remove:function(a,b){return a.splice(b,1),!0},replace:function(a,b){return a[b]=this.value,!0},move:p.move,copy:p.copy,test:p.test,_get:p._get},r={add:function(a,b){var d={op:"add",path:b+c(this.name),value:this.object[this.name]};a.push(d)},"delete":function(a,b){var d={op:"remove",path:b+c(this.name)};a.push(d)},update:function(a,b){var d={op:"replace",path:b+c(this.name),value:this.object[this.name]};a.push(d)}},s=[];b.intervals;var t=function(){function a(a){this.observers=[],this.obj=a}return a}(),u=function(){function a(a,b){this.callback=a,this.observer=b}return a}();b.unobserve=i,b.observe=j,b.generate=m;var v;v=Object.keys?Object.keys:function(a){var b=[];for(var c in a)a.hasOwnProperty(c)&&b.push(c);return b};var w;w=Array.isArray?Array.isArray:function(a){return a.push&&"number"==typeof a.length},b.apply=o}(J||(J={})),"undefined"!=typeof exports&&(exports.apply=J.apply,exports.observe=J.observe,exports.unobserve=J.unobserve,exports.generate=J.generate),b.PluginHookClass=function(){function a(){this.hooks=c(),this.globalBucket={},this.legacy=d
}var c=function(){return{beforeInitWalkontable:[],beforeInit:[],beforeRender:[],beforeSetRangeEnd:[],beforeDrawBorders:[],beforeChange:[],beforeChangeRender:[],beforeRemoveCol:[],beforeRemoveRow:[],beforeValidate:[],beforeGetCellMeta:[],beforeAutofill:[],beforeKeyDown:[],beforeOnCellMouseDown:[],beforeTouchScroll:[],afterInit:[],afterLoadData:[],afterUpdateSettings:[],afterRender:[],afterRenderer:[],afterChange:[],afterValidate:[],afterGetCellMeta:[],afterSetCellMeta:[],afterGetColHeader:[],afterGetRowHeader:[],afterDestroy:[],afterRemoveRow:[],afterCreateRow:[],afterRemoveCol:[],afterCreateCol:[],afterDeselect:[],afterSelection:[],afterSelectionByProp:[],afterSelectionEnd:[],afterSelectionEndByProp:[],afterOnCellMouseDown:[],afterOnCellMouseOver:[],afterOnCellCornerMouseDown:[],afterScrollVertically:[],afterScrollHorizontally:[],afterCellMetaReset:[],afterIsMultipleSelectionCheck:[],afterDocumentKeyDown:[],afterMomentumScroll:[],modifyColWidth:[],modifyRowHeight:[],modifyRow:[],modifyCol:[]}},d={onBeforeChange:"beforeChange",onChange:"afterChange",onCreateRow:"afterCreateRow",onCreateCol:"afterCreateCol",onSelection:"afterSelection",onCopyLimit:"afterCopyLimit",onSelectionEnd:"afterSelectionEnd",onSelectionByProp:"afterSelectionByProp",onSelectionEndByProp:"afterSelectionEndByProp"};return a.prototype.getBucket=function(a){return a?(a.pluginHookBucket||(a.pluginHookBucket={}),a.pluginHookBucket):this.globalBucket},a.prototype.add=function(a,c,e){if(b.helper.isArray(c))for(var f=0,g=c.length;g>f;f++)this.add(a,c[f]);else{a in d&&(a=d[a]);var h=this.getBucket(e);"undefined"==typeof h[a]&&(h[a]=[]),c.skip=!1,-1==h[a].indexOf(c)&&h[a].push(c)}return this},a.prototype.once=function(a,c,d){if(b.helper.isArray(c))for(var e=0,f=c.length;f>e;e++)c[e].runOnce=!0,this.add(a,c[e],d);else c.runOnce=!0,this.add(a,c,d)},a.prototype.remove=function(a,b,c){var e=!1;a in d&&(a=d[a]);var f=this.getBucket(c);if("undefined"!=typeof f[a])for(var g=0,h=f[a].length;h>g;g++)if(f[a][g]==b){f[a][g].skip=!0,e=!0;break}return e},a.prototype.run=function(a,b,c,e,f,g,h,i){b in d&&(b=d[b]),this._runBucket(this.globalBucket,a,b,c,e,f,g,h,i),this._runBucket(this.getBucket(a),a,b,c,e,f,g,h,i)},a.prototype._runBucket=function(a,b,c,d,e,f,g,h,i){var j=a[c];if(j)for(var k=0,l=j.length;l>k;k++)j[k].skip||(j[k].call(b,d,e,f,g,h,i),j[k].runOnce&&this.remove(c,j[k],a===this.globalBucket?null:b))},a.prototype.destroy=function(a){var b=this.getBucket(a);for(var c in b)if(b.hasOwnProperty(c))for(var d=0,e=b[c].length;e>d;d++)this.remove(c,b[c],a)},a.prototype.execute=function(a,b,c,e,f,g,h,i){return b in d&&(b=d[b]),c=this._executeBucket(this.globalBucket,a,b,c,e,f,g,h,i),c=this._executeBucket(this.getBucket(a),a,b,c,e,f,g,h,i)},a.prototype._executeBucket=function(a,b,c,d,e,f,g,h,i){var j,k=a[c];if(k)for(var l=0,m=k.length;m>l;l++)if(!k[l].skip&&(j=k[l].call(b,d,e,f,g,h,i),void 0!==j&&(d=j),k[l].runOnce&&this.remove(c,k[l],a===this.globalBucket?null:b),j===!1))return!1;return d},a.prototype.register=function(a){this.isRegistered(a)||(this.hooks[a]=[])},a.prototype.deregister=function(a){delete this.hooks[a]},a.prototype.isRegistered=function(a){return"undefined"!=typeof this.hooks[a]},a.prototype.getRegistered=function(){return Object.keys(this.hooks)},a}(),b.hooks=new b.PluginHookClass,b.PluginHooks=b.hooks,function(a){function b(){function b(a){var b=document,c=this;c.table=b.createElement("table"),c.theadTh=b.createElement("th"),c.table.appendChild(b.createElement("thead")).appendChild(b.createElement("tr")).appendChild(c.theadTh),c.tableStyle=c.table.style,c.tableStyle.tableLayout="auto",c.tableStyle.width="auto",c.tbody=b.createElement("tbody"),c.table.appendChild(c.tbody),c.container=b.createElement("div"),c.container.className=a.rootElement.className+" hidden",c.containerStyle=c.container.style,c.container.appendChild(c.table)}var d=this,e=5;this.beforeInit=function(){var a=this;a.autoColumnWidths=[],a.getSettings().autoColumnSize!==!1?a.autoColumnSizeTmp||(a.autoColumnSizeTmp={table:null,tableStyle:null,theadTh:null,tbody:null,container:null,containerStyle:null,determineBeforeNextRender:!0},a.addHook("beforeRender",c.determineIfChanged),a.addHook("modifyColWidth",c.modifyColWidth),a.addHook("afterDestroy",c.afterDestroy),a.determineColumnWidth=d.determineColumnWidth):a.autoColumnSizeTmp&&(a.removeHook("beforeRender",c.determineIfChanged),a.removeHook("modifyColWidth",c.modifyColWidth),a.removeHook("afterDestroy",c.afterDestroy),delete a.determineColumnWidth,d.afterDestroy.call(a))},this.determineIfChanged=function(a){a&&c.determineColumnsWidth.apply(this,arguments)},this.determineColumnWidth=function(c){var d=this,f=d.autoColumnSizeTmp;f.container||b.call(f,d),f.container.className=d.rootElement.className+" htAutoColumnSize",f.table.className=d.table.className;for(var g=d.countRows(),h={},i=0,j=0;g>j;j++){var k=a.helper.stringify(d.getDataAtCell(j,c)),l=k.length;l>i&&(i=l),h[l]||(h[l]={needed:e,strings:[]}),h[l].needed&&(h[l].strings.push({value:k,row:j}),h[l].needed--)}var m=d.getSettings();m.colHeaders&&d.view.appendColHeader(c,f.theadTh),a.Dom.empty(f.tbody);for(var n in h)if(h.hasOwnProperty(n))for(var o=0,p=h[n].strings.length;p>o;o++){var q=h[n].strings[o].row,r=d.getCellMeta(q,c);r.col=c,r.row=q;var s=d.getCellRenderer(r),t=document.createElement("tr"),u=document.createElement("td");s(d,u,q,c,d.colToProp(c),h[n].strings[o].value,r),j++,t.appendChild(u),f.tbody.appendChild(t)}var v=d.rootElement.parentNode;v.appendChild(f.container);var w=a.Dom.outerWidth(f.table);return v.removeChild(f.container),w},this.determineColumnsWidth=function(){var a=this,b=this.getSettings();if(b.autoColumnSize||!b.colWidths)for(var c=this.countCols(),e=0;c>e;e++)a._getColWidthFromSettings(e)||(this.autoColumnWidths[e]=d.determineColumnWidth.call(a,e))},this.modifyColWidth=function(a,b){return this.autoColumnWidths[b]&&this.autoColumnWidths[b]>a?this.autoColumnWidths[b]:a},this.afterDestroy=function(){var a=this;a.autoColumnSizeTmp&&a.autoColumnSizeTmp.container&&a.autoColumnSizeTmp.container.parentNode&&a.autoColumnSizeTmp.container.parentNode.removeChild(a.autoColumnSizeTmp.container),a.autoColumnSizeTmp=null}}var c=new b;a.hooks.add("beforeInit",c.beforeInit),a.hooks.add("afterUpdateSettings",c.beforeInit)}(b);var K=new d;b.hooks.add("afterInit",function(){K.init.call(this,"afterInit")}),b.hooks.add("afterUpdateSettings",function(){K.init.call(this,"afterUpdateSettings")}),b.hooks.add("modifyRow",K.translateRow),b.hooks.add("afterGetColHeader",K.getColHeader),b.hooks.register("beforeColumnSort"),b.hooks.register("afterColumnSort"),function(a){function b(a,b){return-1!=a.indexOf(b)?a:(a=a.replace("htTop","").replace("htMiddle","").replace("htBottom","").replace("  ",""),a+=" "+b)}function c(a,b){return-1!=a.indexOf(b)?a:(a=a.replace("htLeft","").replace("htCenter","").replace("htRight","").replace("htJustify","").replace("  ",""),a+=" "+b)}function d(a,d,e,f){var g=this.getCellMeta(a,d),h=f;g.className&&(h="vertical"===e?b(g.className,f):c(g.className,f)),this.setCellMeta(a,d,"className",h),this.render()}function e(a,b,c){if(a.from.row==a.to.row&&a.from.col==a.to.col)d.call(this,a.from.row,a.from.col,b,c);else for(var e=a.from.row;e<=a.to.row;e++)for(var f=a.from.col;f<=a.to.col;f++)d.call(this,e,f,b,c)}function f(b){this.instance=b;var c=this;if(c.menus=[],c.htMenus={},c.triggerRows=[],c.eventManager=a.eventManager(c),this.enabled=!0,this.instance.addHook("afterDestroy",function(){c.destroy()}),this.defaultOptions={items:[{key:"row_above",name:"Insert row above",callback:function(a,b){this.alter("insert_row",b.start.row)},disabled:function(){var a=this.getSelected(),b=[0,a[1],this.countRows()-1,a[1]],c=b.join(",")==a.join(",");return a[0]<0||this.countRows()>=this.getSettings().maxRows||c}},{key:"row_below",name:"Insert row below",callback:function(a,b){this.alter("insert_row",b.end.row+1)},disabled:function(){var a=this.getSelected(),b=[0,a[1],this.countRows()-1,a[1]],c=b.join(",")==a.join(",");return this.getSelected()[0]<0||this.countRows()>=this.getSettings().maxRows||c}},f.SEPARATOR,{key:"col_left",name:"Insert column on the left",callback:function(a,b){this.alter("insert_col",b.start.col)},disabled:function(){var a=this.getSelected(),b=[a[0],0,a[0],this.countCols()-1],c=b.join(",")==a.join(",");return this.getSelected()[1]<0||this.countCols()>=this.getSettings().maxCols||c}},{key:"col_right",name:"Insert column on the right",callback:function(a,b){this.alter("insert_col",b.end.col+1)},disabled:function(){var a=this.getSelected(),b=[a[0],0,a[0],this.countCols()-1],c=b.join(",")==a.join(",");return a[1]<0||this.countCols()>=this.getSettings().maxCols||c}},f.SEPARATOR,{key:"remove_row",name:"Remove row",callback:function(a,b){var c=b.end.row-b.start.row+1;this.alter("remove_row",b.start.row,c)},disabled:function(){var a=this.getSelected(),b=[0,a[1],this.countRows()-1,a[1]],c=b.join(",")==a.join(",");return a[0]<0||c}},{key:"remove_col",name:"Remove column",callback:function(a,b){var c=b.end.col-b.start.col+1;this.alter("remove_col",b.start.col,c)},disabled:function(){var a=this.getSelected(),b=[a[0],0,a[0],this.countCols()-1],c=b.join(",")==a.join(",");return a[1]<0||c}},f.SEPARATOR,{key:"undo",name:"Undo",callback:function(){this.undo()},disabled:function(){return this.undoRedo&&!this.undoRedo.isUndoAvailable()}},{key:"redo",name:"Redo",callback:function(){this.redo()},disabled:function(){return this.undoRedo&&!this.undoRedo.isRedoAvailable()}},f.SEPARATOR,{key:"make_read_only",name:function(){var a="Read only",b=c.checkSelectionReadOnlyConsistency(this);return b&&(a=c.markSelected(a)),a},callback:function(){var a=c.checkSelectionReadOnlyConsistency(this),b=this;this.getSelectedRange().forAll(function(c,d){b.getCellMeta(c,d).readOnly=a?!1:!0}),this.render()}},f.SEPARATOR,{key:"alignment",name:"Alignment",submenu:{items:[{name:function(){var a="Left",b=c.checkSelectionAlignment(this,"htLeft");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"horizontal","htLeft")},disabled:!1},{name:function(){var a="Center",b=c.checkSelectionAlignment(this,"htCenter");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"horizontal","htCenter")},disabled:!1},{name:function(){var a="Right",b=c.checkSelectionAlignment(this,"htRight");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"horizontal","htRight")},disabled:!1},{name:function(){var a="Justify",b=c.checkSelectionAlignment(this,"htJustify");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"horizontal","htJustify")},disabled:!1},f.SEPARATOR,{name:function(){var a="Top",b=c.checkSelectionAlignment(this,"htTop");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"vertical","htTop")},disabled:!1},{name:function(){var a="Middle",b=c.checkSelectionAlignment(this,"htMiddle");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"vertical","htMiddle")},disabled:!1},{name:function(){var a="Bottom",b=c.checkSelectionAlignment(this,"htBottom");return b&&(a=c.markSelected(a)),a},callback:function(){e.call(this,this.getSelectedRange(),"vertical","htBottom")},disabled:!1}]}}]},c.options={},a.helper.extend(c.options,this.options),this.bindMouseEvents(),this.markSelected=function(a){return"<span class='selected'>✓</span>"+a},this.checkSelectionAlignment=function(a,b){var c=!1;return a.getSelectedRange().forAll(function(d,e){var f=a.getCellMeta(d,e).className;return f&&-1!=f.indexOf(b)?(c=!0,!1):void 0}),c},!this.instance.getSettings().allowInsertRow){var d=h(this.defaultOptions.items,"row_above");this.defaultOptions.items.splice(d,1);var g=h(this.defaultOptions.items,"row_above");this.defaultOptions.items.splice(g,1),this.defaultOptions.items.splice(g,1)}if(!this.instance.getSettings().allowInsertColumn){var i=h(this.defaultOptions.items,"col_left");this.defaultOptions.items.splice(i,1);var j=h(this.defaultOptions.items,"col_right");this.defaultOptions.items.splice(j,1),this.defaultOptions.items.splice(j,1)}var k,l,m=!1,n=!1;this.instance.getSettings().allowRemoveRow||(k=h(this.defaultOptions.items,"remove_row"),this.defaultOptions.items.splice(k,1),m=!0),this.instance.getSettings().allowRemoveColumn||(l=h(this.defaultOptions.items,"remove_col"),this.defaultOptions.items.splice(l,1),n=!0),m&&n&&this.defaultOptions.items.splice(l,1),this.checkSelectionReadOnlyConsistency=function(a){var b=!1;return a.getSelectedRange().forAll(function(c,d){return a.getCellMeta(c,d).readOnly?(b=!0,!1):void 0}),b},a.hooks.run(b,"afterContextMenuDefaultOptions",this.defaultOptions)}function g(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c].key===b)return a[c]}function h(a,b){for(var c=0,d=a.length;d>c;c++)if(a[c].key===b)return c}function i(){if(!this.rootElement.className.indexOf("htContextMenu")){for(var a=0,b=0,c=this.getSettings().data.length,d=0;c>d;d++)this.getSettings().data[d].name==f.SEPARATOR.name?a+=2:b+=26;this.view.wt.wtScrollbars.vertical.fixedContainer.style.height=b+a+"px"}}function j(){var b=this,c=b.getSettings().contextMenu,d=a.helper.isObject(c)?c:{};c?(b.contextMenu||(b.contextMenu=new f(b,d)),b.contextMenu.enable()):b.contextMenu&&(b.contextMenu.destroy(),delete b.contextMenu)}f.prototype.createMenu=function(b,c){b&&(b=b.replace(/ /g,"_"),b="htContextSubMenu_"+b);var d;return d=document.querySelector(b?".htContextMenu."+b:".htContextMenu"),d||(d=document.createElement("DIV"),a.Dom.addClass(d,"htContextMenu"),b&&a.Dom.addClass(d,b),document.getElementsByTagName("body")[0].appendChild(d)),this.menus.indexOf(d)<0&&(this.menus.push(d),c=c||0,this.triggerRows.push(c)),d},f.prototype.bindMouseEvents=function(){function b(b){var c=this.instance.getSettings();this.closeAll(),b.preventDefault(),a.helper.stopPropagation(b);var d=this.instance.getSettings().rowHeaders,e=this.instance.getSettings().colHeaders;if(d||e||"TD"==b.target.nodeName||a.Dom.hasClass(b.target,"current")&&a.Dom.hasClass(b.target,"wtBorder")){var g=this.createMenu(),h=this.getItems(c.contextMenu);this.show(g,h),this.setMenuPosition(b,g),this.eventManager.addEventListener(document.documentElement,"mousedown",a.helper.proxy(f.prototype.closeAll,this))}}var c=a.eventManager(this.instance);c.addEventListener(this.instance.rootElement,"contextmenu",a.helper.proxy(b,this))},f.prototype.bindTableEvents=function(){this._afterScrollCallback=function(){},this.instance.addHook("afterScrollVertically",this._afterScrollCallback),this.instance.addHook("afterScrollHorizontally",this._afterScrollCallback)},f.prototype.unbindTableEvents=function(){this._afterScrollCallback&&(this.instance.removeHook("afterScrollVertically",this._afterScrollCallback),this.instance.removeHook("afterScrollHorizontally",this._afterScrollCallback),this._afterScrollCallback=null)},f.prototype.performAction=function(a,b){var c=this,d=b.getSelected()[0],e=b.getData()[d];if(e.disabled!==!0&&("function"!=typeof e.disabled||e.disabled.call(this.instance)!==!0)&&!e.hasOwnProperty("submenu")){if("function"!=typeof e.callback)return;var g=this.instance.getSelectedRange(),h=f.utils.normalizeSelection(g);e.callback.call(this.instance,e.key,h,a),c.closeAll()}},f.prototype.unbindMouseEvents=function(){this.eventManager.clear();var b=a.eventManager(this.instance);b.removeEventListener(this.instance.rootElement,"contextmenu")},f.prototype.show=function(b,c){var d=this;b.removeAttribute("style"),b.style.display="block";var e={data:c,colHeaders:!1,colWidths:[200],readOnly:!0,copyPaste:!1,columns:[{data:"name",renderer:a.helper.proxy(this.renderer,this)}],renderAllRows:!0},f=new a(b,e);f.updateSettings({beforeKeyDown:function(a){d.onBeforeKeyDown(a,f)},afterOnCellMouseOver:function(a,b,c){d.onCellMouseOver(a,b,c,f)}}),this.eventManager.removeEventListener(b,"mousedown"),this.eventManager.addEventListener(b,"mousedown",function(a){d.performAction(a,f)}),this.bindTableEvents(),f.listen(),this.htMenus[f.guid]=f},f.prototype.close=function(a){this.hide(a),this.eventManager.clear(),this.unbindTableEvents(),this.instance.listen()},f.prototype.closeAll=function(){for(;this.menus.length>0;){var a=this.menus.pop();a&&this.close(a)}this.triggerRows=[]},f.prototype.closeLastOpenedSubMenu=function(){var a=this.menus.pop();a&&this.hide(a)},f.prototype.hide=function(a){a.style.display="none";var b=this.htMenus[a.id];b.destroy(),delete this.htMenus[a.id]},f.prototype.renderer=function(b,c,d,e,g,h){function i(a){return a.hasOwnProperty("submenu")}function j(a){return new RegExp(f.SEPARATOR.name,"i").test(a.name)}function k(a){return a.disabled===!0||"function"==typeof a.disabled&&a.disabled.call(l.instance)===!0}var l=this,m=b.getData()[d],n=document.createElement("DIV");"function"==typeof h&&(h=h.call(this.instance)),a.Dom.empty(c),c.appendChild(n),j(m)?a.Dom.addClass(c,"htSeparator"):a.Dom.fastInnerHTML(n,h),k(m)?(a.Dom.addClass(c,"htDisabled"),this.eventManager.addEventListener(n,"mouseenter",function(){b.deselectCell()})):i(m)?(a.Dom.addClass(c,"htSubmenu"),this.eventManager.addEventListener(n,"mouseenter",function(){b.selectCell(d,e)})):(a.Dom.removeClass(c,"htSubmenu"),a.Dom.removeClass(c,"htDisabled"),this.eventManager.addEventListener(n,"mouseenter",function(){b.selectCell(d,e)}))},f.prototype.onCellMouseOver=function(a,b,c,d){var e=this.menus.length;if(e>0){var f=this.menus[e-1];f.id!=d.guid&&this.closeLastOpenedSubMenu()}else this.closeLastOpenedSubMenu();if(-1!=c.className.indexOf("htSubmenu")){var g=d.getData()[b.row],h=this.getItems(g.submenu),i=this.createMenu(g.name,b.row),j=c.getBoundingClientRect();this.show(i,h),this.setSubMenuPosition(j,i)}},f.prototype.onBeforeKeyDown=function(b,c){function d(a){var b=a.getCell(0,0);f.utils.isSeparator(b)||f.utils.isDisabled(b)?g(0,0,a):a.selectCell(0,0)}function e(a){var b=a.countRows()-1,c=a.getCell(b,0);f.utils.isSeparator(c)||f.utils.isDisabled(c)?h(b,0,a):a.selectCell(b,0)}function g(a,b,c){var d=a+1,e=d<c.countRows()?c.getCell(d,b):null;e&&(f.utils.isSeparator(e)||f.utils.isDisabled(e)?g(d,b,c):c.selectCell(d,b))}function h(a,b,c){var d=a-1,e=d>=0?c.getCell(d,b):null;e&&(f.utils.isSeparator(e)||f.utils.isDisabled(e)?h(d,b,c):c.selectCell(d,b))}function i(a,b,c,d){var e=a.getData()[d],f=b.getItems(e.submenu),g=b.createMenu(e.name,d),h=c.getBoundingClientRect(),i=b.show(g,f);b.setSubMenuPosition(h,g),i.selectCell(0,0)}a.Dom.enableImmediatePropagation(b);var j=this,k=c.getSelected();switch(b.keyCode){case a.helper.keyCode.ESCAPE:j.closeAll(),b.preventDefault(),b.stopImmediatePropagation();break;case a.helper.keyCode.ENTER:k&&j.performAction(b,c);break;case a.helper.keyCode.ARROW_DOWN:k?g(k[0],k[1],c,j):d(c,j),b.preventDefault(),b.stopImmediatePropagation();break;case a.helper.keyCode.ARROW_UP:k?h(k[0],k[1],c,j):e(c,j),b.preventDefault(),b.stopImmediatePropagation();break;case a.helper.keyCode.ARROW_RIGHT:if(k){var l=k[0],m=c.getCell(k[0],0);f.utils.hasSubMenu(m)&&i(c,j,m,l)}b.preventDefault(),b.stopImmediatePropagation();break;case a.helper.keyCode.ARROW_LEFT:if(k){if(-1!=c.rootElement.className.indexOf("htContextSubMenu_")){j.closeLastOpenedSubMenu();var n=j.menus.length;if(n>0){var o=j.menus[n-1],p=j.triggerRows.pop();c=this.htMenus[o.id],c.selectCell(p,0)}}b.preventDefault(),b.stopImmediatePropagation()}}},f.prototype.getItems=function(b){function c(b){"string"==typeof b?this.name=b:a.helper.extend(this,b)}var d,e;c.prototype=b,b&&b.items&&(b=b.items),b===!0&&(b=this.defaultOptions.items),d=[];for(var f in b)b.hasOwnProperty(f)&&(e="string"==typeof b[f]?g(this.defaultOptions.items,b[f]):g(this.defaultOptions.items,f),e||(e=b[f]),e=new c(e),"object"==typeof b[f]&&a.helper.extend(e,b[f]),e.key||(e.key=f),d.push(e));return d},f.prototype.setSubMenuPosition=function(b,c){var d=a.Dom.getWindowScrollTop(),e=a.Dom.getWindowScrollLeft(),f={top:d+b.top,topRelative:b.top,left:b.left,leftRelative:b.left-e,scrollTop:d,scrollLeft:e,cellHeight:b.height,cellWidth:b.width};this.menuFitsBelowCursor(f,c)?this.positionMenuBelowCursor(f,c,!0):this.menuFitsAboveCursor(f,c)?this.positionMenuAboveCursor(f,c,!0):this.positionMenuBelowCursor(f,c,!0),this.menuFitsOnRightOfCursor(f,c)?this.positionMenuOnRightOfCursor(f,c,!0):this.positionMenuOnLeftOfCursor(f,c,!0)},f.prototype.setMenuPosition=function(b,c){var d=a.Dom.getWindowScrollTop(),e=a.Dom.getWindowScrollLeft(),f=b.pageY||b.clientY+d,g=b.pageX||b.clientX+e,h={top:f,topRelative:f-d,left:g,leftRelative:g-e,scrollTop:d,scrollLeft:e,cellHeight:b.target.clientHeight,cellWidth:b.target.clientWidth};this.menuFitsBelowCursor(h,c)?this.positionMenuBelowCursor(h,c):this.menuFitsAboveCursor(h,c)?this.positionMenuAboveCursor(h,c):this.positionMenuBelowCursor(h,c),this.menuFitsOnRightOfCursor(h,c)?this.positionMenuOnRightOfCursor(h,c):this.positionMenuOnLeftOfCursor(h,c)},f.prototype.menuFitsAboveCursor=function(a,b){return a.topRelative>=b.offsetHeight},f.prototype.menuFitsBelowCursor=function(a,b){return a.topRelative+b.offsetHeight<=a.scrollTop+document.body.clientHeight},f.prototype.menuFitsOnRightOfCursor=function(a,b){return a.leftRelative+b.offsetWidth<=a.scrollLeft+document.body.clientWidth},f.prototype.positionMenuBelowCursor=function(a,b){b.style.top=a.top+"px"},f.prototype.positionMenuAboveCursor=function(a,b,c){b.style.top=c?a.top+a.cellHeight-b.offsetHeight+"px":a.top-b.offsetHeight+"px"},f.prototype.positionMenuOnRightOfCursor=function(a,b,c){b.style.left=c?1+a.left+a.cellWidth+"px":1+a.left+"px"},f.prototype.positionMenuOnLeftOfCursor=function(a,b,c){b.style.left=c?a.left-b.offsetWidth+"px":a.left-b.offsetWidth+"px"},f.utils={},f.utils.normalizeSelection=function(a){return{start:a.getTopLeftCorner(),end:a.getBottomRightCorner()}},f.utils.isSeparator=function(b){return a.Dom.hasClass(b,"htSeparator")},f.utils.hasSubMenu=function(b){return a.Dom.hasClass(b,"htSubmenu")},f.utils.isDisabled=function(b){return a.Dom.hasClass(b,"htDisabled")},f.prototype.enable=function(){this.enabled||(this.enabled=!0,this.bindMouseEvents())},f.prototype.disable=function(){this.enabled&&(this.enabled=!1,this.closeAll(),this.unbindMouseEvents(),this.unbindTableEvents())},f.prototype.destroy=function(){for(this.closeAll();this.menus.length>0;){var a=this.menus.pop();this.triggerRows.pop(),a&&(this.close(a),this.isMenuEnabledByOtherHotInstance()||this.removeMenu(a))}this.unbindMouseEvents(),this.unbindTableEvents()},f.prototype.isMenuEnabledByOtherHotInstance=function(){for(var a=document.querySelectorAll(".handsontable"),b=!1,c=0,d=a.length;d>c;c++){var e=this.htMenus[a[c].id];if(e&&e.getSettings().contextMenu){b=!0;break}}return b},f.prototype.removeMenu=function(a){a.parentNode&&this.menu.parentNode.removeChild(a)},f.SEPARATOR={name:"---------"},a.hooks.add("afterInit",j),a.hooks.add("afterUpdateSettings",j),a.hooks.add("afterInit",i),a.PluginHooks.register("afterContextMenuDefaultOptions"),a.ContextMenu=f}(b);var L=function(){var a=this,c=a.getSettings().comments;c&&(b.Comments=new e(a),b.Comments.init())},M=function(a,c,d,e,f,g){g.comment&&b.Dom.addClass(a,g.commentedCellClassName)},N=function(a){var c=this;c.getSettings().comments&&(a.items.push(b.ContextMenu.SEPARATOR),a.items.push({key:"commentsAddEdit",name:function(){var a=b.Comments.checkSelectionCommentsConsistency();return a?"Edit Comment":"Add Comment"},callback:function(){b.Comments.showComment(this.getSelectedRange())},disabled:function(){return!1}}),a.items.push({key:"commentsRemove",name:function(){return"Delete Comment"},callback:function(a,c){b.Comments.removeComment(c.start.row,c.start.col)},disabled:function(){var a=b.Comments.checkSelectionCommentsConsistency();return!a}}))};b.hooks.add("beforeInit",L),b.hooks.add("afterContextMenuDefaultOptions",N),b.hooks.add("afterRenderer",M),function(b){function c(){function c(a){m=this,n=a;var b=this.view.wt.wtTable.getCoords(a).col;if(b>=0){l=b;var c=n.getBoundingClientRect();k=c.left,o.style.top=c.top+"px",o.style.left=k+"px",m.rootElement.appendChild(o)}}function d(a,b){var c=a.getBoundingClientRect(),d=6;o.style.left=b>0?c.left+c.width-d+"px":c.left+"px"}function e(){var a=this;b.Dom.addClass(o,"active"),b.Dom.addClass(p,"active");var c=n.getBoundingClientRect();p.style.width=c.width+"px",p.style.height=a.view.maximumVisibleElementHeight(0)+"px",p.style.top=o.style.top,p.style.left=k+"px",a.rootElement.appendChild(p)}function f(a){p.style.left=k+a+"px"}function g(){b.Dom.removeClass(o,"active"),b.Dom.removeClass(p,"active")}var h,i,j,k,l,m,n,o=document.createElement("DIV"),p=document.createElement("DIV"),q=b.eventManager(this);o.className="manualColumnMover",p.className="manualColumnMoverGuide";var r=function(){var a=this;b.hooks.run(a,"persistentStateSave","manualColumnPositions",a.manualColumnPositions)},s=function(){var a=this,c={};return b.hooks.run(a,"persistentStateLoad","manualColumnPositions",c),c.value},t=function(a){return"BODY"!=a.tagName?"THEAD"==a.parentNode.tagName?!0:(a=a.parentNode,t(a)):!1},u=function(a){return"TABLE"!=a.tagName?"TH"==a.tagName?a:u(a.parentNode):null},v=function(){var k,m=this;q.addEventListener(m.rootElement,"mouseover",function(a){if(t(a.target)){var b=u(a.target);if(b)if(k){var e=m.view.wt.wtTable.getCoords(b).col;e>=0&&(i=e,d(a.target,i-h))}else c.call(m,b)}}),q.addEventListener(m.rootElement,"mousedown",function(a){b.Dom.hasClass(a.target,"manualColumnMover")&&(j=b.helper.pageX(a),e.call(m),k=m,h=l,i=l)}),q.addEventListener(a,"mousemove",function(a){k&&f(b.helper.pageX(a)-j)}),q.addEventListener(a,"mouseup",function(){k&&(g(),k=!1,x(m.manualColumnPositions,m.countCols()),m.manualColumnPositions.splice(i,0,m.manualColumnPositions.splice(h,1)[0]),m.forceFullRender=!0,m.view.render(),r.call(m),b.hooks.run(m,"afterColumnMove",h,i),c.call(m,n))}),m.addHook("afterDestroy",w)},w=function(){q.clear()},x=function(a,b){if(a.length<b)for(var c=a.length;b>c;c++)a[c]=c};this.beforeInit=function(){this.manualColumnPositions=[]},this.init=function(a){var b=this,c=!!this.getSettings().manualColumnMove;if(c){var d=this.getSettings().manualColumnMove,e=s.call(b);this.manualColumnPositions="undefined"!=typeof e?e:d instanceof Array?d:[],"afterInit"==a&&(v.call(this),this.manualColumnPositions.length>0&&(this.forceFullRender=!0,this.render()))}else w.call(this),this.manualColumnPositions=[]},this.modifyCol=function(a){return this.getSettings().manualColumnMove?("undefined"==typeof this.manualColumnPositions[a]&&x(this.manualColumnPositions,a+1),this.manualColumnPositions[a]):a},this.afterRemoveCol=function(a,b){if(this.getSettings().manualColumnMove){var c,d=this.manualColumnPositions;c=d.splice(a,b),d=d.map(function(a){var b,d=a;for(b=0;b<c.length;b++)a>c[b]&&d--;return d}),this.manualColumnPositions=d}},this.afterCreateCol=function(a,b){if(this.getSettings().manualColumnMove){var c=this.manualColumnPositions;if(c.length){for(var d=[],e=0;b>e;e++)d.push(a+e);a>=c.length?c.concat(d):(c=c.map(function(c){return c>=a?c+b:c}),c.splice.apply(c,[a,0].concat(d))),this.manualColumnPositions=c}}}}var d=new c;b.hooks.add("beforeInit",d.beforeInit),b.hooks.add("afterInit",function(){d.init.call(this,"afterInit")}),b.hooks.add("afterUpdateSettings",function(){d.init.call(this,"afterUpdateSettings")}),b.hooks.add("modifyCol",d.modifyCol),b.hooks.add("afterRemoveCol",d.afterRemoveCol),b.hooks.add("afterCreateCol",d.afterCreateCol),b.hooks.register("afterColumnMove")}(b),function(b){function c(){function c(a){k=this,h=a;var b=this.view.wt.wtTable.getCoords(a).col;if(b>=0){i=b;var c=h.getBoundingClientRect();o=c.left-6,n=parseInt(c.width,10),p.style.top=c.top+"px",p.style.left=o+n+"px",k.rootElement.appendChild(p)}}function d(){p.style.left=o+j+"px"}function e(){var a=this;b.Dom.addClass(p,"active"),b.Dom.addClass(q,"active"),q.style.top=p.style.top,q.style.left=p.style.left,q.style.height=a.view.maximumVisibleElementHeight(0)+"px",a.rootElement.appendChild(q)}function f(){q.style.left=p.style.left}function g(){b.Dom.removeClass(p,"active"),b.Dom.removeClass(q,"active")}var h,i,j,k,l,m,n,o,p=document.createElement("DIV"),q=document.createElement("DIV"),r=b.eventManager(this);p.className="manualColumnResizer",q.className="manualColumnResizerGuide";var s=function(){var a=this;b.hooks.run(a,"persistentStateSave","manualColumnWidths",a.manualColumnWidths)},t=function(){var a=this,c={};return b.hooks.run(a,"persistentStateLoad","manualColumnWidths",c),c.value},u=function(a){return"BODY"!=a.tagName?"THEAD"==a.parentNode.tagName?!0:(a=a.parentNode,u(a)):!1},v=function(a){return"TABLE"!=a.tagName?"TH"==a.tagName?a:v(a.parentNode):null},w=function(){var k,o=this,p=0,q=null;r.addEventListener(o.rootElement,"mouseover",function(a){if(u(a.target)){var b=v(a.target);b&&(k||c.call(o,b))}}),r.addEventListener(o.rootElement,"mousedown",function(a){b.Dom.hasClass(a.target,"manualColumnResizer")&&(e.call(o),k=o,null==q&&(q=setTimeout(function(){p>=2&&(l=o.determineColumnWidth.call(o,i),y(i,l),o.forceFullRender=!0,o.view.render(),b.hooks.run(o,"afterColumnResize",i,l)),p=0,q=null},500),o._registerTimeout(q)),p++,m=b.helper.pageX(a),l=n)}),r.addEventListener(a,"mousemove",function(a){k&&(j=n+(b.helper.pageX(a)-m),l=y(i,j),d(),f())}),r.addEventListener(a,"mouseup",function(){k&&(g(),k=!1,l!=n&&(o.forceFullRender=!0,o.view.render(),s.call(o),b.hooks.run(o,"afterColumnResize",i,l)),c.call(o,h))}),o.addHook("afterDestroy",x)},x=function(){r.clear()};this.beforeInit=function(){this.manualColumnWidths=[]},this.init=function(a){var b=this,c=!!this.getSettings().manualColumnResize;if(c){var d=this.getSettings().manualColumnResize,e=t.call(b);this.manualColumnWidths="undefined"!=typeof e?e:d instanceof Array?d:[],"afterInit"==a&&(w.call(this),this.manualColumnWidths.length>0&&(this.forceFullRender=!0,this.render()))}else x.call(this),this.manualColumnWidths=[]};var y=function(a,c){return c=Math.max(c,20),a=b.hooks.execute(k,"modifyCol",a),k.manualColumnWidths[a]=c,c};this.modifyColWidth=function(a,b){return b=this.runHooksAndReturn("modifyCol",b),this.getSettings().manualColumnResize&&this.manualColumnWidths[b]?this.manualColumnWidths[b]:a}}var d=new c;b.hooks.add("beforeInit",d.beforeInit),b.hooks.add("afterInit",function(){d.init.call(this,"afterInit")}),b.hooks.add("afterUpdateSettings",function(){d.init.call(this,"afterUpdateSettings")}),b.hooks.add("modifyColWidth",d.modifyColWidth),b.hooks.register("afterColumnResize")}(b),function(b){function c(){function c(a){k=this,h=a;var b=this.view.wt.wtTable.getCoords(a).row;if(b>=0){i=b;var c=h.getBoundingClientRect();o=c.top-6,n=parseInt(c.height,10),p.style.left=c.left+"px",p.style.top=o+n+"px",k.rootElement.appendChild(p)}}function d(){p.style.top=o+j+"px"}function e(){var a=this;b.Dom.addClass(p,"active"),b.Dom.addClass(q,"active"),q.style.top=p.style.top,q.style.left=p.style.left,q.style.width=a.view.maximumVisibleElementWidth(0)+"px",a.rootElement.appendChild(q)}function f(){q.style.top=p.style.top}function g(){b.Dom.removeClass(p,"active"),b.Dom.removeClass(q,"active")}var h,i,j,k,l,m,n,o,p=document.createElement("DIV"),q=document.createElement("DIV"),r=b.eventManager(this);p.className="manualRowResizer",q.className="manualRowResizerGuide";var s=function(){var a=this;b.hooks.run(a,"persistentStateSave","manualRowHeights",a.manualRowHeights)},t=function(){var a=this,c={};return b.hooks.run(a,"persistentStateLoad","manualRowHeights",c),c.value},u=function(a){return"BODY"!=a.tagName?"TBODY"==a.parentNode.tagName?!0:(a=a.parentNode,u(a)):!1},v=function(a){return"TABLE"!=a.tagName?"TH"==a.tagName?a:v(a.parentNode):null},w=function(){var k,o=this,p=0,q=null;r.addEventListener(o.rootElement,"mouseover",function(a){if(u(a.target)){var b=v(a.target);b&&(k||c.call(o,b))}}),r.addEventListener(o.rootElement,"mousedown",function(a){b.Dom.hasClass(a.target,"manualRowResizer")&&(e.call(o),k=o,null==q&&(q=setTimeout(function(){p>=2&&(y(i,null),o.forceFullRender=!0,o.view.render(),b.hooks.run(o,"afterRowResize",i,l)),p=0,q=null},500),o._registerTimeout(q)),p++,m=b.helper.pageY(a),l=n)}),r.addEventListener(a,"mousemove",function(a){k&&(j=n+(b.helper.pageY(a)-m),l=y(i,j),d(),f())
}),r.addEventListener(a,"mouseup",function(){k&&(g(),k=!1,l!=n&&(o.forceFullRender=!0,o.view.render(),s.call(o),b.hooks.run(o,"afterRowResize",i,l)),c.call(o,h))}),o.addHook("afterDestroy",x)},x=function(){r.clear()};this.beforeInit=function(){this.manualRowHeights=[]},this.init=function(a){var b=this,c=!!this.getSettings().manualRowResize;if(c){var d=this.getSettings().manualRowResize,e=t.call(b);this.manualRowHeights="undefined"!=typeof e?e:d instanceof Array?d:[],"afterInit"===a?(w.call(this),this.manualRowHeights.length>0&&(this.forceFullRender=!0,this.render())):(this.forceFullRender=!0,this.render())}else x.call(this),this.manualRowHeights=[]};var y=function(a,c){return a=b.hooks.execute(k,"modifyRow",a),k.manualRowHeights[a]=c,c};this.modifyRowHeight=function(a,b){return this.getSettings().manualRowResize&&(b=this.runHooksAndReturn("modifyRow",b),void 0!==this.manualRowHeights[b])?this.manualRowHeights[b]:a}}var d=new c;b.hooks.add("beforeInit",d.beforeInit),b.hooks.add("afterInit",function(){d.init.call(this,"afterInit")}),b.hooks.add("afterUpdateSettings",function(){d.init.call(this,"afterUpdateSettings")}),b.hooks.add("modifyRowHeight",d.modifyRowHeight),b.hooks.register("afterRowResize")}(b),function(){function a(){var a=this,b=a.getSettings().observeChanges;b?(a.observer&&e.call(a),c.call(a),g.call(a)):b||e.call(a)}function c(){var a=this;a.observeChangesActive=!0,a.pauseObservingChanges=function(){a.observeChangesActive=!1},a.resumeObservingChanges=function(){a.observeChangesActive=!0},a.observedData=a.getData(),a.observer=J.observe(a.observedData,function(b){a.observeChangesActive&&(d.call(a,b),a.render()),a.runHooks("afterChangesObserved")})}function d(a){function b(a){var b;return b=d(a),b=c(b)}function c(a){var b=[];return a.filter(function(a){var c=e(a.path);if(-1!=["add","remove"].indexOf(a.op)&&!isNaN(c.col)){if(-1!=b.indexOf(c.col))return!1;b.push(c.col)}return!0})}function d(a){return a.filter(function(a){return!/[/]length/gi.test(a.path)})}function e(a){var b=a.match(/^\/(\d+)\/?(.*)?$/);return{row:parseInt(b[1],10),col:/^\d*$/.test(b[2])?parseInt(b[2],10):b[2]}}for(var f=this,g=b(a),h=0,i=g.length;i>h;h++){var j=g[h],k=e(j.path);switch(j.op){case"add":isNaN(k.col)?f.runHooks("afterCreateRow",k.row):f.runHooks("afterCreateCol",k.col);break;case"remove":isNaN(k.col)?f.runHooks("afterRemoveRow",k.row,1):f.runHooks("afterRemoveCol",k.col,1);break;case"replace":f.runHooks("afterChange",[k.row,k.col,null,j.value],"external")}}}function e(){var a=this;a.observer&&(f.call(a),h.call(a))}function f(){var a=this;J.unobserve(a.observedData,a.observer),delete a.observeChangesActive,delete a.pauseObservingChanges,delete a.resumeObservingChanges}function g(){var a=this;a.addHook("afterDestroy",e),a.addHook("afterCreateRow",i),a.addHook("afterRemoveRow",i),a.addHook("afterCreateCol",i),a.addHook("afterRemoveCol",i),a.addHook("afterChange",function(a,b){"loadData"!=b&&i.call(this)})}function h(){var a=this;a.removeHook("afterDestroy",e),a.removeHook("afterCreateRow",i),a.removeHook("afterRemoveRow",i),a.removeHook("afterCreateCol",i),a.removeHook("afterRemoveCol",i),a.removeHook("afterChange",i)}function i(){var a=this;a.pauseObservingChanges(),a.addHookOnce("afterChangesObserved",function(){a.resumeObservingChanges()})}b.hooks.add("afterLoadData",a),b.hooks.add("afterUpdateSettings",a),b.hooks.register("afterChangesObserved")}(),function(a){function c(){function c(){var a=this;for(var b in f)f.hasOwnProperty(b)&&a.addHook(b,f[b])}function d(){var a=this;for(var b in f)f.hasOwnProperty(b)&&a.removeHook(b,f[b])}var e=this;this.init=function(){var b=this,f=b.getSettings().persistentState;return e.enabled=!!f,e.enabled?(b.storage||(b.storage=new a(b.rootElement.id)),b.resetState=e.resetValue,void c.call(b)):void d.call(b)},this.saveValue=function(a,b){var c=this;c.storage.saveValue(a,b)},this.loadValue=function(a,b){var c=this;b.value=c.storage.loadValue(a)},this.resetValue=function(a){var b=this;"undefined"!=typeof a?b.storage.reset(a):b.storage.resetAll()};var f={persistentStateSave:e.saveValue,persistentStateLoad:e.loadValue,persistentStateReset:e.resetValue};for(var g in f)f.hasOwnProperty(g)&&b.hooks.register(g)}var d=new c;b.hooks.add("beforeInit",d.init),b.hooks.add("afterUpdateSettings",d.init)}(f),function(a){a.UndoRedo=function(b){var c=this;this.instance=b,this.doneActions=[],this.undoneActions=[],this.ignoreNewActions=!1,b.addHook("afterChange",function(b){if(b){var d=new a.UndoRedo.ChangeAction(b);c.done(d)}}),b.addHook("afterCreateRow",function(b,d,e){if(!e){var f=new a.UndoRedo.CreateRowAction(b,d);c.done(f)}}),b.addHook("beforeRemoveRow",function(b,d){var e=c.instance.getData();b=(e.length+b)%e.length;var f=e.slice(b,b+d),g=new a.UndoRedo.RemoveRowAction(b,f);c.done(g)}),b.addHook("afterCreateCol",function(b,d,e){if(!e){var f=new a.UndoRedo.CreateColumnAction(b,d);c.done(f)}}),b.addHook("beforeRemoveCol",function(d,e){var f=c.instance.getData();d=(c.instance.countCols()+d)%c.instance.countCols();for(var g=[],h=0,i=f.length;i>h;h++)g[h]=f[h].slice(d,d+e);var j;a.helper.isArray(b.getSettings().colHeaders)&&(j=b.getSettings().colHeaders.slice(d,d+g.length));var k=new a.UndoRedo.RemoveColumnAction(d,g,j);c.done(k)})},a.UndoRedo.prototype.done=function(a){this.ignoreNewActions||(this.doneActions.push(a),this.undoneActions.length=0)},a.UndoRedo.prototype.undo=function(){if(this.isUndoAvailable()){var a=this.doneActions.pop();this.ignoreNewActions=!0;var b=this;a.undo(this.instance,function(){b.ignoreNewActions=!1,b.undoneActions.push(a)})}},a.UndoRedo.prototype.redo=function(){if(this.isRedoAvailable()){var a=this.undoneActions.pop();this.ignoreNewActions=!0;var b=this;a.redo(this.instance,function(){b.ignoreNewActions=!1,b.doneActions.push(a)})}},a.UndoRedo.prototype.isUndoAvailable=function(){return this.doneActions.length>0},a.UndoRedo.prototype.isRedoAvailable=function(){return this.undoneActions.length>0},a.UndoRedo.prototype.clear=function(){this.doneActions.length=0,this.undoneActions.length=0},a.UndoRedo.Action=function(){},a.UndoRedo.Action.prototype.undo=function(){},a.UndoRedo.Action.prototype.redo=function(){},a.UndoRedo.ChangeAction=function(a){this.changes=a},a.helper.inherit(a.UndoRedo.ChangeAction,a.UndoRedo.Action),a.UndoRedo.ChangeAction.prototype.undo=function(b,c){for(var d=a.helper.deepClone(this.changes),e=b.countEmptyRows(!0),f=b.countEmptyCols(!0),g=0,h=d.length;h>g;g++)d[g].splice(3,1);b.addHookOnce("afterChange",c),b.setDataAtRowProp(d,null,null,"undo");for(var g=0,h=d.length;h>g;g++)b.getSettings().minSpareRows&&d[g][0]+1+b.getSettings().minSpareRows===b.countRows()&&e==b.getSettings().minSpareRows&&(b.alter("remove_row",parseInt(d[g][0]+1,10),b.getSettings().minSpareRows),b.undoRedo.doneActions.pop()),b.getSettings().minSpareCols&&d[g][1]+1+b.getSettings().minSpareCols===b.countCols()&&f==b.getSettings().minSpareCols&&(b.alter("remove_col",parseInt(d[g][1]+1,10),b.getSettings().minSpareCols),b.undoRedo.doneActions.pop())},a.UndoRedo.ChangeAction.prototype.redo=function(b,c){for(var d=a.helper.deepClone(this.changes),e=0,f=d.length;f>e;e++)d[e].splice(2,1);b.addHookOnce("afterChange",c),b.setDataAtRowProp(d,null,null,"redo")},a.UndoRedo.CreateRowAction=function(a,b){this.index=a,this.amount=b},a.helper.inherit(a.UndoRedo.CreateRowAction,a.UndoRedo.Action),a.UndoRedo.CreateRowAction.prototype.undo=function(a,b){a.addHookOnce("afterRemoveRow",b),a.alter("remove_row",this.index,this.amount)},a.UndoRedo.CreateRowAction.prototype.redo=function(a,b){a.addHookOnce("afterCreateRow",b),a.alter("insert_row",this.index+1,this.amount)},a.UndoRedo.RemoveRowAction=function(a,b){this.index=a,this.data=b},a.helper.inherit(a.UndoRedo.RemoveRowAction,a.UndoRedo.Action),a.UndoRedo.RemoveRowAction.prototype.undo=function(a,b){var c=[this.index,0];Array.prototype.push.apply(c,this.data),Array.prototype.splice.apply(a.getData(),c),a.addHookOnce("afterRender",b),a.render()},a.UndoRedo.RemoveRowAction.prototype.redo=function(a,b){a.addHookOnce("afterRemoveRow",b),a.alter("remove_row",this.index,this.data.length)},a.UndoRedo.CreateColumnAction=function(a,b){this.index=a,this.amount=b},a.helper.inherit(a.UndoRedo.CreateColumnAction,a.UndoRedo.Action),a.UndoRedo.CreateColumnAction.prototype.undo=function(a,b){a.addHookOnce("afterRemoveCol",b),a.alter("remove_col",this.index,this.amount)},a.UndoRedo.CreateColumnAction.prototype.redo=function(a,b){a.addHookOnce("afterCreateCol",b),a.alter("insert_col",this.index+1,this.amount)},a.UndoRedo.RemoveColumnAction=function(a,b,c){this.index=a,this.data=b,this.amount=this.data[0].length,this.headers=c},a.helper.inherit(a.UndoRedo.RemoveColumnAction,a.UndoRedo.Action),a.UndoRedo.RemoveColumnAction.prototype.undo=function(a,b){for(var c,d,e=0,f=a.getData().length;f>e;e++)c=a.getSourceDataAtRow(e),d=[this.index,0],Array.prototype.push.apply(d,this.data[e]),Array.prototype.splice.apply(c,d);"undefined"!=typeof this.headers&&(d=[this.index,0],Array.prototype.push.apply(d,this.headers),Array.prototype.splice.apply(a.getSettings().colHeaders,d)),a.addHookOnce("afterRender",b),a.render()},a.UndoRedo.RemoveColumnAction.prototype.redo=function(a,b){a.addHookOnce("afterRemoveCol",b),a.alter("remove_col",this.index,this.amount)}}(b),function(a){function b(){var b=this,g="undefined"==typeof b.getSettings().undo||b.getSettings().undo;g?b.undoRedo||(b.undoRedo=new a.UndoRedo(b),e(b),b.addHook("beforeKeyDown",c),b.addHook("afterChange",d)):b.undoRedo&&(delete b.undoRedo,f(b),b.removeHook("beforeKeyDown",c),b.removeHook("afterChange",d))}function c(a){var b=this,c=(a.ctrlKey||a.metaKey)&&!a.altKey;c&&(89===a.keyCode||a.shiftKey&&90===a.keyCode?(b.undoRedo.redo(),a.stopImmediatePropagation()):90===a.keyCode&&(b.undoRedo.undo(),a.stopImmediatePropagation()))}function d(a,b){var c=this;return"loadData"==b?c.undoRedo.clear():void 0}function e(a){a.undo=function(){return a.undoRedo.undo()},a.redo=function(){return a.undoRedo.redo()},a.isUndoAvailable=function(){return a.undoRedo.isUndoAvailable()},a.isRedoAvailable=function(){return a.undoRedo.isRedoAvailable()},a.clearUndo=function(){return a.undoRedo.clear()}}function f(a){delete a.undo,delete a.redo,delete a.isUndoAvailable,delete a.isRedoAvailable,delete a.clearUndo}a.hooks.add("afterInit",b),a.hooks.add("afterUpdateSettings",b)}(b),g.prototype.setBoundaries=function(a){this.boundaries=a},g.prototype.setCallback=function(a){this.callback=a},g.prototype.check=function(a,b){var c=0,d=0;b<this.boundaries.top?d=b-this.boundaries.top:b>this.boundaries.bottom&&(d=b-this.boundaries.bottom),a<this.boundaries.left?c=a-this.boundaries.left:a>this.boundaries.right&&(c=a-this.boundaries.right),this.callback(c,d)};var O,P;if("undefined"!=typeof b){var Q=function(b){b.dragToScrollListening=!1;var c=b.view.wt.wtScrollbars.vertical.scrollHandler;O=new g,c!==a&&(O.setBoundaries(c.getBoundingClientRect()),O.setCallback(function(a,b){0>a?c.scrollLeft-=50:a>0&&(c.scrollLeft+=50),0>b?c.scrollTop-=20:b>0&&(c.scrollTop+=20)}),b.dragToScrollListening=!0)};b.hooks.add("afterInit",function(){var a=this,c=b.eventManager(this);c.addEventListener(document,"mouseup",function(){a.dragToScrollListening=!1}),c.addEventListener(document,"mousemove",function(){a.dragToScrollListening&&O.check(event.clientX,event.clientY)})}),b.hooks.add("afterDestroy",function(){var a=b.eventManager(this);a.clear()}),b.hooks.add("afterOnCellMouseDown",function(){Q(this)}),b.hooks.add("afterOnCellCornerMouseDown",function(){Q(this)}),b.plugins.DragToScroll=g}if(function(a,b,c){function d(d){function e(){d.isListening()&&d.selection.empty()}function f(a){if(d.isListening()&&d.selection.isSelected()){var b=a.replace(/^[\r\n]*/g,"").replace(/[\r\n]*$/g,""),e=c.parse(b),f=d.getSelected(),g=new l(f[0],f[1]),h=new l(f[2],f[3]),i=new m(g,g,h),j=i.getTopLeftCorner(),k=i.getBottomRightCorner(),n=j,o=new l(Math.max(k.row,e.length-1+j.row),Math.max(k.col,e[0].length-1+j.col));d.addHookOnce("afterChange",function(a){a&&a.length&&this.selectCell(n.row,n.col,o.row,o.col)}),d.populateFromArray(n.row,n.col,e,o.row,o.col,"paste",d.getSettings().pasteMode)}}function g(b){if(d.getSelected()){if(a.helper.isCtrlKey(b.keyCode))return h.setCopyableText(),void b.stopImmediatePropagation();var c=(b.ctrlKey||b.metaKey)&&!b.altKey;b.keyCode==a.helper.keyCode.A&&c&&d._registerTimeout(setTimeout(a.helper.proxy(h.setCopyableText,h),0))}}this.copyPasteInstance=b.getInstance(),this.copyPasteInstance.onCut(e),this.copyPasteInstance.onPaste(f);var h=this;d.addHook("beforeKeyDown",g),this.destroy=function(){this.copyPasteInstance.removeCallback(e),this.copyPasteInstance.removeCallback(f),this.copyPasteInstance.destroy(),d.removeHook("beforeKeyDown",g)},d.addHook("afterDestroy",a.helper.proxy(this.destroy,this)),this.triggerPaste=a.helper.proxy(this.copyPasteInstance.triggerPaste,this.copyPasteInstance),this.triggerCut=a.helper.proxy(this.copyPasteInstance.triggerCut,this.copyPasteInstance),this.setCopyableText=function(){var b=d.getSettings(),c=b.copyRowsLimit,e=b.copyColsLimit,f=d.getSelectedRange(),g=f.getTopLeftCorner(),h=f.getBottomRightCorner(),i=g.row,j=g.col,k=h.row,l=h.col,m=Math.min(k,i+c-1),n=Math.min(l,j+e-1);d.copyPaste.copyPasteInstance.copyable(d.getCopyableData(i,j,m,n)),(k!==m||l!==n)&&a.hooks.run(d,"afterCopyLimit",k-i+1,l-j+1,c,e)}}function e(){var a=this,b=a.getSettings().copyPaste!==!1;b&&!a.copyPaste?a.copyPaste=new d(a):!b&&a.copyPaste&&(a.copyPaste.destroy(),delete a.copyPaste)}a.hooks.add("afterInit",e),a.hooks.add("afterUpdateSettings",e),a.hooks.register("afterCopyLimit")}(b,I,SheetClip),function(a){function b(){var b=this,c=!!b.getSettings().search;c?b.search=new a.Search(b):delete b.search}a.Search=function(b){this.query=function(c,d,e){var f=b.countRows(),g=b.countCols(),h=[];d||(d=a.Search.global.getDefaultCallback()),e||(e=a.Search.global.getDefaultQueryMethod());for(var i=0;f>i;i++)for(var j=0;g>j;j++){var k=b.getDataAtCell(i,j),l=b.getCellMeta(i,j),m=l.search.callback||d,n=l.search.queryMethod||e,o=n(c,k);if(o){var p={row:i,col:j,data:k};h.push(p)}m&&m(b,i,j,k,o)}return h}},a.Search.DEFAULT_CALLBACK=function(a,b,c,d,e){a.getCellMeta(b,c).isSearchResult=e},a.Search.DEFAULT_QUERY_METHOD=function(a,b){return"undefined"!=typeof a&&null!=a&&a.toLowerCase&&0!=a.length?"undefined"==typeof b||null==b?!1:-1!=b.toString().toLowerCase().indexOf(a.toLowerCase()):!1},a.Search.DEFAULT_SEARCH_RESULT_CLASS="htSearchResult",a.Search.global=function(){var b=a.Search.DEFAULT_CALLBACK,c=a.Search.DEFAULT_QUERY_METHOD,d=a.Search.DEFAULT_SEARCH_RESULT_CLASS;return{getDefaultCallback:function(){return b},setDefaultCallback:function(a){b=a},getDefaultQueryMethod:function(){return c},setDefaultQueryMethod:function(a){c=a},getDefaultSearchResultClass:function(){return d},setDefaultSearchResultClass:function(a){d=a}}}(),a.SearchCellDecorator=function(b,c,d,e,f,g,h){var i="object"==typeof h.search&&h.search.searchResultClass||a.Search.global.getDefaultSearchResultClass();h.isSearchResult?a.Dom.addClass(c,i):a.Dom.removeClass(c,i)};var c=a.renderers.cellDecorator;a.renderers.cellDecorator=function(){c.apply(this,arguments),a.SearchCellDecorator.apply(this,arguments)},a.hooks.add("afterInit",b),a.hooks.add("afterUpdateSettings",b)}(b),i.prototype.canMergeRange=function(a){return!a.isSingle()},i.prototype.mergeRange=function(a){if(this.canMergeRange(a)){var b=a.getTopLeftCorner(),c=a.getBottomRightCorner(),d={};d.row=b.row,d.col=b.col,d.rowspan=c.row-b.row+1,d.colspan=c.col-b.col+1,this.mergedCellInfoCollection.setInfo(d)}},i.prototype.mergeOrUnmergeSelection=function(a){var b=this.mergedCellInfoCollection.getInfo(a.from.row,a.from.col);b?this.unmergeSelection(a.from):this.mergeSelection(a)},i.prototype.mergeSelection=function(a){this.mergeRange(a)},i.prototype.unmergeSelection=function(a){var b=this.mergedCellInfoCollection.getInfo(a.row,a.col);this.mergedCellInfoCollection.removeInfo(b.row,b.col)},i.prototype.applySpanProperties=function(a,b,c){var d=this.mergedCellInfoCollection.getInfo(b,c);d?d.row===b&&d.col===c?(a.setAttribute("rowspan",d.rowspan),a.setAttribute("colspan",d.colspan)):a.style.display="none":(a.removeAttribute("rowspan"),a.removeAttribute("colspan"))},i.prototype.modifyTransform=function(a,b,c){var d=function(a,b){return b.row>=a.row&&b.row<=a.row+a.rowspan-1?!0:!1},e=function(a,b){return b.col>=a.col&&b.col<=a.col+a.colspan-1?!0:!1},f=function(a){return new l(b.to.row+a.row,b.to.col+a.col)},g={row:c.row,col:c.col};if("modifyTransformStart"==a){this.lastDesiredCoords||(this.lastDesiredCoords=new l(null,null));for(var h,i=new l(b.highlight.row,b.highlight.col),j=this.mergedCellInfoCollection.getInfo(i.row,i.col),k=0,n=this.mergedCellInfoCollection.length;n>k;k++){var o=this.mergedCellInfoCollection[k];if(o=new l(o.row+o.rowspan-1,o.col+o.colspan-1),b.includes(o)){h=!0;break}}if(j){var p=new l(j.row,j.col),q=new l(j.row+j.rowspan-1,j.col+j.colspan-1),r=new m(p,p,q);r.includes(this.lastDesiredCoords)||(this.lastDesiredCoords=new l(null,null)),g.row=this.lastDesiredCoords.row?this.lastDesiredCoords.row-i.row:g.row,g.col=this.lastDesiredCoords.col?this.lastDesiredCoords.col-i.col:g.col,c.row>0?g.row=j.row+j.rowspan-1-i.row+c.row:c.row<0&&(g.row=i.row-j.row+c.row),c.col>0?g.col=j.col+j.colspan-1-i.col+c.col:c.col<0&&(g.col=i.col-j.col+c.col)}var s=new l(b.highlight.row+g.row,b.highlight.col+g.col),t=this.mergedCellInfoCollection.getInfo(s.row,s.col);t&&(this.lastDesiredCoords=s,g={row:t.row-i.row,col:t.col-i.col})}else if("modifyTransformEnd"==a)for(var k=0,n=this.mergedCellInfoCollection.length;n>k;k++){var u=this.mergedCellInfoCollection[k],p=new l(u.row,u.col),q=new l(u.row+u.rowspan-1,u.col+u.colspan-1),v=new m(p,p,q),w=b.getBordersSharedWith(v);if(v.isEqual(b))b.setDirection("NW-SE");else if(w.length>0){var x=b.highlight.isEqual(v.from);w.indexOf("top")>-1?b.to.isSouthEastOf(v.from)&&x?b.setDirection("NW-SE"):b.to.isSouthWestOf(v.from)&&x&&b.setDirection("NE-SW"):w.indexOf("bottom")>-1&&(b.to.isNorthEastOf(v.from)&&x?b.setDirection("SW-NE"):b.to.isNorthWestOf(v.from)&&x&&b.setDirection("SE-NW"))}var s=f(g),y=d(u,s),z=e(u,s);b.includesRange(v)&&(v.includes(s)||y||z)&&(y&&(g.row<0?g.row-=u.rowspan-1:g.row>0&&(g.row+=u.rowspan-1)),z&&(g.col<0?g.col-=u.colspan-1:g.col>0&&(g.col+=u.colspan-1)))}0!=g.row&&(c.row=g.row),0!=g.col&&(c.col=g.col)},"undefined"==typeof b)throw new Error("Handsontable is not defined");var R=function(){var a=this,b=a.getSettings().mergeCells;b&&(a.mergeCells||(a.mergeCells=new i(b)))},S=function(){var a=this;a.mergeCells&&(a.view.wt.wtTable.getCell=function(b){if(a.getSettings().mergeCells){var c=a.mergeCells.mergedCellInfoCollection.getInfo(b.row,b.col);c&&(b=c)}return B.prototype.getCell.call(this,b)})},T=function(a){if(this.mergeCells){var b=(a.ctrlKey||a.metaKey)&&!a.altKey;b&&77===a.keyCode&&(this.mergeCells.mergeOrUnmergeSelection(this.getSelectedRange()),this.render(),a.stopImmediatePropagation())}},U=function(a){this.getSettings().mergeCells&&(a.items.push(b.ContextMenu.SEPARATOR),a.items.push({key:"mergeCells",name:function(){var a=this.getSelected(),b=this.mergeCells.mergedCellInfoCollection.getInfo(a[0],a[1]);return b?"Unmerge cells":"Merge cells"},callback:function(){this.mergeCells.mergeOrUnmergeSelection(this.getSelectedRange()),this.render()},disabled:function(){return!1}}))},M=function(a,b,c){this.mergeCells&&this.mergeCells.applySpanProperties(a,b,c)},V=function(a){return function(b){var c=this.getSettings().mergeCells;if(c){var d=this.getSelectedRange();if(this.mergeCells.modifyTransform(a,d,b),"modifyTransformEnd"===a){var e=this.countRows(),f=this.countCols();d.from.row<0?d.from.row=0:d.from.row>0&&d.from.row>=e&&(d.from.row=d.from-1),d.from.col<0?d.from.col=0:d.from.col>0&&d.from.col>=f&&(d.from.col=f-1)}}}},W=function(a){this.lastDesiredCoords=null;var b=this.getSettings().mergeCells;if(b){var c=this.getSelectedRange();c.highlight=new l(c.highlight.row,c.highlight.col),c.to=a;var d=!1;do{d=!1;for(var e=0,f=this.mergeCells.mergedCellInfoCollection.length;f>e;e++){var g=this.mergeCells.mergedCellInfoCollection[e],h=new l(g.row,g.col),i=new l(g.row+g.rowspan-1,g.col+g.colspan-1),j=new m(h,h,i);c.expandByRange(j)&&(a.row=c.to.row,a.col=c.to.col,d=!0)}}while(d)}},X=function(a,b){if(b&&"area"==b){var c=this.getSettings().mergeCells;if(c)for(var d=this.getSelectedRange(),e=new m(d.from,d.from,d.from),f=new m(d.to,d.to,d.to),g=0,h=this.mergeCells.mergedCellInfoCollection.length;h>g;g++){var i=this.mergeCells.mergedCellInfoCollection[g],j=new l(i.row,i.col),k=new l(i.row+i.rowspan-1,i.col+i.colspan-1),n=new m(j,j,k);e.expandByRange(n)&&(a[0]=e.from.row,a[1]=e.from.col),f.expandByRange(n)&&(a[2]=f.from.row,a[3]=f.from.col)}}},Y=function(a,b,c){var d=this.getSettings().mergeCells;if(d){var e=this.mergeCells.mergedCellInfoCollection.getInfo(a,b);!e||e.row==a&&e.col==b||(c.copyable=!1)}},Z=function(a){var b=this.getSettings().mergeCells;if(b)for(var c,d=this.countCols(),e=0;d>e;e++){if(c=this.mergeCells.mergedCellInfoCollection.getInfo(a.renderStartRow,e),c&&c.row<a.renderStartRow)return a.renderStartRow=c.row,Z.call(this,a);if(c=this.mergeCells.mergedCellInfoCollection.getInfo(a.renderEndRow,e)){var f=c.row+c.rowspan-1;if(f>a.renderEndRow)return a.renderEndRow=f,Z.call(this,a)}}},$=function(a){if(a&&this.mergeCells){var b=this.mergeCells.mergedCellInfoCollection,c=this.getSelectedRange();for(var d in b)if(c.highlight.row==b[d].row&&c.highlight.col==b[d].col&&c.to.row==b[d].row+b[d].rowspan-1&&c.to.col==b[d].col+b[d].colspan-1)return!1}return a};b.hooks.add("beforeInit",R),b.hooks.add("afterInit",S),b.hooks.add("beforeKeyDown",T),b.hooks.add("modifyTransformStart",V("modifyTransformStart")),b.hooks.add("modifyTransformEnd",V("modifyTransformEnd")),b.hooks.add("beforeSetRangeEnd",W),b.hooks.add("beforeDrawBorders",X),b.hooks.add("afterIsMultipleSelection",$),b.hooks.add("afterRenderer",M),b.hooks.add("afterContextMenuDefaultOptions",U),b.hooks.add("afterGetCellMeta",Y),b.hooks.add("afterViewportRowCalculatorOverride",Z),b.MergeCells=i,function(){function a(){}var c,d=function(a){return"boolean"==typeof a&&1==a?!0:"object"==typeof a&&a.length>0?!0:!1},e=function(){d(this.getSettings().customBorders)&&(this.customBorders||(c=this,this.customBorders=new a))},f=function(a){for(var b=0;b<c.view.wt.selections.length;b++)if(c.view.wt.selections[b].settings.className==a)return b;return-1},g=function(a){var b={row:a.row,col:a.col},d=new z(a,new m(b,b,b)),e=f(a.className);e>=0?c.view.wt.selections[e]=d:c.view.wt.selections.push(d)},h=function(a,b,c){var d=o(a,b);d=p(d,c),this.setCellMeta(a,b,"borders",d),g(d)},i=function(a){for(var b=a.range,c=b.from.row;c<=b.to.row;c++)for(var d=b.from.col;d<=b.to.col;d++){var e=o(c,d),f=0;c==b.from.row&&(f++,a.hasOwnProperty("top")&&(e.top=a.top)),c==b.to.row&&(f++,a.hasOwnProperty("bottom")&&(e.bottom=a.bottom)),d==b.from.col&&(f++,a.hasOwnProperty("left")&&(e.left=a.left)),d==b.to.col&&(f++,a.hasOwnProperty("right")&&(e.right=a.right)),f>0&&(this.setCellMeta(c,d,"borders",e),g(e))}},j=function(a,b){return"border_row"+a+"col"+b},k=function(){return{width:1,color:"#000"}},l=function(){return{hide:!0}},n=function(){return{width:1,color:"#000",cornerVisible:!1}},o=function(a,b){return{className:j(a,b),border:n(),row:a,col:b,top:l(),right:l(),bottom:l(),left:l()}},p=function(a,b){return b.hasOwnProperty("border")&&(a.border=b.border),b.hasOwnProperty("top")&&(a.top=b.top),b.hasOwnProperty("right")&&(a.right=b.right),b.hasOwnProperty("bottom")&&(a.bottom=b.bottom),b.hasOwnProperty("left")&&(a.left=b.left),a},q=function(a){for(var b=document.querySelectorAll("."+a),c=0;c<b.length;c++)if(b[c]&&"TD"!=b[c].nodeName){var d=b[c].parentNode;d.parentNode&&d.parentNode.removeChild(d)}},r=function(a,b){var c=j(a,b);q(c),this.removeCellMeta(a,b,"borders")},s=function(a,b,c,d){var e=this.getCellMeta(a,b).borders;e&&void 0!=e.border||(e=o(a,b)),e[c]=d?l():k(),this.setCellMeta(a,b,"borders",e);var f=j(a,b);q(f),g(e),this.render()},t=function(a,b,c){if(a.from.row==a.to.row&&a.from.col==a.to.col)"noBorders"==b?r.call(this,a.from.row,a.from.col):s.call(this,a.from.row,a.from.col,b,c);else switch(b){case"noBorders":for(var d=a.from.col;d<=a.to.col;d++)for(var e=a.from.row;e<=a.to.row;e++)r.call(this,e,d);break;case"top":for(var f=a.from.col;f<=a.to.col;f++)s.call(this,a.from.row,f,b,c);break;case"right":for(var g=a.from.row;g<=a.to.row;g++)s.call(this,g,a.to.col,b);break;case"bottom":for(var h=a.from.col;h<=a.to.col;h++)s.call(this,a.to.row,h,b);break;case"left":for(var i=a.from.row;i<=a.to.row;i++)s.call(this,i,a.from.col,b)}},u=function(a,b){var c=!1;return a.getSelectedRange().forAll(function(d,e){var f=a.getCellMeta(d,e).borders;if(f){if(!b)return c=!0,!1;if(!f[b].hasOwnProperty("hide"))return c=!0,!1}}),c},v=function(a){return"<span class='selected'>✓</span>"+a},w=function(a){this.getSettings().customBorders&&(a.items.push(b.ContextMenu.SEPARATOR),a.items.push({key:"borders",name:"Borders",submenu:{items:{top:{name:function(){var a="Top",b=u(this,"top");return b&&(a=v(a)),a},callback:function(){var a=u(this,"top");t.call(this,this.getSelectedRange(),"top",a)},disabled:!1},right:{name:function(){var a="Right",b=u(this,"right");return b&&(a=v(a)),a},callback:function(){var a=u(this,"right");t.call(this,this.getSelectedRange(),"right",a)},disabled:!1},bottom:{name:function(){var a="Bottom",b=u(this,"bottom");return b&&(a=v(a)),a},callback:function(){var a=u(this,"bottom");t.call(this,this.getSelectedRange(),"bottom",a)},disabled:!1},left:{name:function(){var a="Left",b=u(this,"left");return b&&(a=v(a)),a},callback:function(){var a=u(this,"left");t.call(this,this.getSelectedRange(),"left",a)},disabled:!1},remove:{name:"Remove border(s)",callback:function(){t.call(this,this.getSelectedRange(),"noBorders")},disabled:function(){return!u(this)}}}}}))};b.hooks.add("beforeInit",e),b.hooks.add("afterContextMenuDefaultOptions",w),b.hooks.add("afterInit",function(){var a=this.getSettings().customBorders;if(a){for(var b=0;b<a.length;b++)a[b].range?i.call(this,a[b]):h.call(this,a[b].row,a[b].col,a[b]);this.render(),this.view.wt.draw(!0)}}),b.CustomBorders=a}(),function(b){function c(){function c(a){P=this,m=a;var b=this.view.wt.wtTable.getCoords(a).row;if(b>=0){l=b;var c=m.getBoundingClientRect();k=c.top,n.style.top=k+"px",n.style.left=c.left+"px",P.rootElement.appendChild(n)}}function d(a,b){var c=a.getBoundingClientRect(),d=6;n.style.top=b>0?c.top+c.height-d+"px":c.top+"px"}function e(){var a=this;b.Dom.addClass(n,"active"),b.Dom.addClass(o,"active");var c=m.getBoundingClientRect();o.style.width=a.view.maximumVisibleElementWidth(0)+"px",o.style.height=c.height+"px",o.style.top=k+"px",o.style.left=n.style.left,a.rootElement.appendChild(o)}function f(a){o.style.top=k+a+"px"}function g(){b.Dom.removeClass(n,"active"),b.Dom.removeClass(o,"active")}var h,i,j,k,l,m,n=document.createElement("DIV"),o=document.createElement("DIV"),p=b.eventManager(this);n.className="manualRowMover",o.className="manualRowMoverGuide";var q=function(){var a=this;b.hooks.run(a,"persistentStateSave","manualRowPositions",a.manualRowPositions)},r=function(){var a=this,c={};return b.hooks.run(a,"persistentStateLoad","manualRowPositions",c),c.value},s=function(a){return"BODY"!=a.tagName?"TBODY"==a.parentNode.tagName?!0:(a=a.parentNode,s(a)):!1},t=function(a){return"TABLE"!=a.tagName?"TH"==a.tagName?a:t(a.parentNode):null},u=function(){var k,n=this;p.addEventListener(n.rootElement,"mouseover",function(a){if(s(a.target)){var b=t(a.target);b&&(k?(i=n.view.wt.wtTable.getCoords(b).row,d(b,i-h)):c.call(n,b))}}),p.addEventListener(n.rootElement,"mousedown",function(a){b.Dom.hasClass(a.target,"manualRowMover")&&(j=b.helper.pageY(a),e.call(n),k=n,h=l,i=l)}),p.addEventListener(a,"mousemove",function(a){k&&f(b.helper.pageY(a)-j)}),p.addEventListener(a,"mouseup",function(){k&&(g(),k=!1,w(n.manualRowPositions,n.countRows()),n.manualRowPositions.splice(i,0,n.manualRowPositions.splice(h,1)[0]),n.forceFullRender=!0,n.view.render(),q.call(n),b.hooks.run(n,"afterRowMove",h,i),c.call(n,m))}),n.addHook("afterDestroy",v)},v=function(){p.clear()},w=function(a,b){if(a.length<b)for(var c=a.length;b>c;c++)a[c]=c};this.beforeInit=function(){this.manualRowPositions=[]},this.init=function(a){var b=this,c=!!b.getSettings().manualRowMove;if(c){var d=b.getSettings().manualRowMove,e=r.call(b);this.manualRowPositions="undefined"!=typeof e?e:d instanceof Array?d:[],"afterInit"===a&&(u.call(this),this.manualRowPositions.length>0&&(b.forceFullRender=!0,b.render()))}else v.call(this),b.manualRowPositions=[]},this.modifyRow=function(a){var b=this;return b.getSettings().manualRowMove?("undefined"==typeof b.manualRowPositions[a]&&w(this.manualRowPositions,a+1),b.manualRowPositions[a]):a}}var d=new c;b.hooks.add("beforeInit",d.beforeInit),b.hooks.add("afterInit",function(){d.init.call(this,"afterInit")}),b.hooks.add("afterUpdateSettings",function(){d.init.call(this,"afterUpdateSettings")}),b.hooks.add("modifyRow",d.modifyRow),b.hooks.register("afterRowMove")}(b),function(b){function c(c){this.instance=c,this.addingStarted=!1;var d,e,f=!1,g=this,h=b.eventManager(c),i=function(){return c.autofill?void(c.autofill.handle&&c.autofill.handle.isDragged&&(c.autofill.handle.isDragged>1&&c.autofill.apply(),c.autofill.handle.isDragged=0,f=!1)):!0};h.addEventListener(document,"mouseup",function(a){i(a)}),h.addEventListener(document,"mousemove",function(c){if(!g.instance.autofill)return 0;var d=b.Dom.offset(g.instance.table).top-(a.pageYOffset||document.documentElement.scrollTop)+b.Dom.outerHeight(g.instance.table),e=b.Dom.offset(g.instance.table).left-(a.pageXOffset||document.documentElement.scrollLeft)+b.Dom.outerWidth(g.instance.table);g.addingStarted===!1&&g.instance.autofill.handle.isDragged>0&&c.clientY>d&&c.clientX<=e?(this.mouseDragOutside=!0,g.addingStarted=!0):this.mouseDragOutside=!1,this.mouseDragOutside&&setTimeout(function(){g.addingStarted=!1,g.instance.alter("insert_row")},200)}),d=this.instance.view.wt.wtSettings.settings.onCellCornerMouseDown,this.instance.view.wt.wtSettings.settings.onCellCornerMouseDown=function(a){c.autofill.handle.isDragged=1,f=!0,d(a)},e=this.instance.view.wt.wtSettings.settings.onCellMouseOver,this.instance.view.wt.wtSettings.settings.onCellMouseOver=function(a,b,d,g){c.autofill&&f&&!c.view.isMouseDown()&&c.autofill.handle&&c.autofill.handle.isDragged&&(c.autofill.handle.isDragged++,c.autofill.showBorder(b),c.autofill.checkIfNewRowNeeded()),e(a,b,d,g)},this.instance.view.wt.wtSettings.settings.onCellCornerDblClick=function(){c.autofill.selectAdjacent()}}c.prototype.init=function(){this.handle={}},c.prototype.disable=function(){this.handle.disabled=!0},c.prototype.selectAdjacent=function(){var a,b,c,d,e;a=this.instance.selection.isMultiple()?this.instance.view.wt.selections.area.getCorners():this.instance.view.wt.selections.current.getCorners(),b=this.instance.getData();a:for(c=a[2]+1;c<this.instance.countRows();c++){for(e=a[1];e<=a[3];e++)if(b[c][e])break a;(b[c][a[1]-1]||b[c][a[3]+1])&&(d=c)}d&&(this.instance.view.wt.selections.fill.clear(),this.instance.view.wt.selections.fill.add(new l(a[0],a[1])),this.instance.view.wt.selections.fill.add(new l(d,a[3])),this.apply())},c.prototype.apply=function(){var a,c,d,e,f;if(this.handle.isDragged=0,a=this.instance.view.wt.selections.fill.getCorners()){var g=function(a,b,c,d){var e,f,g,h=c.length,i=c?c[0].length:0,j=[],k=b.row-a.row,l=b.col-a.col,m=[];if(-1!==["down","up"].indexOf(d)){for(var n=0;l>=n;n++)e=parseInt(c[0][n],10),f=parseInt(c[h-1][n],10),g=("down"===d?f-e:e-f)/(h-1)||0,m.push(g);j.push(m)}if(-1!==["right","left"].indexOf(d))for(var o=0;k>=o;o++)e=parseInt(c[o][0],10),f=parseInt(c[o][i-1],10),g=("right"===d?f-e:e-f)/(i-1)||0,m=[],m.push(g),j.push(m);return j};this.instance.view.wt.selections.fill.clear(),c=this.instance.selection.isMultiple()?this.instance.view.wt.selections.area.getCorners():this.instance.view.wt.selections.current.getCorners();var h;if(a[0]===c[0]&&a[1]<c[1]?(h="left",d=new l(a[0],a[1]),e=new l(a[2],c[1]-1)):a[0]===c[0]&&a[3]>c[3]?(h="right",d=new l(a[0],c[3]+1),e=new l(a[2],a[3])):a[0]<c[0]&&a[1]===c[1]?(h="up",d=new l(a[0],a[1]),e=new l(c[0]-1,a[3])):a[2]>c[2]&&a[1]===c[1]&&(h="down",d=new l(c[2]+1,a[1]),e=new l(a[2],a[3])),d&&d.row>-1&&d.col>-1){var i={from:this.instance.getSelectedRange().from,to:this.instance.getSelectedRange().to};
f=this.instance.getData(i.from.row,i.from.col,i.to.row,i.to.col);var j=g(d,e,f,h);b.hooks.run(this.instance,"beforeAutofill",d,e,f),this.instance.populateFromArray(d.row,d.col,f,e.row,e.col,"autofill",null,h,j),this.instance.selection.setRangeStart(new l(a[0],a[1])),this.instance.selection.setRangeEnd(new l(a[2],a[3]))}else this.instance.selection.refreshBorders()}},c.prototype.showBorder=function(a){var b=this.instance.getSelectedRange().getTopLeftCorner(),c=this.instance.getSelectedRange().getBottomRightCorner();if("horizontal"!==this.instance.getSettings().fillHandle&&(c.row<a.row||b.row>a.row))a=new l(a.row,c.col);else{if("vertical"===this.instance.getSettings().fillHandle)return;a=new l(c.row,a.col)}this.instance.view.wt.selections.fill.clear(),this.instance.view.wt.selections.fill.add(this.instance.getSelectedRange().from),this.instance.view.wt.selections.fill.add(this.instance.getSelectedRange().to),this.instance.view.wt.selections.fill.add(a),this.instance.view.render()},c.prototype.checkIfNewRowNeeded=function(){var a,b,c=this.instance.countRows(),d=this;this.instance.view.wt.selections.fill.cellRange&&this.addingStarted===!1&&(b=this.instance.getSelected(),a=this.instance.view.wt.selections.fill.getCorners(),b[2]<c-1&&a[2]===c-1&&(this.addingStarted=!0,this.instance._registerTimeout(setTimeout(function(){d.instance.alter("insert_row"),d.addingStarted=!1},200))))},b.hooks.add("afterInit",function(){var a=new c(this);"undefined"!=typeof this.getSettings().fillHandle&&(a.handle&&this.getSettings().fillHandle===!1?a.disable():a.handle||this.getSettings().fillHandle===!1||(this.autofill=a,this.autofill.init()))}),b.Autofill=c}(b);var _=function(a){var c=[],d={rows:0,cols:0},e={rows:0,cols:0},f=[],g=[],h={groupIndicatorContainer:"htGroupIndicatorContainer",groupIndicator:function(a){return"ht"+a+"Group"},groupStart:"htGroupStart",collapseButton:"htCollapseButton",expandButton:"htExpandButton",collapseGroupId:function(a){return"htCollapse-"+a},collapseFromLevel:function(a,b){return"htCollapse"+a+"FromLevel-"+b},clickable:"clickable",levelTrigger:"htGroupLevelTrigger"},i=function(a,b){return function(c,d){return"undefined"==typeof b||"asc"===b?c[a]-d[a]:d[a]-c[a]}},j=function(a,b){for(var c=[];b>=a;)c.push(a++);return c},k=function(a,b,c){var d=[],e={row:null,col:null};if("cols"==a)for(;c>=b;)e={row:-1,col:b++},d.push(e);else for(;c>=b;)e={row:b++,col:-1},d.push(e);for(var f=m(d),g=0,h=0,i=0;i<f.length;i++)g+=f[i].filter(function(a){return a.rows}).length,h+=f[i].filter(function(a){return a.cols}).length;return{total:{rows:g,cols:h},groups:f}},m=function(a){for(var b=[],c=0;c<a.length;c++)b.push(n(a[c]));return b},n=function(a,b,d){for(var e=a.row,f=a.col,g=-1===e?0:e,h=-1===f?0:f,i=[],j=0;j<c.length;j++){var k=c[j],l=k.id,m=(k.level,k.rows||[]),n=k.cols||[];-1===i.indexOf(l)&&(-1!==m.indexOf(g)||-1!==n.indexOf(h))&&i.push(k)}-1===f?i=i.concat(r()):-1===e&&(i=i.concat(t())),b&&(i=i.filter(function(a){return a.level===b})),d&&("cols"===d?i=i.filter(function(a){return a.cols}):"rows"===d&&(i=i.filter(function(a){return a.rows})));var o=[];return i.filter(function(a){return-1===o.indexOf(a.id)?(o.push(a.id),a):void 0})},o=function(a){for(var b=0,d=c.length;d>b;b++)if(c[b].id==a)return c[b];return!1},p=function(a,b){for(var d=0,e=c.length;e>d;d++)if(c[d].level==b&&c[d].rows&&c[d].rows.indexOf(a)>-1)return c[d];return!1},q=function(a,b){for(var d=0,e=c.length;e>d;d++)if(c[d].level==b&&c[d].cols&&c[d].cols.indexOf(a)>-1)return c[d];return!1},r=function(){for(var a=[],b=0,d=c.length;d>b;b++)c[b].cols instanceof Array&&a.push(c[b]);return a},s=function(a){for(var b=[],d=0,e=c.length;e>d;d++)c[d].cols&&c[d].level===a&&b.push(c[d]);return b},t=function(){for(var a=[],b=0,d=c.length;d>b;b++)c[b].rows instanceof Array&&a.push(c[b]);return a},u=function(a){for(var b=[],d=0,e=c.length;e>d;d++)c[d].rows&&c[d].level===a&&b.push(c[d]);return b},v=function(a){var b=0;return a.length&&a.forEach(function(a){if(a=a.filter(function(a){return a.cols}),a.length){var c=a.sort(i("level","desc")),d=c[0].level;d>b&&(b=d)}}),b},w=function(a){var b=0;return a.length&&a.forEach(function(a){if(a=a.filter(function(a){return a.rows}),a.length){var c=a.sort(i("level","desc")),d=c[0].level;d>b&&(b=d)}}),b},x=function(a,b){var f=k("cols",a,b),g=v(f.groups);g===e.cols?e.cols++:g>e.cols&&(e.cols=g+1),d.cols||(d.cols=r().length),d.cols++,c.push({id:"c"+d.cols,level:g+1,cols:j(a,b),hidden:0})},y=function(a,b){var f=k("rows",a,b),g=w(f.groups);e.rows=Math.max(e.rows,g+1),d.rows||(d.rows=t().length),d.rows++,c.push({id:"r"+d.rows,level:g+1,rows:j(a,b),hidden:0})},z=function(a,b){for(var c,d=0,e=b.length;e>d;d++)if(b[d].hidden=a,c=b[d].level,f[c]||(f[c]=[]),g[c]||(g[c]=[]),b[d].rows)for(var h=0,i=b[d].rows.length;i>h;h++)f[c][b[d].rows[h]]=a>0?!0:void 0;else if(b[d].cols)for(var h=0,j=b[d].cols.length;j>h;h++)g[c][b[d].cols[h]]=a>0?!0:void 0},A=function(a,c,d,e){var f,g;switch(a){case"rows":f=p(c+1,d).id,g=b.Grouping.getGroupLevelsByRows();break;case"cols":f=q(c+1,d).id,g=b.Grouping.getGroupLevelsByCols()}return!!(g[c+1]&&g[c+1].indexOf(d)>-1&&e==f)},B=function(a,c,d,e){var f,g;switch(a){case"rows":f=p(c-1,d).id,g=b.Grouping.getGroupLevelsByRows();break;case"cols":f=q(c-1,d).id,g=b.Grouping.getGroupLevelsByCols()}return!!(g[c-1]&&g[c-1].indexOf(d)>-1&&e==f)},C=function(c,d,h,i){if(0===d)return!1;var j,k,l=B(c,d,h,i),m=A(c,d,h,i),n=!1;switch(c){case"rows":j=b.Grouping.getGroupLevelsByRows(),k=a.countRows();for(var o=0;o<=e.rows;o++)if(f[o]&&f[o][d+1]){n=!0;break}break;case"cols":j=b.Grouping.getGroupLevelsByCols(),k=a.countCols();for(var o=0;o<=e.cols;o++)if(g[o]&&g[o][d+1]){n=!0;break}}if(l){if(d==k-1)return!0;if(!m||m&&n)return!0;if(!j[d+1])return!0}return!1},D=function(b){var c;switch(b){case"rows":c=e.rows;for(var d=0;c>=d;d++)if(f[d]&&f[d][a.countRows()-1])return!0;break;case"cols":c=e.cols;for(var d=0;c>=d;d++)if(g[d]&&g[d][a.countCols()-1])return!0}return!1},E=function(c,d,h,i){var j,k,l,m=o(i),n=!1,p=function(a){for(var b=!1,c="rows"==a?f:g,h=0;h<=e[a];h++){for(l=d;m[a].indexOf(l)>-1;)b=!(!c[h]||!c[h][l]),l--;if(b)break}return b},q=B(c,d,h,i),r=A(c,d,h,i);switch(c){case"rows":j=b.Grouping.getGroupLevelsByRows(),k=a.countRows(),n=p(c);break;case"cols":j=b.Grouping.getGroupLevelsByCols(),k=a.countCols(),n=p(c)}if(d==k-1)return!1;if(0==d){if(r)return!0}else if(!q||q&&n){if(r)return!0}else if(!j[d-1]&&r)return!0;return!1},F=function(a,c,d,e,f){var g;switch(a){case"rows":g=p(c-1,d).id;break;case"cols":g=q(c-1,d).id}if(!g)return null;if(c>0&&B(a,c-1,d,g)&&g!=e){var i=document.createElement("DIV");return b.Dom.addClass(i,h.expandButton),i.id="htExpand-"+g,i.appendChild(document.createTextNode("+")),i.setAttribute("data-level",d),i.setAttribute("data-type",a),i.setAttribute("data-hidden","1"),f.appendChild(i),i}return null},G=function(a){for(var b=t(),c=r(),d=0,e=b.length;e>d;d++)if(b[d].rows.indexOf(a.row)>-1&&b[d].hidden)return!0;if(null===a.col)return!1;for(var d=0,f=c.length;f>d;d++)if(c[d].cols.indexOf(a.col)>-1&&c[d].hidden)return!0;return!1};return{getGroups:function(){return c},getLevels:function(){return e},instance:a,baseSpareRows:a.getSettings().minSpareRows,baseSpareCols:a.getSettings().minSpareCols,getRowGroups:t,getColGroups:r,init:function(){var c=a.getSettings().groups;c&&c instanceof Array&&b.Grouping.initGroups(c)},initGroups:function(a){c=[],a.forEach(function(a){var b=[],c=!1,d=!1;a.rows instanceof Array?(b=a.rows,c=!0):a.cols instanceof Array&&(b=a.cols,d=!0);var e=b[0],f=b[b.length-1];c?y(e,f):d&&x(e,f)})},resetGroups:function(){c=[],d={rows:0,cols:0},e={rows:0,cols:0};var a;for(var f in h)if("function"!=typeof h[f]){a=document.querySelectorAll("."+h[f]);for(var g=0,i=a.length;i>g;g++)b.Dom.removeClass(a[g],h[f])}for(var j=["htGroupColClosest","htGroupCol"],f=0,k=j.length;k>f;f++){a=document.querySelectorAll("."+j[f]);for(var g=0,i=a.length;i>g;g++)b.Dom.removeClass(a[g],j[f])}},updateGroups:function(){var a=this.getSettings().groups;b.Grouping.resetGroups(),b.Grouping.initGroups(a)},afterGetRowHeader:function(a,c){for(var d=!1,e=0,g=f.length;g>e;e++)f[e]&&f[e][a]===!0&&(d=!0);d?b.Dom.addClass(c.parentNode,"hidden"):!d&&b.Dom.hasClass(c.parentNode,"hidden")&&b.Dom.removeClass(c.parentNode,"hidden")},afterGetColHeader:function(c){var d=this.view.wt.wtSettings.getSetting("rowHeaders").length,e=a.rootElement.querySelectorAll("colgroup col:nth-child("+parseInt(c+d+1,10)+")");if(0!==e.length){for(var f=!1,h=0,i=g.length;i>h;h++)g[h]&&g[h][c]===!0&&(f=!0);if(f)for(var h=0,j=e.length;j>h;h++)b.Dom.addClass(e[h],"hidden");else if(!f&&b.Dom.hasClass(e[0],"hidden"))for(var h=0,j=e.length;j>h;h++)b.Dom.removeClass(e[h],"hidden")}},groupIndicatorsFactory:function(a,c){var f,g,i,j,k,l,m,n;switch(c){case"horizontal":f=b.Grouping.getGroupLevelsByCols(),g=function(a){return Array.prototype.indexOf.call(a.parentNode.parentNode.childNodes,a.parentNode)+1},i=function(a,b){return q(a,b).id},j="cols",k=function(a,b){return q(a-1,b)},l="columnHeaders",m=function(a){if(1===a.length){var c=a[0];a[0]=function(a,d,e){-1>a?r()(a,d,e):(b.Dom.removeClass(d,h.groupIndicatorContainer),c(a,d,e))}}return function(){return a}},n=!0;break;case"vertical":f=b.Grouping.getGroupLevelsByRows(),g=function(a){return b.Dom.index(a)+1},i=function(a,b){return p(a,b).id},j="rows",k=function(a,b){return p(a-1,b)},l="rowHeaders",m=function(a){return a}}var o=function(a){var c=document.createElement("div");return a.appendChild(c),{button:c,addClass:function(a){b.Dom.addClass(c,a)}}},r=function(){var a=c.charAt(0).toUpperCase()+c.slice(1);return function(c,d,e){e++;for(var g,l;g=d.lastChild;)d.removeChild(g);b.Dom.addClass(d,h.groupIndicatorContainer);var m=i(c,e);if(c>-1&&f[c]&&f[c].indexOf(e)>-1&&(l=o(d),l.addClass(h.groupIndicator(a)),E(j,c,e,m)&&l.addClass(h.groupStart),C(j,c,e,m)&&(l.button.appendChild(document.createTextNode("-")),l.addClass(h.collapseButton),l.button.id=h.collapseGroupId(m),l.button.setAttribute("data-level",e),l.button.setAttribute("data-type",j))),n){var p=b.Dom.index(d.parentNode);if(-1===c||-1>c&&p===b.Grouping.getLevels().cols+1||0==p&&0==b.Grouping.getLevels().cols)if(l=o(d),l.addClass(h.levelTrigger),-1===c)l.button.id=h.collapseFromLevel("Cols",e),l.button.appendChild(document.createTextNode(e));else if(-1>c&&p===b.Grouping.getLevels().cols+1||0==p&&0==b.Grouping.getLevels().cols){var q=b.Dom.index(d)+1;l.button.id=h.collapseFromLevel("Rows",q),l.button.appendChild(document.createTextNode(q))}}var r=F(j,c,e,m,d);if(c>0){var s=k(c-1,e);r&&s.hidden&&b.Dom.addClass(r,h.clickable)}ab()}};if(a=m(a),d[j]>0)for(var s=0;s<e[j]+1;s++)a instanceof Array||(a="function"==typeof a?a():new Array(a)),a.unshift(r())},getGroupLevelsByRows:function(){for(var a=t(),b=[],c=0,d=a.length;d>c;c++)if(a[c].rows)for(var e=0,f=a[c].rows.length;f>e;e++)b[a[c].rows[e]]||(b[a[c].rows[e]]=[]),b[a[c].rows[e]].push(a[c].level);return b},getGroupLevelsByCols:function(){for(var a=r(),b=[],c=0,d=a.length;d>c;c++)if(a[c].cols)for(var e=0,f=a[c].cols.length;f>e;e++)b[a[c].cols[e]]||(b[a[c].cols[e]]=[]),b[a[c].cols[e]].push(a[c].level);return b},toggleGroupVisibility:function(c){if(b.Dom.hasClass(c.target,h.expandButton)||b.Dom.hasClass(c.target,h.collapseButton)||b.Dom.hasClass(c.target,h.levelTrigger)){var d,f,g,i,j=c.target,k=j.id.split("-"),l=[],m=function(a){a&&(j=a),k=j.id.split("-"),d=k[1],f=parseInt(j.getAttribute("data-level"),10),g=j.getAttribute("data-type"),i=parseInt(j.getAttribute("data-hidden")),i=isNaN(i)?1:i?0:1,j.setAttribute("data-hidden",i.toString()),l.push(o(d))};if(j.className.indexOf(h.levelTrigger)>-1){for(var n,p=[],q=[],r=j.id.indexOf("Rows")>-1?"rows":"cols",t=1,v=e[r];v>=t;t++)if(n="rows"==r?u(t):s(t),t>=parseInt(k[1],10))for(var w=0,x=n.length;x>w;w++)q.push(n[w]);else for(var w=0,x=n.length;x>w;w++)p.push(n[w]);z(!0,q),z(!1,p)}else m(),z(i,l);g=g||r;var y=D(g),A=g.charAt(0).toUpperCase()+g.slice(1),B=b.Grouping["baseSpare"+A];y?0==B&&(a.alter("insert_"+g.slice(0,-1),a["count"+A]()),b.Grouping["dummy"+g.slice(0,-1)]=!0):0==B&&b.Grouping["dummy"+g.slice(0,-1)]&&(a.alter("remove_"+g.slice(0,-1),a["count"+A]()-1),b.Grouping["dummy"+g.slice(0,-1)]=!1),a.render(),c.stopImmediatePropagation()}},modifySelectionFactory:function(a){var b,c=this.instance,d=new l(0,0),e=function(a,b){var c=0;switch(a){case"down":for(;G(b);)c++,b.row+=1;break;case"up":for(;G(b);)c--,b.row-=1;break;case"right":for(;G(b);)c++,b.col+=1;break;case"left":for(;G(b);)c--,b.col-=1}return c},f=function(a,b){a.row>0?G(b)&&(a.row+=e("down",b)):a.row<0&&G(b)&&(a.row+=e("up",b)),a.col>0?G(b)&&(a.col+=e("right",b)):a.col<0&&G(b)&&(a.col+=e("left",b))};switch(a){case"start":return function(a){b=c.getSelected(),d.row=b[0]+a.row,d.col=b[1]+a.col,f(a,d)};case"end":return function(a){b=c.getSelected(),d.row=b[2]+a.row,d.col=b[3]+a.col,f(a,d)}}},modifyRowHeight:function(b,c){return a.view.wt.wtTable.rowFilter&&G({row:c,col:null})?0:void 0},validateGroups:function(){for(var b=function(a,b){return a[0]<b[0]&&a[1]<b[1]&&b[0]<=a[1]||a[0]>b[0]&&b[1]<a[1]&&a[0]<=b[1]?!0:void 0},c=a.getSettings().groups,d=[],e=[],f=0,g=c.length;g>f;f++)if(c[f].rows){if(1===c[f].rows.length)throw new Error("Grouping error:  Group {"+c[f].rows[0]+"} is invalid. Cannot define single-entry groups.");if(0===c[f].rows.length)throw new Error("Grouping error:  Cannot define empty groups.");e.push(c[f].rows);for(var h=0,i=e.length;i>h;h++)if(b(c[f].rows,e[h]))throw new Error("Grouping error:  ranges {"+c[f].rows[0]+", "+c[f].rows[1]+"} and {"+e[h][0]+", "+e[h][1]+"} are overlapping.")}else if(c[f].cols){if(1===c[f].cols.length)throw new Error("Grouping error:  Group {"+c[f].cols[0]+"} is invalid. Cannot define single-entry groups.");if(0===c[f].cols.length)throw new Error("Grouping error:  Cannot define empty groups.");d.push(c[f].cols);for(var h=0,j=d.length;j>h;h++)if(b(c[f].cols,d[h]))throw new Error("Grouping error:  ranges {"+c[f].cols[0]+", "+c[f].cols[1]+"} and {"+d[h][0]+", "+d[h][1]+"} are overlapping.")}return!0},afterGetRowHeaderRenderers:function(a){b.Grouping.groupIndicatorsFactory(a,"vertical")},afterGetColumnHeaderRenderers:function(a){b.Grouping.groupIndicatorsFactory(a,"horizontal")},hookProxy:function(c,d){return function(){return a.getSettings().groups?d?b.Grouping[c](d).apply(this,arguments):b.Grouping[c].apply(this,arguments):void 0}}}},L=function(){var a=this,c=!!a.getSettings().groups;if(c){var d={};b.Grouping=new _(a),a.getSettings().rowHeaders||(d.rowHeaders=!0),a.getSettings().colHeaders||(d.colHeaders=!0),(d.colHeaders||d.rowHeaders)&&a.updateSettings(d);var e=b.Grouping.validateGroups();if(!e)return;a.addHook("beforeInit",b.Grouping.hookProxy("init")),a.addHook("afterUpdateSettings",b.Grouping.hookProxy("updateGroups")),a.addHook("afterGetColumnHeaderRenderers",b.Grouping.hookProxy("afterGetColumnHeaderRenderers")),a.addHook("afterGetRowHeaderRenderers",b.Grouping.hookProxy("afterGetRowHeaderRenderers")),a.addHook("afterGetRowHeader",b.Grouping.hookProxy("afterGetRowHeader")),a.addHook("afterGetColHeader",b.Grouping.hookProxy("afterGetColHeader")),a.addHook("beforeOnCellMouseDown",b.Grouping.hookProxy("toggleGroupVisibility")),a.addHook("modifyTransformStart",b.Grouping.hookProxy("modifySelectionFactory","start")),a.addHook("modifyTransformEnd",b.Grouping.hookProxy("modifySelectionFactory","end")),a.addHook("modifyRowHeight",b.Grouping.hookProxy("modifyRowHeight"))}},ab=function(){for(var a=document.querySelectorAll("colgroup"),c=0,d=a.length;d>c;c++){var e=a[c].querySelectorAll("col.rowHeader");if(0==e.length)return;for(var f=0,g=e.length+1;g>f;f++){if(2==g)return;f<b.Grouping.getLevels().rows+1&&(f==b.Grouping.getLevels().rows?b.Dom.addClass(e[f],"htGroupColClosest"):b.Dom.addClass(e[f],"htGroupCol"))}}};b.hooks.add("beforeInit",L),b.hooks.add("afterUpdateSettings",function(){this.getSettings().groups&&!b.Grouping?L.call(this,arguments):!this.getSettings().groups&&b.Grouping&&(b.Grouping.resetGroups(),b.Grouping=void 0)}),b.plugins.Grouping=_,function(a){function b(){this.zeroClipboardInstance=null,this.instance=null}b.prototype.prepareZeroClipboard=function(){this.swfPath&&ZeroClipboard.config({swfPath:this.swfPath})},b.prototype.copy=function(){return this.instance.copyPaste.setCopyableText(),this.instance.copyPaste.copyPasteInstance.elTextarea.value},b.prototype.addToContextMenu=function(b){this.getSettings().contextMenuCopyPaste&&b.items.unshift({key:"copy",name:"Copy"},{key:"paste",name:"Paste",callback:function(){this.copyPaste.triggerPaste()}},a.ContextMenu.SEPARATOR)},b.prototype.setupZeroClipboard=function(b){var d=this;if(this.cmInstance=b,a.Dom.hasClass(this.cmInstance.rootElement,"htContextMenu"))for(var e=b.getData(),f=0,g=e.length;g>f;f++)if("copy"===e[f].key){this.zeroClipboardInstance=new ZeroClipboard(b.getCell(f,0)),this.zeroClipboardInstance.off(),this.zeroClipboardInstance.on("copy",function(a){var b=a.clipboardData;b.setData("text/plain",d.copy()),d.instance.getSettings().outsideClickDeselects=d.outsideClickDeselectsCache}),c.bindEvents();break}},b.prototype.bindEvents=function(){var b=this;if(b.cmInstance){var c=new a.eventManager(this.instance),d=function(){var c=b.cmInstance.rootElement.querySelector("td.current");c&&a.Dom.removeClass(c,"current"),b.outsideClickDeselectsCache=b.instance.getSettings().outsideClickDeselects,b.instance.getSettings().outsideClickDeselects=!1},e=function(){var c=b.cmInstance.rootElement.querySelector("td.zeroclipboard-is-hover");c&&a.Dom.removeClass(c,"zeroclipboard-is-hover"),b.instance.getSettings().outsideClickDeselects=b.outsideClickDeselectsCache};c.removeEventListener(document,"mouseenter",function(){d()}),c.addEventListener(document,"mouseenter",function(){d()}),c.removeEventListener(document,"mouseleave",function(){e()}),c.addEventListener(document,"mouseleave",function(){e()})}},b.prototype.init=function(){if(this.getSettings().contextMenuCopyPaste){if("object"==typeof this.getSettings().contextMenuCopyPaste&&(c.swfPath=this.getSettings().contextMenuCopyPaste.swfPath),"undefined"==typeof ZeroClipboard)throw new Error("To be able to use the Copy/Paste feature from the context menu, you need to manualy include ZeroClipboard.js file to your website.");try{{new ActiveXObject("ShockwaveFlash.ShockwaveFlash")}}catch(a){if("undefined"==typeof navigator.mimeTypes["application/x-shockwave-flash"])throw new Error("To be able to use the Copy/Paste feature from the context menu, your browser needs to have Flash Plugin installed.")}c.instance=this,c.prepareZeroClipboard()}};var c=new b;a.hooks.add("afterRender",function(){c.setupZeroClipboard(this)}),a.hooks.add("afterInit",c.init),a.hooks.add("afterContextMenuDefaultOptions",c.addToContextMenu),a.ContextMenuCopyPaste=b}(b),function(a){function b(b){this.instance=b,this.dragged=[],this.eventManager=a.eventManager(b),this.bindTouchEvents()}b.prototype.getCurrentRangeCoords=function(a,b,c,d,e){var f=a.getTopLeftCorner(),g=a.getBottomRightCorner(),h=a.getBottomLeftCorner(),i=a.getTopRightCorner(),j={start:null,end:null};switch(c){case"NE-SW":switch(d){case"NE-SW":case"NW-SE":j="topLeft"==e?{start:new l(b.row,a.highlight.col),end:new l(h.row,b.col)}:{start:new l(a.highlight.row,b.col),end:new l(b.row,f.col)};break;case"SE-NW":"bottomRight"==e&&(j={start:new l(g.row,b.col),end:new l(b.row,f.col)})}break;case"NW-SE":switch(d){case"NE-SW":"topLeft"==e?j={start:b,end:h}:j.end=b;break;case"NW-SE":"topLeft"==e?j={start:b,end:g}:j.end=b;break;case"SE-NW":"topLeft"==e?j={start:b,end:f}:j.end=b;break;case"SW-NE":"topLeft"==e?j={start:b,end:i}:j.end=b}break;case"SW-NE":switch(d){case"NW-SE":j="bottomRight"==e?{start:new l(b.row,f.col),end:new l(h.row,b.col)}:{start:new l(f.row,b.col),end:new l(b.row,g.col)};break;case"SW-NE":j="topLeft"==e?{start:new l(a.highlight.row,b.col),end:new l(b.row,g.col)}:{start:new l(b.row,f.col),end:new l(f.row,b.col)};break;case"SE-NW":"bottomRight"==e?j={start:new l(b.row,i.col),end:new l(f.row,b.col)}:"topLeft"==e&&(j={start:h,end:b})}break;case"SE-NW":switch(d){case"NW-SE":case"NE-SW":case"SW-NE":"topLeft"==e&&(j.end=b);break;case"SE-NW":"topLeft"==e?j.end=b:j={start:b,end:f}}}return j},b.prototype.bindTouchEvents=function(){var b=this,c=function(a){if(1==this.dragged.length)return this.dragged=[],!0;var b=this.dragged.indexOf(a);return-1==b?!1:void(0==b?this.dragged=this.dragged.slice(0,1):1==b&&(this.dragged=this.dragged.slice(-1)))};this.eventManager.addEventListener(this.instance.rootElement,"touchstart",function(c){if(a.Dom.hasClass(c.target,"topLeftSelectionHandle-HitArea")){b.dragged.push("topLeft");var d=b.instance.getSelectedRange();return b.touchStartRange={width:d.getWidth(),height:d.getHeight(),direction:d.getDirection()},c.preventDefault(),!1}if(a.Dom.hasClass(c.target,"bottomRightSelectionHandle-HitArea")){b.dragged.push("bottomRight");var d=b.instance.getSelectedRange();return b.touchStartRange={width:d.getWidth(),height:d.getHeight(),direction:d.getDirection()},c.preventDefault(),!1}}),this.eventManager.addEventListener(this.instance.rootElement,"touchend",function(d){return a.Dom.hasClass(d.target,"topLeftSelectionHandle-HitArea")?(c.call(b,"topLeft"),b.touchStartRange=void 0,d.preventDefault(),!1):a.Dom.hasClass(d.target,"bottomRightSelectionHandle-HitArea")?(c.call(b,"bottomRight"),b.touchStartRange=void 0,d.preventDefault(),!1):void 0}),this.eventManager.addEventListener(this.instance.rootElement,"touchmove",function(c){var d=a.Dom.getWindowScrollTop(),e=a.Dom.getWindowScrollLeft();if(b.dragged.length>0){var f=document.elementFromPoint(c.touches[0].screenX-e,c.touches[0].screenY-d);if(!f)return;if("TD"==f.nodeName||"TH"==f.nodeName){var g=b.instance.getCoords(f);-1==g.col&&(g.col=0);var h=b.instance.getSelectedRange(),i=h.getWidth(),j=h.getHeight(),k=h.getDirection();1==i&&1==j&&b.instance.selection.setRangeEnd(g);var l=b.getCurrentRangeCoords(h,g,b.touchStartRange.direction,k,b.dragged[0]);null!=l.start&&b.instance.selection.setRangeStart(l.start),b.instance.selection.setRangeEnd(l.end)}c.preventDefault()}})},b.prototype.isDragged=function(){return 0==this.dragged.length?!1:!0};var c=function(){var c=this;a.plugins.multipleSelectionHandles=new b(c)};a.hooks.add("afterInit",c)}(b);var bb=function(){function a(){}return a.prototype.init=function(a){this.instance=a,this.bindEvents(),this.scrollbars=[this.instance.view.wt.wtScrollbars.vertical,this.instance.view.wt.wtScrollbars.horizontal,this.instance.view.wt.wtScrollbars.corner],this.clones=[this.instance.view.wt.wtScrollbars.vertical.clone.wtTable.holder.parentNode,this.instance.view.wt.wtScrollbars.horizontal.clone.wtTable.holder.parentNode,this.instance.view.wt.wtScrollbars.corner.clone.wtTable.holder.parentNode]},a.prototype.bindEvents=function(){var a=this;this.instance.addHook("beforeTouchScroll",function(){b.freezeOverlays=!0;for(var c=0,d=a.clones.length;d>c;c++)b.Dom.addClass(a.clones[c],"hide-tween")}),this.instance.addHook("afterMomentumScroll",function(){b.freezeOverlays=!1;for(var c=0,d=a.clones.length;d>c;c++)b.Dom.removeClass(a.clones[c],"hide-tween");for(var c=0,d=a.clones.length;d>c;c++)b.Dom.addClass(a.clones[c],"show-tween");setTimeout(function(){for(var c=0,d=a.clones.length;d>c;c++)b.Dom.removeClass(a.clones[c],"show-tween")},400);for(var c=0,d=a.scrollbars.length;d>c;c++)a.scrollbars[c].refresh(),a.scrollbars[c].resetFixedPosition()})},a}(),cb=new bb;if(b.hooks.add("afterInit",function(){cb.init.call(cb,this)}),j.prototype.init=function(){this.TABLE=this.instance.wtTable.TABLE,this.fixed=this.instance.wtTable.hider,this.fixedContainer=this.instance.wtTable.holder,this.scrollHandler=this.getScrollableElement(this.TABLE)},j.prototype.makeClone=function(a){var b=document.createElement("DIV");b.className="ht_clone_"+a+" handsontable",b.style.position="absolute",b.style.top=0,b.style.left=0,b.style.overflow="hidden";var c=document.createElement("TABLE");return c.className=this.instance.wtTable.TABLE.className,b.appendChild(c),this.instance.wtTable.holder.parentNode.appendChild(b),new p({cloneSource:this.instance,cloneOverlay:this,table:c})},j.prototype.getScrollableElement=function(b){for(var c=b.parentNode;c&&c.style;){if("visible"!==c.style.overflow&&""!==c.style.overflow)return c;if(this instanceof w&&"visible"!==c.style.overflowX&&""!==c.style.overflowX)return c;c=c.parentNode}return a},j.prototype.refresh=function(a){this.clone&&this.clone.draw(a)},j.prototype.destroy=function(){var a=b.eventManager(this.clone);a.clear()},k.prototype.appear=function(a){var c,d,e,f,g,h,i,j,k,m,n,o;if(!this.disabled){var p,q,r,s,t,u,w,y=this.instance,z=function(){return!this.instance.selections.area.cellRange||r==this.instance.selections.area.cellRange.to.row&&s==this.instance.selections.area.cellRange.to.col?!1:!0},A=function(a,b,c,d){var e=parseInt(this.selectionHandles.styles.topLeft.width,10),f=parseInt(this.selectionHandles.styles.topLeftHitArea.width,10);this.selectionHandles.styles.topLeft.top=parseInt(a-e,10)+"px",this.selectionHandles.styles.topLeft.left=parseInt(b-e,10)+"px",this.selectionHandles.styles.topLeftHitArea.top=parseInt(a-f/4*3,10)+"px",this.selectionHandles.styles.topLeftHitArea.left=parseInt(b-f/4*3,10)+"px",this.selectionHandles.styles.bottomRight.top=parseInt(a+d,10)+"px",this.selectionHandles.styles.bottomRight.left=parseInt(b+c,10)+"px",this.selectionHandles.styles.bottomRightHitArea.top=parseInt(a+d-f/4,10)+"px",this.selectionHandles.styles.bottomRightHitArea.left=parseInt(b+c-f/4,10)+"px",this.settings.border.multipleSelectionHandlesVisible&&this.settings.border.multipleSelectionHandlesVisible()?(this.selectionHandles.styles.topLeft.display="block",this.selectionHandles.styles.topLeftHitArea.display="block",z.call(this)?(this.selectionHandles.styles.bottomRight.display="none",this.selectionHandles.styles.bottomRightHitArea.display="none"):(this.selectionHandles.styles.bottomRight.display="block",this.selectionHandles.styles.bottomRightHitArea.display="block")):(this.selectionHandles.styles.topLeft.display="none",this.selectionHandles.styles.bottomRight.display="none",this.selectionHandles.styles.topLeftHitArea.display="none",this.selectionHandles.styles.bottomRightHitArea.display="none"),p==this.instance.wtSettings.getSetting("fixedRowsTop")||q==this.instance.wtSettings.getSetting("fixedColumnsLeft")?(this.selectionHandles.styles.topLeft.zIndex="9999",this.selectionHandles.styles.topLeftHitArea.zIndex="9999"):(this.selectionHandles.styles.topLeft.zIndex="",this.selectionHandles.styles.topLeftHitArea.zIndex="")};for(u=y.cloneOverlay instanceof x||y.cloneOverlay instanceof v?y.getSetting("fixedRowsTop"):y.wtTable.getRenderedRowsCount(),t=0;u>t;t++)if(w=y.wtTable.rowFilter.renderedToSource(t),w>=a[0]&&w<=a[2]){p=w;break}for(t=u-1;t>=0;t--)if(w=y.wtTable.rowFilter.renderedToSource(t),w>=a[0]&&w<=a[2]){r=w;break}for(u=y.wtTable.getRenderedColumnsCount(),t=0;u>t;t++)if(w=y.wtTable.columnFilter.renderedToSource(t),w>=a[1]&&w<=a[3]){q=w;break}for(t=u-1;t>=0;t--)if(w=y.wtTable.columnFilter.renderedToSource(t),w>=a[1]&&w<=a[3]){s=w;break}if(void 0===p||void 0===q)return void this.disappear();c=p!==r||q!==s,d=y.wtTable.getCell(new l(p,q)),e=c?y.wtTable.getCell(new l(r,s)):d,f=b.Dom.offset(d),g=c?b.Dom.offset(e):f,h=b.Dom.offset(y.wtTable.TABLE),j=f.top,n=g.top+b.Dom.outerHeight(e)-j,m=f.left,o=g.left+b.Dom.outerWidth(e)-m,i=j-h.top-1,k=m-h.left-1;var B=b.Dom.getComputedStyle(d);parseInt(B.borderTopWidth,10)>0&&(i+=1,n=n>0?n-1:0),parseInt(B.borderLeftWidth,10)>0&&(k+=1,o=o>0?o-1:0),this.topStyle.top=i+"px",this.topStyle.left=k+"px",this.topStyle.width=o+"px",this.topStyle.display="block",this.leftStyle.top=i+"px",this.leftStyle.left=k+"px",this.leftStyle.height=n+"px",this.leftStyle.display="block";var C=Math.floor(this.settings.border.width/2);this.bottomStyle.top=i+n-C+"px",this.bottomStyle.left=k+"px",this.bottomStyle.width=o+"px",this.bottomStyle.display="block",this.rightStyle.top=i+"px",this.rightStyle.left=k+o-C+"px",this.rightStyle.height=n+1+"px",this.rightStyle.display="block",b.mobileBrowser||!this.hasSetting(this.settings.border.cornerVisible)||z.call(this)?this.cornerStyle.display="none":(this.cornerStyle.top=i+n-4+"px",this.cornerStyle.left=k+o-4+"px",this.cornerStyle.display="block"),b.mobileBrowser&&A.call(this,i,k,o,n)}},k.prototype.disappear=function(){this.topStyle.display="none",this.leftStyle.display="none",this.bottomStyle.display="none",this.rightStyle.display="none",this.cornerStyle.display="none",b.mobileBrowser&&(this.selectionHandles.styles.topLeft.display="none",this.selectionHandles.styles.bottomRight.display="none")},k.prototype.hasSetting=function(a){return"function"==typeof a?a():!!a},l.prototype.isValid=function(a){return this.row<0||this.col<0?!1:this.row>=a.getSetting("totalRows")||this.col>=a.getSetting("totalColumns")?!1:!0},l.prototype.isEqual=function(a){return a===this?!0:this.row===a.row&&this.col===a.col},l.prototype.isSouthEastOf=function(a){return this.row>=a.row&&this.col>=a.col},l.prototype.isNorthWestOf=function(a){return this.row<=a.row&&this.col<=a.col},l.prototype.isSouthWestOf=function(a){return this.row>=a.row&&this.col<=a.col},l.prototype.isNorthEastOf=function(a){return this.row<=a.row&&this.col>=a.col},a.WalkontableCellCoords=l,m.prototype.isValid=function(a){return this.from.isValid(a)&&this.to.isValid(a)},m.prototype.isSingle=function(){return this.from.row===this.to.row&&this.from.col===this.to.col},m.prototype.getHeight=function(){return Math.max(this.from.row,this.to.row)-Math.min(this.from.row,this.to.row)+1},m.prototype.getWidth=function(){return Math.max(this.from.col,this.to.col)-Math.min(this.from.col,this.to.col)+1},m.prototype.includes=function(a){var b=this.getTopLeftCorner(),c=this.getBottomRightCorner();return a.row<0&&(a.row=0),a.col<0&&(a.col=0),b.row<=a.row&&c.row>=a.row&&b.col<=a.col&&c.col>=a.col},m.prototype.includesRange=function(a){return this.includes(a.getTopLeftCorner())&&this.includes(a.getBottomRightCorner())},m.prototype.isEqual=function(a){return Math.min(this.from.row,this.to.row)==Math.min(a.from.row,a.to.row)&&Math.max(this.from.row,this.to.row)==Math.max(a.from.row,a.to.row)&&Math.min(this.from.col,this.to.col)==Math.min(a.from.col,a.to.col)&&Math.max(this.from.col,this.to.col)==Math.max(a.from.col,a.to.col)},m.prototype.overlaps=function(a){return a.isSouthEastOf(this.getTopLeftCorner())&&a.isNorthWestOf(this.getBottomRightCorner())},m.prototype.isSouthEastOf=function(a){return this.getTopLeftCorner().isSouthEastOf(a)||this.getBottomRightCorner().isSouthEastOf(a)},m.prototype.isNorthWestOf=function(a){return this.getTopLeftCorner().isNorthWestOf(a)||this.getBottomRightCorner().isNorthWestOf(a)},m.prototype.expand=function(a){var b=this.getTopLeftCorner(),c=this.getBottomRightCorner();return a.row<b.row||a.col<b.col||a.row>c.row||a.col>c.col?(this.from=new l(Math.min(b.row,a.row),Math.min(b.col,a.col)),this.to=new l(Math.max(c.row,a.row),Math.max(c.col,a.col)),!0):!1},m.prototype.expandByRange=function(a){if(this.includesRange(a)||!this.overlaps(a))return!1;var b=this.getTopLeftCorner(),c=this.getBottomRightCorner(),d=(this.getTopRightCorner(),this.getBottomLeftCorner(),a.getTopLeftCorner()),e=a.getBottomRightCorner(),f=Math.min(b.row,d.row),g=Math.min(b.col,d.col),h=Math.max(c.row,e.row),i=Math.max(c.col,e.col),j=new l(f,g),k=new l(h,i),n=new m(j,j,k).isCorner(this.from,a),o=a.isEqual(new m(j,j,k));return n&&!o&&(this.from.col>j.col&&(j.col=i,k.col=g),this.from.row>j.row&&(j.row=h,k.row=f)),this.from=j,this.to=k,!0},m.prototype.getDirection=function(){return this.from.isNorthWestOf(this.to)?"NW-SE":this.from.isNorthEastOf(this.to)?"NE-SW":this.from.isSouthEastOf(this.to)?"SE-NW":this.from.isSouthWestOf(this.to)?"SW-NE":void 0},m.prototype.setDirection=function(a){switch(a){case"NW-SE":this.from=this.getTopLeftCorner(),this.to=this.getBottomRightCorner();break;case"NE-SW":this.from=this.getTopRightCorner(),this.to=this.getBottomLeftCorner();break;case"SE-NW":this.from=this.getBottomRightCorner(),this.to=this.getTopLeftCorner();break;case"SW-NE":this.from=this.getBottomLeftCorner(),this.to=this.getTopRightCorner()
}},m.prototype.getTopLeftCorner=function(){return new l(Math.min(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))},m.prototype.getBottomRightCorner=function(){return new l(Math.max(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))},m.prototype.getTopRightCorner=function(){return new l(Math.min(this.from.row,this.to.row),Math.max(this.from.col,this.to.col))},m.prototype.getBottomLeftCorner=function(){return new l(Math.max(this.from.row,this.to.row),Math.min(this.from.col,this.to.col))},m.prototype.isCorner=function(a,b){return b&&b.includes(a)&&(this.getTopLeftCorner().isEqual(new l(b.from.row,b.from.col))||this.getTopRightCorner().isEqual(new l(b.from.row,b.to.col))||this.getBottomLeftCorner().isEqual(new l(b.to.row,b.from.col))||this.getBottomRightCorner().isEqual(new l(b.to.row,b.to.col)))?!0:a.isEqual(this.getTopLeftCorner())||a.isEqual(this.getTopRightCorner())||a.isEqual(this.getBottomLeftCorner())||a.isEqual(this.getBottomRightCorner())},m.prototype.getOppositeCorner=function(a,b){if(!(a instanceof l))return!1;if(b&&b.includes(a)){if(this.getTopLeftCorner().isEqual(new l(b.from.row,b.from.col)))return this.getBottomRightCorner();if(this.getTopRightCorner().isEqual(new l(b.from.row,b.to.col)))return this.getBottomLeftCorner();if(this.getBottomLeftCorner().isEqual(new l(b.to.row,b.from.col)))return this.getTopRightCorner();if(this.getBottomRightCorner().isEqual(new l(b.to.row,b.to.col)))return this.getTopLeftCorner()}return a.isEqual(this.getBottomRightCorner())?this.getTopLeftCorner():a.isEqual(this.getTopLeftCorner())?this.getBottomRightCorner():a.isEqual(this.getTopRightCorner())?this.getBottomLeftCorner():a.isEqual(this.getBottomLeftCorner())?this.getTopRightCorner():void 0},m.prototype.getBordersSharedWith=function(a){if(!this.includesRange(a))return[];var b={top:Math.min(this.from.row,this.to.row),bottom:Math.max(this.from.row,this.to.row),left:Math.min(this.from.col,this.to.col),right:Math.max(this.from.col,this.to.col)},c={top:Math.min(a.from.row,a.to.row),bottom:Math.max(a.from.row,a.to.row),left:Math.min(a.from.col,a.to.col),right:Math.max(a.from.col,a.to.col)},d=[];return b.top==c.top&&d.push("top"),b.right==c.right&&d.push("right"),b.bottom==c.bottom&&d.push("bottom"),b.left==c.left&&d.push("left"),d},m.prototype.getInner=function(){for(var a=this.getTopLeftCorner(),b=this.getBottomRightCorner(),c=[],d=a.row;d<=b.row;d++)for(var e=a.col;e<=b.col;e++)this.from.row===d&&this.from.col===e||this.to.row===d&&this.to.col===e||c.push(new l(d,e));return c},m.prototype.getAll=function(){for(var a=this.getTopLeftCorner(),b=this.getBottomRightCorner(),c=[],d=a.row;d<=b.row;d++)for(var e=a.col;e<=b.col;e++)c.push(a.row===d&&a.col===e?a:b.row===d&&b.col===e?b:new l(d,e));return c},m.prototype.forAll=function(a){for(var b=this.getTopLeftCorner(),c=this.getBottomRightCorner(),d=b.row;d<=c.row;d++)for(var e=b.col;e<=c.col;e++){var f=a(d,e);if(f===!1)return}},a.WalkontableCellRange=m,n.prototype.renderedToSource=function(a){return a},n.prototype.sourceToRendered=function(a){return a},n.prototype.offsettedTH=function(a){return a-this.countTH},n.prototype.unOffsettedTH=function(a){return a+this.countTH},n.prototype.visibleRowHeadedColumnToSourceColumn=function(a){return this.renderedToSource(this.offsettedTH(a))},n.prototype.sourceColumnToVisibleRowHeadedColumn=function(a){return this.unOffsettedTH(this.sourceToRendered(a))},o.prototype.getContainerSize=function(){return"function"==typeof this.containerSizeFn?this.containerSizeFn():this.containerSizeFn},o.prototype.getSize=function(a){return this.cellSizes[a]+(this.cellStretch[a]||0)},o.prototype.stretch=function(){var a=this.getContainerSize(),b=0;if(this.remainingSize=this.cellSizesSum-a,this.cellStretch.length=0,"all"===this.strategy){if(this.remainingSize<0){for(var c,d=a/this.cellSizesSum;b<this.cellCount-1;)c=Math.floor(d*this.cellSizes[b]),this.remainingSize+=c-this.cellSizes[b],this.cellStretch[b]=c-this.cellSizes[b],b++;this.cellStretch[this.cellCount-1]=-this.remainingSize,this.remainingSize=0}}else"last"===this.strategy&&this.remainingSize<0&&1/0!==a&&(this.cellStretch[this.cellCount-1]=-this.remainingSize,this.remainingSize=0)},o.prototype.countVisible=function(){return this.visibleCellCount},o.prototype.isLastIncomplete=function(){var a=this.instance.wtTable.getFirstVisibleRow(),c=this.instance.wtTable.getLastVisibleColumn(),d=this.instance.wtTable.getCell(new l(a,c)),e=b.Dom.offset(d),f=b.Dom.outerWidth(d),g=e.left+f,h=this.instance.wtScrollbars.vertical.getScrollPosition(),i=this.instance.wtViewport.getViewportWidth(),j=h+i;return j>=g},p.prototype.draw=function(a){return this.drawInterrupted=!1,a||b.Dom.isVisible(this.wtTable.TABLE)?(this.wtTable.draw(a),this):void(this.drawInterrupted=!0)},p.prototype.getCell=function(a,b){if(b){var c=this.wtSettings.getSetting("fixedRowsTop"),d=this.wtSettings.getSetting("fixedColumnsLeft");return a.row<c&&a.col<d?this.wtScrollbars.corner.clone.wtTable.getCell(a):a.row<c?this.wtScrollbars.vertical.clone.wtTable.getCell(a):a.col<d?this.wtScrollbars.horizontal.clone.wtTable.getCell(a):this.wtTable.getCell(a)}return this.wtTable.getCell(a)},p.prototype.update=function(a,b){return this.wtSettings.update(a,b)},p.prototype.scrollVertical=function(a){return this.wtScrollbars.vertical.scrollTo(a),this.getSetting("onScrollVertically"),this},p.prototype.scrollHorizontal=function(a){return this.wtScrollbars.horizontal.scrollTo(a),this.getSetting("onScrollHorizontally"),this},p.prototype.scrollViewport=function(a){return this.wtScroll.scrollViewport(a),this},p.prototype.getViewport=function(){return[this.wtTable.getFirstVisibleRow(),this.wtTable.getFirstVisibleColumn(),this.wtTable.getLastVisibleRow(),this.wtTable.getLastVisibleColumn()]},p.prototype.getSetting=function(a,b,c,d,e){return this.wtSettings.getSetting(a,b,c,d,e)},p.prototype.hasSetting=function(a){return this.wtSettings.has(a)},p.prototype.destroy=function(){this.wtScrollbars.destroy(),this.wtEvent&&this.wtEvent.destroy()},q.prototype=new j,q.prototype.destroy=function(){j.prototype.destroy.call(this),clearTimeout(this.lastTimeout)},r.prototype.parentCell=function(a){var c={},d=this.instance.wtTable.TABLE,e=b.Dom.closest(a,["TD","TH"],d);return e&&b.Dom.isChildOf(e,d)?(c.coords=this.instance.wtTable.getCoords(e),c.TD=e):b.Dom.hasClass(a,"wtBorder")&&b.Dom.hasClass(a,"current")?(c.coords=this.instance.selections.current.cellRange.highlight,c.TD=this.instance.wtTable.getCell(c.coords)):b.Dom.hasClass(a,"wtBorder")&&b.Dom.hasClass(a,"area")&&this.instance.selections.area.cellRange&&(c.coords=this.instance.selections.area.cellRange.to,c.TD=this.instance.wtTable.getCell(c.coords)),c},a.requestAnimFrame=function(){return a.requestAnimationFrame||a.webkitRequestAnimationFrame||a.mozRequestAnimationFrame||a.oRequestAnimationFrame||a.msRequestAnimationFrame||function(b){return a.setTimeout(b,1e3/60)}}(),a.cancelRequestAnimFrame=function(){return a.cancelAnimationFrame||a.webkitCancelRequestAnimationFrame||a.mozCancelRequestAnimationFrame||a.oCancelRequestAnimationFrame||a.msCancelRequestAnimationFrame||clearTimeout}(),a.getComputedStyle||!function(){var b,c={getPropertyValue:function(a){return"float"==a&&(a="styleFloat"),b.currentStyle[a.toUpperCase()]||null}};a.getComputedStyle=function(a){return b=a,c}}(),!String.prototype.trim){var db=/^\s+|\s+$/g;String.prototype.trim=function(){return this.replace(db,"")}}t.prototype.offsetted=function(a){return a+this.offset},t.prototype.unOffsetted=function(a){return a-this.offset},t.prototype.renderedToSource=function(a){return this.offsetted(a)},t.prototype.sourceToRendered=function(a){return this.unOffsetted(a)},t.prototype.offsettedTH=function(a){return a-this.countTH},t.prototype.visibleColHeadedRowToSourceRow=function(a){return this.renderedToSource(this.offsettedTH(a))},t.prototype.sourceRowToVisibleColHeadedRow=function(a){return this.unOffsettedTH(this.sourceToRendered(a))},u.prototype.scrollViewport=function(a){if(this.instance.drawn){var b=this.instance.getSetting("totalRows"),c=this.instance.getSetting("totalColumns");if(a.row<0||a.row>b-1)throw new Error("row "+a.row+" does not exist");if(a.col<0||a.col>c-1)throw new Error("column "+a.col+" does not exist");var d=this.instance.wtTable.getCell(a);"object"==typeof d?a.col>=this.instance.getSetting("fixedColumnsLeft")&&this.scrollToRenderedCell(d):a.row>=this.instance.wtTable.getLastVisibleRow()?this.instance.wtScrollbars.vertical.scrollTo(a.row,!0):a.row>=this.instance.getSetting("fixedRowsTop")&&this.instance.wtScrollbars.vertical.scrollTo(a.row)}},u.prototype.scrollToRenderedCell=function(c){var d=b.Dom.offset(c),e=b.Dom.outerWidth(c),f=b.Dom.outerHeight(c),g=b.Dom.offset(this.instance.wtTable.TABLE),h={left:this.instance.wtScrollbars.horizontal.getScrollPosition(),top:this.instance.wtScrollbars.vertical.getScrollPosition()},i=this.instance.wtViewport.getWorkspaceWidth(),j=this.instance.wtViewport.getWorkspaceHeight(),k=b.Dom.outerWidth(this.instance.wtScrollbars.horizontal.clone.wtTable.TABLE),l=b.Dom.outerHeight(this.instance.wtScrollbars.vertical.clone.wtTable.TABLE);if(this.instance.wtScrollbars.horizontal.scrollHandler!==a&&(g.left=0,d.left-=b.Dom.offset(this.instance.wtScrollbars.horizontal.scrollHandler).left),this.instance.wtScrollbars.vertical.scrollHandler!==a&&(g.top=0,d.top=d.top-b.Dom.offset(this.instance.wtScrollbars.vertical.scrollHandler).top),i>e)if(d.left<h.left+k)this.instance.wtScrollbars.horizontal.setScrollPosition(d.left-k);else if(d.left+e>g.left+h.left+i){var m=d.left+e-(g.left+h.left+i);this.instance.wtScrollbars.horizontal.setScrollPosition(h.left+m)}j>f&&(d.top<h.top+l?(this.instance.wtScrollbars.vertical.setScrollPosition(d.top-l),this.instance.wtScrollbars.vertical.onScroll()):d.top+f>h.top+j&&(this.instance.wtScrollbars.vertical.setScrollPosition(d.top-j+f),this.instance.wtScrollbars.vertical.onScroll()))},v.prototype=new j,v.prototype.resetFixedPosition=function(){if(this.instance.wtTable.holder.parentNode){var c=this.clone.wtTable.holder.parentNode;if(this.scrollHandler===a){var d,e,f=this.instance.wtTable.holder.getBoundingClientRect(),g=Math.ceil(f.top),h=Math.ceil(f.left),i=Math.ceil(f.bottom);d=0>h&&h+b.Dom.outerWidth(this.instance.wtTable.TABLE)>0?-h+"px":"0",e=0>g&&i-c.offsetHeight>0?-g+"px":"0"}else b.freezeOverlays||(d=this.instance.wtScrollbars.horizontal.getScrollPosition()+"px",e=this.instance.wtScrollbars.vertical.getScrollPosition()+"px");b.Dom.setOverlayPosition(c,d,e),c.style.width=b.Dom.outerWidth(this.clone.wtTable.TABLE)+4+"px",c.style.height=b.Dom.outerHeight(this.clone.wtTable.TABLE)+4+"px"}},w.prototype=new j,w.prototype.resetFixedPosition=function(){if(this.instance.wtTable.holder.parentNode){var c=this.clone.wtTable.holder.parentNode;if(this.scrollHandler===a){var d,e,f=this.instance.wtTable.holder.getBoundingClientRect(),g=Math.ceil(f.left);d=0>g&&g+b.Dom.outerWidth(this.instance.wtTable.TABLE)>0?-g+"px":"0",e=this.instance.wtTable.hider.style.top}else b.freezeOverlays||(d=this.getScrollPosition()+"px",e=this.instance.wtTable.hider.style.top);b.Dom.setOverlayPosition(c,d,e),c.style.height=b.Dom.outerHeight(this.clone.wtTable.TABLE)+"px",c.style.width=b.Dom.outerWidth(this.clone.wtTable.TABLE)+4+"px"}},w.prototype.refresh=function(a){j.prototype.refresh.call(this,a)},w.prototype.getScrollPosition=function(){return b.Dom.getScrollLeft(this.scrollHandler)},w.prototype.setScrollPosition=function(c){this.scrollHandler===a?a.scrollTo(c,b.Dom.getWindowScrollTop()):this.scrollHandler.scrollLeft=c},w.prototype.onScroll=function(){this.readSettings(),this.instance.getSetting("onScrollHorizontally")},w.prototype.getLastCell=function(){return this.instance.wtTable.getLastVisibleColumn()},w.prototype.applyToDOM=function(){},w.prototype.scrollTo=function(a){this.setScrollPosition(this.getTableParentOffset()+a*this.cellSize)},w.prototype.getTableParentOffset=function(){return this.scrollHandler===a?this.instance.wtTable.holderOffset.left:0},w.prototype.readSettings=function(){this.total=this.instance.getSetting("totalColumns")},x.prototype=new j,x.prototype.resetFixedPosition=function(){if(this.instance.wtTable.holder.parentNode){var c=this.clone.wtTable.holder.parentNode;if(this.scrollHandler===a){var d,e,f=this.instance.wtTable.holder.getBoundingClientRect(),g=Math.ceil(f.top),h=Math.ceil(f.bottom);d="0",e=0>g&&h-c.offsetHeight>0?-g+"px":"0"}else b.freezeOverlays||(e=this.getScrollPosition()+"px",d="0");b.Dom.setOverlayPosition(c,d,e),c.style.width=this.instance.wtScrollbars.horizontal.scrollHandler===a?this.instance.wtViewport.getWorkspaceActualWidth()+"px":b.Dom.outerWidth(this.clone.wtTable.TABLE)+"px",c.style.height=b.Dom.outerHeight(this.clone.wtTable.TABLE)+4+"px"}},x.prototype.getScrollPosition=function(){return b.Dom.getScrollTop(this.scrollHandler)},x.prototype.setScrollPosition=function(c){this.scrollHandler===a?a.scrollTo(b.Dom.getWindowScrollLeft(),c):this.scrollHandler.scrollTop=c},x.prototype.onScroll=function(){this.readSettings(),this.instance.draw(!0),this.instance.getSetting("onScrollVertically")},x.prototype.getLastCell=function(){return this.instance.wtViewport.rowsPreCalculator.renderEndRow},x.prototype.sumCellSizes=function(a,b){for(var c=0;b>a;)c+=this.instance.wtTable.getRowHeight(a)||this.instance.wtSettings.settings.defaultRowHeight,a++;return c},x.prototype.refresh=function(a){this.applyToDOM(),j.prototype.refresh.call(this,a)},x.prototype.applyToDOM=function(){var a=this.instance.getSetting("totalRows"),b=this.instance.wtViewport.getColumnHeaderHeight();if(this.fixedContainer.style.height=b+this.sumCellSizes(0,a)+4+"px","number"==typeof this.instance.wtViewport.rowsCalculator.renderStartPosition)this.fixed.style.top=this.instance.wtViewport.rowsCalculator.renderStartPosition+"px";else{if(0!==a)throw new Error("Incorrect value of the rowCalculator");this.fixed.style.top="0"}this.fixed.style.bottom=""},x.prototype.scrollTo=function(a,b){var c=this.getTableParentOffset();b?(c+=this.sumCellSizes(0,a+1),c-=this.instance.wtViewport.getViewportHeight()):c+=this.sumCellSizes(0,a),this.setScrollPosition(c)},x.prototype.getTableParentOffset=function(){return this.scrollHandler===a?this.instance.wtTable.holderOffset.top:0},x.prototype.readSettings=function(){},y.prototype.registerListeners=function(){var c=this;this.refreshAll=function(){if(c.instance.drawn){if(!c.instance.wtTable.holder.parentNode)return void c.destroy();c.vertical.onScroll(),c.horizontal.onScroll()}};var d=b.eventManager(c.instance);d.addEventListener(this.vertical.scrollHandler,"scroll",this.refreshAll),this.vertical.scrollHandler!==this.horizontal.scrollHandler&&d.addEventListener(this.horizontal.scrollHandler,"scroll",this.refreshAll),this.vertical.scrollHandler!==a&&this.horizontal.scrollHandler!==a&&d.addEventListener(a,"scroll",this.refreshAll)},y.prototype.destroy=function(){var c=b.eventManager(this.instance);this.vertical&&(this.vertical.destroy(),c.removeEventListener(this.vertical.scrollHandler,"scroll",this.refreshAll)),this.horizontal&&(this.horizontal.destroy(),c.removeEventListener(this.horizontal.scrollHandler,"scroll",this.refreshAll)),c.removeEventListener(a,"scroll",this.refreshAll),this.corner&&this.corner.destroy(),this.debug&&this.debug.destroy()},y.prototype.refresh=function(a){this.horizontal&&this.horizontal.readSettings(),this.vertical&&this.vertical.readSettings(),this.horizontal&&this.horizontal.refresh(a),this.vertical&&this.vertical.refresh(a),this.corner&&this.corner.refresh(a),this.debug&&this.debug.refresh(a)},y.prototype.applyToDOM=function(){this.horizontal&&this.horizontal.applyToDOM(),this.vertical&&this.vertical.applyToDOM()},z.prototype.getBorder=function(a){return this.instanceBorders[a.guid]?this.instanceBorders[a.guid]:void(this.instanceBorders[a.guid]=new k(a,this.settings))},z.prototype.isEmpty=function(){return null===this.cellRange},z.prototype.add=function(a){this.isEmpty()?this.cellRange=new m(a,a,a):this.cellRange.expand(a)},z.prototype.replace=function(a,b){if(!this.isEmpty()){if(this.cellRange.from.isEqual(a))return this.cellRange.from=b,!0;if(this.cellRange.to.isEqual(a))return this.cellRange.to=b,!0}return!1},z.prototype.clear=function(){this.cellRange=null},z.prototype.getCorners=function(){var a=this.cellRange.getTopLeftCorner(),b=this.cellRange.getBottomRightCorner();return[a.row,a.col,b.row,b.col]},z.prototype.addClassAtCoords=function(a,c,d,e){var f=a.wtTable.getCell(new l(c,d));"object"==typeof f&&b.Dom.addClass(f,e)},z.prototype.draw=function(a){var c,d,e,f,g,h=a.wtTable.getRenderedRowsCount(),i=a.wtTable.getRenderedColumnsCount();if(this.isEmpty()){if(this.settings.border){var j=this.getBorder(a);j&&j.disappear()}}else{for(c=this.getCorners(),d=0;h>d;d++)for(f=a.wtTable.rowFilter.renderedToSource(d),e=0;i>e;e++)if(g=a.wtTable.columnFilter.renderedToSource(e),f>=c[0]&&f<=c[2]&&g>=c[1]&&g<=c[3]){if(this.settings.className&&this.addClassAtCoords(a,f,g,this.settings.className),g===c[1]){var k=a.wtTable.getRowHeader(f);k&&this.settings.highlightRowClassName&&b.Dom.addClass(k,this.settings.highlightRowClassName)}if(f===c[0]||f>c[0]&&0==d){var k=a.wtTable.getColumnHeader(g);k&&this.settings.highlightColumnClassName&&b.Dom.addClass(k,this.settings.highlightColumnClassName)}}else f>=c[0]&&f<=c[2]?this.settings.highlightRowClassName&&this.addClassAtCoords(a,f,g,this.settings.highlightRowClassName):g>=c[1]&&g<=c[3]&&this.settings.highlightColumnClassName&&this.addClassAtCoords(a,f,g,this.settings.highlightColumnClassName);if(a.getSetting("onBeforeDrawBorders",c,this.settings.className),this.settings.border){var j=this.getBorder(a);j&&j.appear(c)}}},A.prototype.update=function(a,b){if(void 0===b)for(var c in a)a.hasOwnProperty(c)&&(this.settings[c]=a[c]);else this.settings[a]=b;return this.instance},A.prototype.getSetting=function(a,b,c,d,e){return"function"==typeof this.settings[a]?this.settings[a](b,c,d,e):void 0!==b&&"[object Array]"===Object.prototype.toString.call(this.settings[a])?this.settings[a][b]:this.settings[a]},A.prototype.has=function(a){return!!this.settings[a]},B.prototype.getColumnStrategy=function(){return this.isWorkingOnClone()?this.instance.cloneSource.wtTable.columnStrategy:this.columnStrategy},B.prototype.isWorkingOnClone=function(){return!!this.instance.cloneSource},B.prototype.refreshHiderDimensions=function(){var a=this.spreader.style;a.position="relative",a.width="auto",a.height="auto"},B.prototype.draw=function(a){if(this.isWorkingOnClone()||(this.holderOffset=b.Dom.offset(this.holder),this.instance.wtViewport.createPreCalculators()),a&&(this.instance.wtViewport.areAllProposedVisibleRowsAlreadyRendered()||(a=!1)),!this.isWorkingOnClone()){var c=this.instance.wtViewport.rowsCalculator;this.instance.wtViewport.rowsCalculator=null}if(a)this.isWorkingOnClone()||this.instance.wtViewport.createCalculators(c),this.instance.wtScrollbars&&this.instance.wtScrollbars.refresh(!0);else{this.isWorkingOnClone()?this.tableOffset=this.instance.cloneSource.wtTable.tableOffset:(this.tableOffset=b.Dom.offset(this.TABLE),this.instance.wtScrollbars.vertical.readSettings(),this.instance.wtScrollbars.horizontal.readSettings());var d;d=this.instance.cloneOverlay instanceof q||this.instance.cloneOverlay instanceof x||this.instance.cloneOverlay instanceof v?0:this.instance.wtViewport.rowsPreCalculator.renderStartRow,this.rowFilter=new t(d,this.instance.getSetting("totalRows"),this.instance.getSetting("columnHeaders").length),this.columnFilter=new n(this.instance.getSetting("totalColumns"),this.instance.getSetting("rowHeaders").length),this._doDraw()}return this.refreshPositions(a),this.isWorkingOnClone()||(this.instance.wtScrollbars.vertical.resetFixedPosition(),this.instance.wtScrollbars.horizontal.resetFixedPosition(),this.instance.wtScrollbars.corner.resetFixedPosition()),this.instance.drawn=!0,this},B.prototype._doDraw=function(){var a=new C(this);a.render()},B.prototype.refreshPositions=function(a){this.refreshHiderDimensions(),this.refreshSelections(a)},B.prototype.removeClassFromCells=function(a){for(var c=this.TABLE.querySelectorAll("."+a),d=0,e=c.length;e>d;d++)b.Dom.removeClass(c[d],a)},B.prototype.refreshSelections=function(a){var b,c;if(this.instance.selections){if(a)for(b=0,c=this.instance.selections.length;c>b;b++)this.instance.selections[b].settings.className&&this.removeClassFromCells(this.instance.selections[b].settings.className),this.instance.selections[b].settings.highlightRowClassName&&this.removeClassFromCells(this.instance.selections[b].settings.highlightRowClassName),this.instance.selections[b].settings.highlightColumnClassName&&this.removeClassFromCells(this.instance.selections[b].settings.highlightColumnClassName);for(b=0,c=this.instance.selections.length;c>b;b++)this.instance.selections[b].draw(this.instance,a)}},B.prototype.getCell=function(a){if(this.isRowBeforeRenderedRows(a.row))return-1;if(this.isRowAfterRenderedRows(a.row))return-2;var b=this.TBODY.childNodes[this.rowFilter.sourceToRendered(a.row)];return b?b.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(a.col)]:void 0},B.prototype.getColumnHeader=function(a){var b=this.THEAD.childNodes[0];return b?b.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(a)]:void 0},B.prototype.getRowHeader=function(a){if(0==this.columnFilter.sourceColumnToVisibleRowHeadedColumn(0))return null;var b=this.TBODY.childNodes[this.rowFilter.sourceToRendered(a)];return b?b.childNodes[0]:void 0},B.prototype.getCoords=function(a){var c=a.parentNode,d=b.Dom.index(c);return d=c.parentNode===this.THEAD?this.rowFilter.visibleColHeadedRowToSourceRow(d):this.rowFilter.renderedToSource(d),new l(d,this.columnFilter.visibleRowHeadedColumnToSourceColumn(a.cellIndex))},B.prototype.getTrForRow=function(a){return this.TBODY.childNodes[this.rowFilter.sourceToRendered(a)]},B.prototype.getFirstRenderedRow=function(){return this.instance.wtViewport.rowsPreCalculator.renderStartRow},B.prototype.getFirstVisibleRow=function(){return this.instance.wtViewport.rowsCalculator.visibleStartRow},B.prototype.getFirstRenderedColumn=function(){return 0},B.prototype.getFirstVisibleColumn=function(){if(this.isWorkingOnClone())return this.instance.cloneOverlay instanceof w||this.instance.cloneOverlay instanceof v?0:this.instance.cloneSource.wtTable.getFirstVisibleColumn();var a=this.instance.wtScrollbars.horizontal.getScrollPosition(),b=this.getColumnStrategy().cellCount,c=this.TBODY.firstChild;if(!c)return 0;for(var d=0;b>d;d++)if(a-=c.childNodes[d].offsetWidth,0>a)return d;return-1},B.prototype.getLastRenderedRow=function(){return this.instance.wtViewport.rowsPreCalculator.renderEndRow},B.prototype.getLastVisibleRow=function(){return this.instance.wtViewport.rowsCalculator.visibleEndRow},B.prototype.getLastVisibleColumn=function(){var a=this.instance;if(this.isWorkingOnClone()){if(a.cloneOverlay instanceof w||a.cloneOverlay instanceof v){var b=this.getColumnStrategy().countVisible()-1,c=a.getSetting("fixedColumnsLeft");return Math.min(c-1,b)}return this.instance.cloneSource.wtTable.getLastVisibleColumn()}var d=this.instance.wtScrollbars.horizontal.getScrollPosition(),e=d+this.instance.wtViewport.getWorkspaceWidth(),f=this.getColumnStrategy().cellCount,g=this.instance.getSetting("rowHeaders").length||0,h=this.TBODY.firstChild;if(!f)return-1;for(var i=0;f+g>i;i++)if(e-=h.childNodes[i].offsetWidth,0>=e)return i-g;return i-g-1},B.prototype.isRowBeforeRenderedRows=function(a){return this.rowFilter.sourceToRendered(a)<0&&a>=0},B.prototype.isRowAfterViewport=function(a){return a>this.getLastVisibleRow()},B.prototype.isRowAfterRenderedRows=function(a){return a>this.getLastRenderedRow()},B.prototype.isColumnBeforeViewport=function(a){return this.columnFilter.sourceToRendered(a)<0&&a>=0},B.prototype.isColumnAfterViewport=function(a){return a>this.getLastVisibleColumn()},B.prototype.isLastRowFullyVisible=function(){return this.getLastVisibleRow()===this.getLastRenderedRow()},B.prototype.isLastColumnFullyVisible=function(){return this.getLastVisibleColumn()===this.instance.getSetting("totalColumns")-1&&!this.getColumnStrategy().isLastIncomplete()},B.prototype.getRenderedColumnsCount=function(){var a=this.isWorkingOnClone();return a&&this.instance.cloneOverlay instanceof q?1:a&&(this.instance.cloneOverlay instanceof w||this.instance.cloneOverlay instanceof v)?this.instance.getSetting("fixedColumnsLeft"):this.getColumnStrategy().cellCount},B.prototype.getRenderedRowsCount=function(){return this.instance.wtViewport.rowsPreCalculator.countRendered},B.prototype.getVisibleRowsCount=function(){return this.instance.wtViewport.rowsCalculator.countVisible},B.prototype.allRowsInViewport=function(){return this.instance.getSetting("totalRows")==this.getVisibleRowsCount()},B.prototype.getRowHeight=function(a){var b=this.instance.wtSettings.settings.rowHeight(a),c=this.instance.wtViewport.oversizedRows[a];return void 0!==c&&(b=b?Math.max(b,c):c),b},C.prototype.render=function(){this.wtTable.isWorkingOnClone()||this.instance.getSetting("beforeDraw",!0),this.rowHeaders=this.instance.getSetting("rowHeaders"),this.rowHeaderCount=this.rowHeaders.length,this.fixedRowsTop=this.instance.getSetting("fixedRowsTop"),this.columnHeaders=this.instance.getSetting("columnHeaders"),this.columnHeaderCount=this.columnHeaders.length;var a,b,c,d=this.instance.getSetting("totalRows"),e=this.instance.getSetting("totalColumns"),f=!1,g=this.instance.wtViewport.rowsPreCalculator.countRendered;if(e>0&&(this.wtTable.isWorkingOnClone()&&(this.instance.cloneOverlay instanceof x||this.instance.cloneOverlay instanceof v?g=this.fixedRowsTop:this.instance.cloneOverlay instanceof q&&(g=d)),this.adjustAvailableNodes(),f=!0,this.renderColGroups(),this.renderColumnHeaders(),b=this.wtTable.getRenderedColumnsCount(),this.renderRows(d,g,b),this.wtTable.isWorkingOnClone()||(c=this.instance.wtViewport.getWorkspaceWidth(),this.instance.wtViewport.containerWidth=null,this.wtTable.getColumnStrategy().stretch()),this.adjustColumnWidths(b)),f||this.adjustAvailableNodes(),this.removeRedundantRows(g),!this.wtTable.isWorkingOnClone()){if(this.markOversizedRows(),this.instance.wtViewport.createCalculators(),this.instance.wtScrollbars.applyToDOM(),c!==this.instance.wtViewport.getWorkspaceWidth()){this.instance.wtViewport.containerWidth=null,this.wtTable.getColumnStrategy().stretch();var h=this.instance.wtTable.columnWidthCache;for(a=0;a<this.wtTable.getColumnStrategy().cellCount;a++){var i=this.wtTable.getColumnStrategy().getSize(a);this.COLGROUP.childNodes[a+this.rowHeaderCount].style.width=i+"px",h[a]=i}}this.instance.wtScrollbars.refresh(!1),this.instance.getSetting("onDraw",!0)}},C.prototype.removeRedundantRows=function(a){for(;this.wtTable.tbodyChildrenLength>a;)this.TBODY.removeChild(this.TBODY.lastChild),this.wtTable.tbodyChildrenLength--},C.prototype.renderRows=function(a,b,c){for(var d,e,f=0,g=this.rowFilter.renderedToSource(f),h=this.wtTable.isWorkingOnClone();a>g&&g>=0;){if(f>1e3)throw new Error("Security brake: Too much TRs. Please define height for your table, which will enforce scrollbars.");if(void 0!==b&&f===b)break;if(e=this.getOrCreateTrForRow(f,e),this.renderRowHeaders(g,e),this.adjustColumns(e,c+this.rowHeaderCount),d=this.renderCells(g,e,c),h||this.resetOversizedRow(g),e.firstChild){var i=this.instance.wtTable.getRowHeight(g);e.firstChild.style.height=i?i+"px":""}f++,g=this.rowFilter.renderedToSource(f)}},C.prototype.resetOversizedRow=function(a){this.instance.wtViewport.oversizedRows&&this.instance.wtViewport.oversizedRows[a]&&(this.instance.wtViewport.oversizedRows[a]=void 0)},C.prototype.markOversizedRows=function(){for(var a,c,d,e,f=this.instance.wtTable.TBODY.childNodes.length;f;)f--,d=this.instance.wtTable.rowFilter.renderedToSource(f),a=this.instance.wtTable.getRowHeight(d),e=this.instance.wtTable.getTrForRow(d),c=b.Dom.innerHeight(e)-1,(!a&&this.instance.wtSettings.settings.defaultRowHeight<c||c>a)&&(this.instance.wtViewport.oversizedRows[d]=c)},C.prototype.renderCells=function(a,c,d){for(var e,f,g=0;d>g;g++)f=this.columnFilter.renderedToSource(g),e=0===g?c.childNodes[this.columnFilter.sourceColumnToVisibleRowHeadedColumn(f)]:e.nextSibling,"TH"==e.nodeName&&(e=this.utils.replaceThWithTd(e,c)),b.Dom.hasClass(e,"hide")||(e.className=""),e.removeAttribute("style"),this.instance.getSetting("cellRenderer",a,f,e);return e},C.prototype.adjustColumnWidths=function(a){for(var b,c=this.instance.wtTable.columnWidthCache,d=!1,e=0;a>e;e++)b=this.wtTable.isWorkingOnClone()?this.instance.cloneSource.wtTable.columnWidthCache[e]:this.wtTable.getColumnStrategy().getSize(e),b!==c[e]&&(this.COLGROUP.childNodes[e+this.rowHeaderCount].style.width=b+"px",c[e]=b,d=!0)},C.prototype.appendToTbody=function(a){this.TBODY.appendChild(a),this.wtTable.tbodyChildrenLength++},C.prototype.getOrCreateTrForRow=function(a,b){var c;return a>=this.wtTable.tbodyChildrenLength?(c=this.createRow(),this.appendToTbody(c)):c=0===a?this.TBODY.firstChild:b.nextSibling,c},C.prototype.createRow=function(){for(var a=document.createElement("TR"),b=0;b<this.rowHeaderCount;b++)a.appendChild(document.createElement("TH"));return a},C.prototype.renderRowHeader=function(a,b,c){c.className="",c.removeAttribute("style"),this.rowHeaders[b](a,c,b)},C.prototype.renderRowHeaders=function(a,b){for(var c=b.firstChild,d=0;d<this.rowHeaderCount;d++)c?"TD"==c.nodeName&&(c=this.utils.replaceTdWithTh(c,b)):(c=document.createElement("TH"),b.appendChild(c)),this.renderRowHeader(a,d,c),c=c.nextSibling},C.prototype.adjustAvailableNodes=function(){this.refreshStretching(),this.adjustColGroups(),this.adjustThead()},C.prototype.renderColumnHeaders=function(){if(this.columnHeaderCount)for(var a,b=this.wtTable.getRenderedColumnsCount(),c=0;c<this.columnHeaderCount;c++){a=this.getTrForColumnHeaders(c);for(var d=-1*this.rowHeaderCount;b>d;d++)this.renderColumnHeader(c,d,a.childNodes[d+this.rowHeaderCount])}},C.prototype.adjustColGroups=function(){for(var a=this.wtTable.getRenderedColumnsCount();this.wtTable.colgroupChildrenLength<a+this.rowHeaderCount;)this.COLGROUP.appendChild(document.createElement("COL")),this.wtTable.colgroupChildrenLength++;for(;this.wtTable.colgroupChildrenLength>a+this.rowHeaderCount;)this.COLGROUP.removeChild(this.COLGROUP.lastChild),this.wtTable.colgroupChildrenLength--,this.wtTable.columnWidthCache&&this.wtTable.columnWidthCache.splice(-1,1)},C.prototype.adjustThead=function(){var a=this.wtTable.getRenderedColumnsCount(),c=this.THEAD.firstChild;if(this.columnHeaders.length){for(var d=0,e=this.columnHeaders.length;e>d;d++){for(c=this.THEAD.childNodes[d],c||(c=document.createElement("TR"),this.THEAD.appendChild(c)),this.theadChildrenLength=c.childNodes.length;this.theadChildrenLength<a+this.rowHeaderCount;)c.appendChild(document.createElement("TH")),this.theadChildrenLength++;for(;this.theadChildrenLength>a+this.rowHeaderCount;)c.removeChild(c.lastChild),this.theadChildrenLength--}var f=this.THEAD.childNodes.length;if(f>this.columnHeaders.length)for(var d=this.columnHeaders.length;f>d;d++)this.THEAD.removeChild(this.THEAD.lastChild)}else c&&b.Dom.empty(c)},C.prototype.getTrForColumnHeaders=function(a){var b=this.THEAD.childNodes[a];return b},C.prototype.renderColumnHeader=function(a,b,c){return c.className="",c.removeAttribute("style"),this.columnHeaders[a](b,c,a)},C.prototype.renderColGroups=function(){for(var a=0;a<this.wtTable.colgroupChildrenLength;a++)a<this.rowHeaderCount?b.Dom.addClass(this.COLGROUP.childNodes[a],"rowHeader"):b.Dom.removeClass(this.COLGROUP.childNodes[a],"rowHeader")},C.prototype.adjustColumns=function(a,b){for(var c=a.childNodes.length;b>c;){var d=document.createElement("TD");a.appendChild(d),c++}for(;c>b;)a.removeChild(a.lastChild),c--},C.prototype.refreshStretching=function(){if(!this.wtTable.isWorkingOnClone()){var a=this.instance,b=a.getSetting("stretchH"),c=a.getSetting("totalColumns"),d=function(){var a=e.instance.wtViewport.getViewportWidth();return a},e=this,f=function(b){var d=e.columnFilter.renderedToSource(b);return c>d?a.getSetting("columnWidth",d):void 0
};this.wtTable.columnStrategy=new o(a,d,f,b)}},C.utils={},C.utils.replaceTdWithTh=function(a,b){var c;return c=document.createElement("TH"),b.insertBefore(c,a),b.removeChild(a),c},C.utils.replaceThWithTd=function(a,b){var c=document.createElement("TD");return b.insertBefore(c,a),b.removeChild(a),c},D.prototype.getWorkspaceHeight=function(){var c=this.instance.wtScrollbars.vertical.scrollHandler;if(c===a)return document.documentElement.clientHeight;var d=b.Dom.outerHeight(c),e=d>0&&c.clientHeight>0?c.clientHeight:1/0;return e},D.prototype.getWorkspaceWidth=function(){var c;c=b.freezeOverlays?Math.min(document.documentElement.offsetWidth-this.getWorkspaceOffset().left,document.documentElement.offsetWidth):Math.min(this.getContainerFillWidth(),document.documentElement.offsetWidth-this.getWorkspaceOffset().left,document.documentElement.offsetWidth);var d=this.instance.wtScrollbars.horizontal.scrollHandler;if(d!=a){var e=this.instance.wtScrollbars.horizontal.scrollHandler.style.overflow;if("scroll"==e||"hidden"==e||"auto"==e)return Math.max(c,d.clientWidth)}return Math.max(c,b.Dom.outerWidth(this.instance.wtTable.TABLE))},D.prototype.getContainerFillWidth=function(){if(this.containerWidth)return this.containerWidth;for(var a,b,c=this.instance.wtTable.holder;c.parentNode!=document.body&&null!=c.parentNode&&-1===c.className.indexOf("handsontable");)c=c.parentNode;return b=document.createElement("DIV"),b.style.width="100%",b.style.height="1px",c.appendChild(b),a=b.offsetWidth,this.containerWidth=a,c.removeChild(b),a},D.prototype.getWorkspaceOffset=function(){return b.Dom.offset(this.instance.wtTable.TABLE)},D.prototype.getWorkspaceActualHeight=function(){return b.Dom.outerHeight(this.instance.wtTable.TABLE)},D.prototype.getWorkspaceActualWidth=function(){return b.Dom.outerWidth(this.instance.wtTable.TABLE)||b.Dom.outerWidth(this.instance.wtTable.TBODY)||b.Dom.outerWidth(this.instance.wtTable.THEAD)},D.prototype.getColumnHeaderHeight=function(){return isNaN(this.columnHeaderHeight)&&(this.columnHeaderHeight=b.Dom.outerHeight(this.instance.wtTable.THEAD)),this.columnHeaderHeight},D.prototype.getViewportHeight=function(){var a=this.getWorkspaceHeight();if(1/0===a)return a;var b=this.getColumnHeaderHeight();return b>0&&(a-=b),a},D.prototype.getRowHeaderWidth=function(){if(this.instance.cloneSource)return this.instance.cloneSource.wtViewport.getRowHeaderWidth();if(isNaN(this.rowHeaderWidth)){var a=this.instance.getSetting("rowHeaders");if(a.length){var c=this.instance.wtTable.TABLE.querySelector("TH");this.rowHeaderWidth=0;for(var d=0,e=a.length;e>d;d++)c?(this.rowHeaderWidth+=b.Dom.outerWidth(c),c=c.nextSibling):this.rowHeaderWidth+=50}else this.rowHeaderWidth=0}return this.rowHeaderWidth},D.prototype.getViewportWidth=function(){var a=this.getWorkspaceWidth();if(1/0===a)return a;var b=this.getRowHeaderWidth();return b>0?a-b:a},D.prototype.createRowsCalculator=function(){this.rowHeaderWidth=0/0,this.columnHeaderHeight=0/0;var a;a=this.instance.cloneOverlay instanceof q||this.instance.wtSettings.settings.renderAllRows?1/0:this.getViewportHeight();var b=this.instance.wtScrollbars.vertical.getScrollPosition()-this.instance.wtScrollbars.vertical.getTableParentOffset();0>b&&(b=0);var c=this;return new E(a,b,this.instance.getSetting("totalRows"),function(a){return c.instance.wtTable.getRowHeight(a)},this.instance.wtSettings.settings.viewportRowCalculatorOverride)},D.prototype.createPreCalculators=function(){this.rowsPreCalculator=this.createRowsCalculator()},D.prototype.createCalculators=function(a){if(a){var b=this.createRowsCalculator();this.rowsCalculator=a,this.rowsCalculator.visibleStartRow=b.visibleStartRow,this.rowsCalculator.visibleEndRow=b.visibleEndRow,this.rowsCalculator.visibleCellCount=b.visibleCellCount}else this.rowsCalculator=this.createRowsCalculator()},D.prototype.areAllProposedVisibleRowsAlreadyRendered=function(){return this.rowsCalculator?this.rowsPreCalculator.visibleStartRow<this.rowsCalculator.renderStartRow||this.rowsPreCalculator.visibleEndRow>this.rowsCalculator.renderEndRow?!1:this.rowsPreCalculator.scrollOffset!==this.rowsCalculator.scrollOffset&&(this.rowsPreCalculator.visibleStartRow<=this.rowsCalculator.renderStartRow||this.rowsPreCalculator.visibleEndRow>=this.rowsCalculator.renderEndRow)?!1:!0:!1},a.jQuery&&!function(a,b,c){b.fn.handsontable=function(a){var b,d,e,f,g,h=this.first(),i=h.data("handsontable");if("string"!=typeof a)return g=a||{},i?i.updateSettings(g):(i=new c.Core(h[0],g),h.data("handsontable",i),i.init()),h;if(e=[],arguments.length>1)for(b=1,d=arguments.length;d>b;b++)e.push(arguments[b]);if(i){if("undefined"==typeof i[a])throw new Error("Handsontable do not provide action: "+a);f=i[a].apply(i,e),"destroy"===a&&h.removeData()}return f}}(a,jQuery,b)}(window,Handsontable),/*!
 * numeral.js
 * version : 1.5.3
 * author : Adam Draper
 * license : MIT
 * http://adamwdraper.github.com/Numeral-js/
 */
function(){function a(a){this._value=a}function b(a,b,c,d){var e,f,g=Math.pow(10,b);return f=(c(a*g)/g).toFixed(b),d&&(e=new RegExp("0{1,"+d+"}$"),f=f.replace(e,"")),f}function c(a,b,c){var d;return d=b.indexOf("$")>-1?e(a,b,c):b.indexOf("%")>-1?f(a,b,c):b.indexOf(":")>-1?g(a,b):i(a._value,b,c)}function d(a,b){var c,d,e,f,g,i=b,j=["KB","MB","GB","TB","PB","EB","ZB","YB"],k=!1;if(b.indexOf(":")>-1)a._value=h(b);else if(b===q)a._value=0;else{for("."!==o[p].delimiters.decimal&&(b=b.replace(/\./g,"").replace(o[p].delimiters.decimal,".")),c=new RegExp("[^a-zA-Z]"+o[p].abbreviations.thousand+"(?:\\)|(\\"+o[p].currency.symbol+")?(?:\\))?)?$"),d=new RegExp("[^a-zA-Z]"+o[p].abbreviations.million+"(?:\\)|(\\"+o[p].currency.symbol+")?(?:\\))?)?$"),e=new RegExp("[^a-zA-Z]"+o[p].abbreviations.billion+"(?:\\)|(\\"+o[p].currency.symbol+")?(?:\\))?)?$"),f=new RegExp("[^a-zA-Z]"+o[p].abbreviations.trillion+"(?:\\)|(\\"+o[p].currency.symbol+")?(?:\\))?)?$"),g=0;g<=j.length&&!(k=b.indexOf(j[g])>-1?Math.pow(1024,g+1):!1);g++);a._value=(k?k:1)*(i.match(c)?Math.pow(10,3):1)*(i.match(d)?Math.pow(10,6):1)*(i.match(e)?Math.pow(10,9):1)*(i.match(f)?Math.pow(10,12):1)*(b.indexOf("%")>-1?.01:1)*((b.split("-").length+Math.min(b.split("(").length-1,b.split(")").length-1))%2?1:-1)*Number(b.replace(/[^0-9\.]+/g,"")),a._value=k?Math.ceil(a._value):a._value}return a._value}function e(a,b,c){var d,e,f=b.indexOf("$"),g=b.indexOf("("),h=b.indexOf("-"),j="";return b.indexOf(" $")>-1?(j=" ",b=b.replace(" $","")):b.indexOf("$ ")>-1?(j=" ",b=b.replace("$ ","")):b=b.replace("$",""),e=i(a._value,b,c),1>=f?e.indexOf("(")>-1||e.indexOf("-")>-1?(e=e.split(""),d=1,(g>f||h>f)&&(d=0),e.splice(d,0,o[p].currency.symbol+j),e=e.join("")):e=o[p].currency.symbol+j+e:e.indexOf(")")>-1?(e=e.split(""),e.splice(-1,0,j+o[p].currency.symbol),e=e.join("")):e=e+j+o[p].currency.symbol,e}function f(a,b,c){var d,e="",f=100*a._value;return b.indexOf(" %")>-1?(e=" ",b=b.replace(" %","")):b=b.replace("%",""),d=i(f,b,c),d.indexOf(")")>-1?(d=d.split(""),d.splice(-1,0,e+"%"),d=d.join("")):d=d+e+"%",d}function g(a){var b=Math.floor(a._value/60/60),c=Math.floor((a._value-60*b*60)/60),d=Math.round(a._value-60*b*60-60*c);return b+":"+(10>c?"0"+c:c)+":"+(10>d?"0"+d:d)}function h(a){var b=a.split(":"),c=0;return 3===b.length?(c+=60*Number(b[0])*60,c+=60*Number(b[1]),c+=Number(b[2])):2===b.length&&(c+=60*Number(b[0]),c+=Number(b[1])),Number(c)}function i(a,c,d){var e,f,g,h,i,j,k=!1,l=!1,m=!1,n="",r=!1,s=!1,t=!1,u=!1,v=!1,w="",x="",y=Math.abs(a),z=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],A="",B=!1;if(0===a&&null!==q)return q;if(c.indexOf("(")>-1?(k=!0,c=c.slice(1,-1)):c.indexOf("+")>-1&&(l=!0,c=c.replace(/\+/g,"")),c.indexOf("a")>-1&&(r=c.indexOf("aK")>=0,s=c.indexOf("aM")>=0,t=c.indexOf("aB")>=0,u=c.indexOf("aT")>=0,v=r||s||t||u,c.indexOf(" a")>-1?(n=" ",c=c.replace(" a","")):c=c.replace("a",""),y>=Math.pow(10,12)&&!v||u?(n+=o[p].abbreviations.trillion,a/=Math.pow(10,12)):y<Math.pow(10,12)&&y>=Math.pow(10,9)&&!v||t?(n+=o[p].abbreviations.billion,a/=Math.pow(10,9)):y<Math.pow(10,9)&&y>=Math.pow(10,6)&&!v||s?(n+=o[p].abbreviations.million,a/=Math.pow(10,6)):(y<Math.pow(10,6)&&y>=Math.pow(10,3)&&!v||r)&&(n+=o[p].abbreviations.thousand,a/=Math.pow(10,3))),c.indexOf("b")>-1)for(c.indexOf(" b")>-1?(w=" ",c=c.replace(" b","")):c=c.replace("b",""),g=0;g<=z.length;g++)if(e=Math.pow(1024,g),f=Math.pow(1024,g+1),a>=e&&f>a){w+=z[g],e>0&&(a/=e);break}return c.indexOf("o")>-1&&(c.indexOf(" o")>-1?(x=" ",c=c.replace(" o","")):c=c.replace("o",""),x+=o[p].ordinal(a)),c.indexOf("[.]")>-1&&(m=!0,c=c.replace("[.]",".")),h=a.toString().split(".")[0],i=c.split(".")[1],j=c.indexOf(","),i?(i.indexOf("[")>-1?(i=i.replace("]",""),i=i.split("["),A=b(a,i[0].length+i[1].length,d,i[1].length)):A=b(a,i.length,d),h=A.split(".")[0],A=A.split(".")[1].length?o[p].delimiters.decimal+A.split(".")[1]:"",m&&0===Number(A.slice(1))&&(A="")):h=b(a,null,d),h.indexOf("-")>-1&&(h=h.slice(1),B=!0),j>-1&&(h=h.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[p].delimiters.thousands)),0===c.indexOf(".")&&(h=""),(k&&B?"(":"")+(!k&&B?"-":"")+(!B&&l?"+":"")+h+A+(x?x:"")+(n?n:"")+(w?w:"")+(k&&B?")":"")}function j(a,b){o[a]=b}function k(a){var b=a.toString().split(".");return b.length<2?1:Math.pow(10,b[1].length)}function l(){var a=Array.prototype.slice.call(arguments);return a.reduce(function(a,b){var c=k(a),d=k(b);return c>d?c:d},-1/0)}var m,n="1.5.3",o={},p="en",q=null,r="0,0",s="undefined"!=typeof module&&module.exports;m=function(b){return m.isNumeral(b)?b=b.value():0===b||"undefined"==typeof b?b=0:Number(b)||(b=m.fn.unformat(b)),new a(Number(b))},m.version=n,m.isNumeral=function(b){return b instanceof a},m.language=function(a,b){if(!a)return p;if(a&&!b){if(!o[a])throw new Error("Unknown language : "+a);p=a}return(b||!o[a])&&j(a,b),m},m.languageData=function(a){if(!a)return o[p];if(!o[a])throw new Error("Unknown language : "+a);return o[a]},m.language("en",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(a){var b=a%10;return 1===~~(a%100/10)?"th":1===b?"st":2===b?"nd":3===b?"rd":"th"},currency:{symbol:"$"}}),m.zeroFormat=function(a){q="string"==typeof a?a:null},m.defaultFormat=function(a){r="string"==typeof a?a:"0.0"},"function"!=typeof Array.prototype.reduce&&(Array.prototype.reduce=function(a,b){"use strict";if(null===this||"undefined"==typeof this)throw new TypeError("Array.prototype.reduce called on null or undefined");if("function"!=typeof a)throw new TypeError(a+" is not a function");var c,d,e=this.length>>>0,f=!1;for(1<arguments.length&&(d=b,f=!0),c=0;e>c;++c)this.hasOwnProperty(c)&&(f?d=a(d,this[c],c,this):(d=this[c],f=!0));if(!f)throw new TypeError("Reduce of empty array with no initial value");return d}),m.fn=a.prototype={clone:function(){return m(this)},format:function(a,b){return c(this,a?a:r,void 0!==b?b:Math.round)},unformat:function(a){return"[object Number]"===Object.prototype.toString.call(a)?a:d(this,a?a:r)},value:function(){return this._value},valueOf:function(){return this._value},set:function(a){return this._value=Number(a),this},add:function(a){function b(a,b){return a+c*b}var c=l.call(null,this._value,a);return this._value=[this._value,a].reduce(b,0)/c,this},subtract:function(a){function b(a,b){return a-c*b}var c=l.call(null,this._value,a);return this._value=[a].reduce(b,this._value*c)/c,this},multiply:function(a){function b(a,b){var c=l(a,b);return a*c*b*c/(c*c)}return this._value=[this._value,a].reduce(b,1),this},divide:function(a){function b(a,b){var c=l(a,b);return a*c/(b*c)}return this._value=[this._value,a].reduce(b),this},difference:function(a){return Math.abs(m(this._value).subtract(a).value())}},s&&(module.exports=m),"undefined"==typeof ender&&(this.numeral=m),"function"==typeof define&&define.amd&&define([],function(){return m})}.call(this);