# Copyright (C) 2010 Linaro Limited
#
# Author: Zygmunt Krynicki <zygmunt.krynicki@linaro.org>
#
# This file is part of django-reports.
#
# django-reports is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License version 3
# as published by the Free Software Foundation
#
# django-reports is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with django-reports.  If not, see <http://www.gnu.org/licenses/>.

from django.conf import settings


# Specify all installed reports (one class per report). Defaults to the
# demo report to make people realize there is a setting that configures
# this. Each element should be a fully-qualified report class
INSTALLED_REPORTS = getattr(settings, "INSTALLED_REPORTS",
                            ["django_reports.reports.DemoReport"])


# Specify all installed data sources (one class per data source).
# Defaults to demo data source to make people realize there is a
# settings that configures this. Each element should be a
# fully-qualified data source class.
INSTALLED_DATA_SOURCES = getattr(settings, "INSTALLED_DATA_SOURCES",
                            ["django_reports.data_sources.DemoDataSource"])

