# Copyright (C) 2010 Linaro Limited
#
# Author: Zygmunt Krynicki <zygmunt.krynicki@linaro.org>
#
# This file is part of django-reports.
#
# django-reports is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License version 3
# as published by the Free Software Foundation
#
# django-reports is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with django-reports.  If not, see <http://www.gnu.org/licenses/>.

from django.conf.urls.defaults import patterns, url

urlpatterns = patterns('django_reports.views',
    url(r'^$', 'report_list'),
    url(r'^(?P<report_id>\d+)/$', 'display_report'),
    url(r'^(?P<report_id>\d+)/delete/$', 'delete_report'),
    url(r'^(?P<report_id>\d+)/update-settings/$', 'update_report_settings'),
    url(r'^(?P<report_id>\d+)/update-metadata/$', 'update_report_metadata'),
    url(r'^new/$', 'new_report'),
)
