#!/usr/bin/env python
# Copyright (C) 2010 Linaro Limited
#
# Author: Zygmunt Krynicki <zygmunt.krynicki@linaro.org>
#
# This file is part of django-reports.
#
# django-reports is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation
#
# django-reports is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with django-reports.  If not, see <http://www.gnu.org/licenses/>.

from setuptools import setup

setup(
    name = 'django-reports',
    version = "0.2",
    author = "Zygmunt Krynicki",
    author_email = "zygmunt.krynicki@linaro.org",
    description = "Django framework for writing reporting tools",
    url = 'https://launchpad.net/django-reports',
    test_suite = 'test_project.tests.run_tests',
    license='LGPLv3',
    keywords = ['django', 'reports',],
    classifiers = [
        "Development Status :: 3 - Alpha",
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        "License :: OSI Approved :: GNU Library or Lesser General Public License (LGPL)",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2.6",
    ],
    zip_safe = True,
    packages = [
        'django_reports',
        'django_reports.data_sources',
        'django_reports.reports',
    ],
    install_requires=[
        'Django >= 1.0',
        'linaro-django-jsonfield >= 0.2',
        'django-restricted-resource >= 0.2',
    ],
)
