import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name="django-request-profiler",
    version="0.7.1",
    packages=[
        'request_profiler',
        'request_profiler.migrations',
        'request_profiler.south_migrations'
    ],
    install_requires=[],
    include_package_data=True,
    description='Django Request Profiler - a simple profiler for timing HTTP requests.',
    long_description=README,
    url='https://github.com/yunojuno/django-request-profiler',
    author='Chris Wood',
    author_email='chris.wood@yunojuno.com',
    maintainer='Hugo Rodger-Brown',
    maintainer_email='hugo@yunojuno.com',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
