import os
from setuptools import setup

with open(os.path.join(os.path.dirname(__file__), 'README.md')) as readme:
    README = readme.read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

install_requires = [
    'django>=1.7',
    'djangorestframework==3.0.1',
    'pycrypto',
    ]

setup(
    name='django-rest-encrypted-lookup',
    version='0.8',
    packages=['rest_framework_encrypted_lookup'],
    include_package_data=True,
    license='GNU General Public License v3 (GPLv3)',
    description='Replace Rest Framework\'s IntegerField pk or id lookups with encrypted strings.',
    long_description=README,
    url='http://www.sigmaeducation.com/',
    author='Sigma Education',
    author_email='dev@sigmaeducation.com',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.4',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
