from django.conf import settings
from boto.ses import SESConnection

__all__ = ('AWS_SES_ACCESS_KEY_ID', 'AWS_SES_SECRET_ACCESS_KEY',
        'AWS_SES_REGION_NAME', 'AWS_SES_REGION_ENDPOINT',
        'AWS_SES_AUTO_THROTTLE', 'AWS_SES_RETURN_PATH')

AWS_SES_ACCESS_KEY_ID = getattr(settings, 'AWS_SES_ACCESS_KEY_ID',
    getattr(settings, 'AWS_ACCESS_KEY_ID', None))

AWS_SES_SECRET_ACCESS_KEY = getattr(settings, 'AWS_SES_SECRET_ACCESS_KEY',
    getattr(settings, 'AWS_SECRET_ACCESS_KEY', None))

AWS_SES_REGION_NAME = getattr(settings, 'AWS_SES_REGION_NAME',
    SESConnection.DefaultRegionName),
AWS_SES_REGION_ENDPOINT = getattr(settings, 'AWS_SES_REGION_ENDPOINT',
    SESConnection.DefaultRegionEndpoint)

AWS_SES_AUTO_THROTTLE = getattr(settings, 'AWS_SES_AUTO_THROTTLE', 0.5)
AWS_SES_RETURN_PATH = getattr(settings, 'AWS_SES_RETURN_PATH', None)
