# -*- coding: utf-8 -*-
from setuptools import setup, find_packages


DESCRIPTION = "A Django email backend for Amazon's Simple Email Service"

LONG_DESCRIPTION = None
try:
    LONG_DESCRIPTION = open('README.rst').read()
except:
    pass

CLASSIFIERS = [
    'Development Status :: 4 - Beta',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: MIT License',
    'Operating System :: OS Independent',
    'Programming Language :: Python',
    'Programming Language :: Python :: 2.6',
    'Programming Language :: Python :: 2.7',
    'Programming Language :: Python :: 3.2',
    'Programming Language :: Python :: 3.3',
    'Programming Language :: Python :: 3.4',
    'Topic :: Software Development :: Libraries :: Python Modules',
    'Framework :: Django',
]

setup(
    name='django-ses-backend',
    version='0.1.1',  # When changing this, remember to change it in __init__.py
    description=DESCRIPTION,
    long_description=LONG_DESCRIPTION,
    packages=['django_ses_backend'],
    author='Harry Marr',
    author_email='harry@hmarr.com',
    maintainer='Piotr Buliński',
    maintainer_email='piotr@bulinski.pl',
    url='https://github.com/piotrbulinski/django-ses-backend/',
    download_url='https://github.com/piotrbulinski/django-ses-backend/archive/master.zip',
    license='MIT',
    platforms=['Posix', 'MacOS X', 'Windows'],
    classifiers=CLASSIFIERS,
    install_requires=[
        'Django >= 1.5',
        'boto >= 2.32.0',
    ],
)
