# -*- coding: utf-8 -*-

from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from .formfields import MultiplePhoneFormField


class MultiplePhoneField(models.CharField):

    def __init__(self, *args, **kwargs):
        kwargs.update({'max_length': 255})
        super(MultiplePhoneField, self).__init__(*args, **kwargs)

    def formfield(self, **kwargs):
        defaults = {
            'form_class': MultiplePhoneFormField,
            'help_text': _("you can enter multiple phone numbers separated by a comma"),
        }
        defaults.update(kwargs)
        return super(MultiplePhoneField, self).formfield(**defaults)


if 'south' in settings.INSTALLED_APPS:
    from south.modelsinspector import add_introspection_rules
    add_introspection_rules([], [
        r"^phonenumber_field\.fields\.MultiplePhoneField"])
