# -*- coding: utf-8 -*-

import re

from django import forms
from django.utils.translation import ugettext_lazy as _

from .utils import format_phones

regex = re.compile(r'[\s +.()\-]')


class ValueFromDatadict(unicode):
    pass


class MultiplePhoneFormField(forms.CharField):
    default_error_messages = {
        'invalid': _("Enter a valid phone number, e.g. 8 495 606-36-02"),
        'failure': _("This doesn't look like a valid phone number"),
    }

    def clean(self, phones):
        phones = super(MultiplePhoneFormField, self).clean(phones)
        cleaned_phones = []
        for phone in phones.split(','):
            # Replace +7 with 8 if phone length is 11 digits
            if len(regex.sub('', phone)) == 11 and phone.startswith('+7'):
                phone = phone.replace('+7', '8', 1)

            phone = regex.sub('', phone)
            if not phone:
                continue
            if not phone.isdigit():
                raise forms.ValidationError(self.error_messages['invalid'])
            if len(phone) == 10:
                phone = '8' + phone  # prepend 8 for 10 digits numbers
            if len(phone) >= 5 and len(phone) <= 14:
                pass  # don't know what to do with this...
            else:
                raise forms.ValidationError(self.error_messages['failure'])
            cleaned_phones.append(phone)
        return ' '.join(cleaned_phones)

    def bound_data(self, data, initial):
        return ValueFromDatadict(data)

    def prepare_value(self, value):
        if not value or isinstance(value, ValueFromDatadict):
            return value
        return ', '.join(format_phones(value, code=None))
