# -*- coding: utf-8 -*-

from django import template
from django.utils.safestring import mark_safe

from ..utils import format_phones as pformat

register = template.Library()


@register.filter
def format_phones(phones, code=None):
    return mark_safe(u', '.join(
        [u'<nobr>%s</nobr>' % p for p in pformat(phones, code)]))
