# -*- coding: utf-8 -*-


def format_phones(phones, code=None):
    for phone in filter(None, phones.split(' ')):
        if len(phone) == 5:
            # for example 1-23-45
            phone = u'%s-%s-%s' % (phone[0], phone[1:3], phone[3:5])
        elif len(phone) == 6:
            # for example 22-33-44
            phone = u'%s-%s-%s' % (phone[0:2], phone[2:4], phone[4:6])
        elif len(phone) == 7:
            # for example 123-45-67
            phone = u'%s-%s-%s' % (phone[0:3], phone[3:5], phone[5:7])
        elif len(phone) > 7 and len(phone) < 11:
            pass  # don't know what to do with this
        elif len(phone) > 14:
            pass  # something wrong, don't know what to do...
        else:
            code, phone = phone[:-10], phone[-10:]
            # for example 8 968 127-31-32 or 44 20 7834 6600
            phone = u'%s %s %s-%s-%s' % (
                code, phone[0:3], phone[3:6], phone[6:8], phone[8:10])
        yield phone
