#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.txt')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name = 'django-simple-breadcrumbs',
    version = '0.2',
    packages = ['breadcrumbs'],
    include_package_data = True,
    license = 'BSD License',
    description = 'A simple Django app to use breadcrumbs-based navigation',
    long_description = README,
    url = 'https://bitbucket.org/Mathiasdm/django-simple-breadcrumbs',
    author = 'Andriy Drozdyuk, Mathias De Maré',
    #To avoid Andriy being bothered with mails: use my mail address
    author_email = 'mathias.demare+breadcrumbs@gmail.com',
    classifiers = [
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)
