from django.shortcuts import render_to_response, get_object_or_404
from django.http import HttpResponse, HttpResponseRedirect
from django.template import RequestContext
from django.core.urlresolvers import reverse

from django.db.models import Q
from django.contrib.auth.decorators import login_required

from models import Article, Tag

def list_baseview(request, article_qs, template="simpleblog/list_view.html"):
    return render_to_response(template,
        {"article_qs":article_qs, },
        context_instance=RequestContext(request))

def home_view(request):
    qs = Article.objects.order_by("-pk")
    return list_baseview(request, qs)

def tag_view(request, url_key):
    qs = Article.objects.filter(tags__url_key=url_key).order_by("-pk")
    return list_baseview(request, qs)

def article_view(request, url_key, template="simpleblog/article.html"):
    article = get_object_or_404(Article, url_key=url_key)
    return render_to_response(template,
        {"article":article, },
        context_instance=RequestContext(request))