from django.db import models
from django.template.defaultfilters import slugify

class Tag(models.Model):
    name = models.CharField(max_length=128)
    url_key = models.SlugField(max_length=128, blank=True)

    def get_size(self):
        return 15+self.article_set.all().count()*5

    def __unicode__(self):
        return u"%s ~%i"%(self.name, self.pk)

    def save(self):
        if not self.pk:
            self.url_key = slugify(self.name)
        return super(Tag, self).save()

class Article(models.Model):
    title = models.CharField(max_length=128)
    url_key = models.SlugField(max_length=128, blank=True)
    created_at = models.DateField(auto_now_add=True)
    tags = models.ManyToManyField(Tag)
    img = models.ImageField(null=True, blank=True, upload_to="img")
    description = models.TextField()
    content = models.TextField()

    def __unicode__(self):
        return u"%s ~%i"%(self.title, self.pk)

    def save(self):
        if not self.pk:
            self.url_key = slugify(self.title)
        return super(Article, self).save()

    def get_comments(self):
        return self.comment_set.order_by("pk")

class Comment(models.Model):
    article = models.ForeignKey(Article)
    created_at = models.DateField(auto_now_add=True)

    author_name = models.CharField(max_length=64)
    author_email = models.CharField(max_length=64)

    title = models.CharField(max_length=255)
    text = models.TextField(null=True, blank=True)

    def __unicode__(self):
        return u"%s %i %s" % (self.title[:30], self.pk, self.article.title)
    