from django.shortcuts import render_to_response, get_object_or_404
from django.http import HttpResponse, HttpResponseRedirect
from django.template import RequestContext
from django.core.urlresolvers import reverse

from django.db.models import Q
from django.contrib.auth.decorators import login_required

from models import Article, Tag
from forms import CommentForm

def list_baseview(request, article_qs, template="simpleblog/list_view.html"):
    try: page = int(request.GET["page"])
    except: page = 0
    try: limit = int(request.GET["limit"])
    except: limit = 10

    pagination = range((article_qs.count()/limit)+1)

    article_qs = article_qs[page*limit:page*limit+limit]

    return render_to_response(template,
        {"article_qs":article_qs, "pagination": pagination, "limit": limit, "actual_page": page, },
        context_instance=RequestContext(request))

def home_view(request):
    qs = Article.objects.order_by("-pk")
    return list_baseview(request, qs)

def tag_view(request, url_key):
    qs = Article.objects.filter(tags__url_key=url_key).order_by("-pk")
    return list_baseview(request, qs)

def article_view(request, url_key, template="simpleblog/article.html"):
    article = get_object_or_404(Article, url_key=url_key)
    comment_form = CommentForm(request.POST or None)
    if comment_form.is_valid():
        comment = comment_form.save(commit=False)
        comment.article = article
        comment.save()
        return HttpResponseRedirect(reverse("simpleblog.article", args=[article.url_key], ))

    return render_to_response(template,
        {
            "article":article,
            "comment_form": comment_form,
        },
        context_instance=RequestContext(request))