from django.contrib import admin

from models import Article, Tag, Comment, Link, Gallery, Image

class ImageInline(admin.TabularInline):
    model = Image
    extra = 0

class GalleryAdmin(admin.ModelAdmin):
    inlines = (ImageInline, )

admin.site.register(Article)
admin.site.register(Tag)
admin.site.register(Comment)
admin.site.register(Link)
admin.site.register(Gallery, GalleryAdmin)
admin.site.register(Image)