import os
from setuptools import setup
from siteblocks import VERSION


f = open(os.path.join(os.path.dirname(__file__), 'README.rst'))
readme = f.read()
f.close()

setup(
    name='django-siteblocks',
    version='.'.join(map(str, VERSION)),
    url='http://github.com/idlesign/django-siteblocks',

    description='Reusable application for Django introducing URL-dependent static and dynamic data blocks',
    long_description=readme,
    license='BSD 3-Clause License',

    author="Igor 'idle sign' Starikov",
    author_email='idlesign@yandex.ru',

    packages=['siteblocks'],
    include_package_data=True,
    zip_safe=False,

    classifiers=[
	    'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'License :: OSI Approved :: BSD License'
    ],
)
