import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-skd',
    version='2.0-rc4',
    packages=['skd'],
    include_package_data=True,
    license='BSD 2-clause License',  # example license
    description='[s]IMPLE [k]EY [d]ISTRIBUTION - skd is a tool for the simple distribution of SSH-keys in a growing environment.',
    long_description=README,
    url='http://dploeger.github.io/skd/',
    author='Dennis Ploeger',
    author_email='develop@dieploegers.de',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: BSD License', # example license
        'Operating System :: POSIX',
        'Operating System :: MacOS :: MacOS X',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Security',
        'Development Status :: 5 - Production/Stable',
    ],
    zip_safe = False,
    install_requires = [
        "Django >= 1.5",
        "paramiko >= 1.12.0",
        "django-bootstrap3 >= 1.1.0"
    ]
)
