"""
Key generation tool
"""
import StringIO

from django.utils.translation import ugettext as _
from paramiko import RSAKey, DSSKey


def keygen(keyname, keytype, bits, passphrase):

    retval = {"generation_messages": "", "generation_status": "success"}

    if keytype not in ['rsa', 'dsa']:
        retval["generation_messages"] = _("Invalid keytype: %s" % keytype)
        retval["generation_status"] = "error"

    if bits not in [1024, 2048, 3072, 4096]:
        retval["generation_messages"] = \
            _("Invalid number of bits: %s" % bits)
        retval["generation_status"] = "error"

    if keytype == "dsa" and bits != 1024:
        retval["generation_messages"] = _("DSA only supports 1024 bits.")
        retval["generation_status"] = "error"

    if retval["generation_status"] == "success":
        if keytype == "rsa":

            key = RSAKey.generate(bits=bits)
            typestring = "ssh-rss "

        else:

            key = DSSKey.generate(bits=bits)
            typestring = "ssh-dss "

        keystring = "%s %s %s" % (
            typestring,
            key.get_base64(),
            keyname
        )

        retval["public_key"] = keystring

        tmp = StringIO.StringIO()

        if passphrase == "":
            passphrase = None

        key.write_private_key(tmp, passphrase)

        retval["private_key"] = tmp.getvalue()

    return retval