"""
Views for actionlog-handling
"""

from datetime import datetime

from django.views.generic import TemplateView
from django.template.context import RequestContext
from django.shortcuts import render_to_response, redirect
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger
from ..models import Configuration, ActionLog


class ListActionLogView(TemplateView):
    """ List the Actionlog
    """

    def get(self, request, *args, **kwargs):

        actions_list = ActionLog.objects.order_by("-timestamp")

        if Configuration.objects.filter(key="actions_max").count() == 0:
            actions_max = 25

        else:
            actions_max = Configuration.objects.get(key="actions_max").value

        paginator = Paginator(actions_list, actions_max)

        page = request.GET.get("page")

        try:
            actions = paginator.page(page)

        except PageNotAnInteger:
            actions = paginator.page(1)

        except EmptyPage:
            actions = paginator.page(paginator.num_pages)

        return render_to_response(
            "skd/actionslist.html",
            RequestContext(
                request,
                {
                    "actions": actions
                }
            )
        )


class DeleteActionLogView(TemplateView):
    """ Clear the actionlog
    """

    def get(self, request, *args, **kwargs):

        # Clean actionlog

        ActionLog.objects.all().delete()

        # Add note about that

        ActionLog(
            timestamp=datetime.now(),
            user=request.user,
            action="DELETE_ACTIONLOG"
        ).save()

        return redirect("actionlog_list")
