"""
skd Template tools
"""

from django import template
from django.utils.translation import ugettext as _

register = template.Library()

@register.simple_tag
def object_table(template_object):

    output = ['<table class="table">']

    for field in template_object._meta.fields:
        if field.name != 'id':
            output.append('<tr>')
            output.append('<th>%s</th>' % _(field.name))
            output.append('<td>%s</td>' % getattr(template_object, field.name))
            output.append('</tr>')

    output.append('</table>')

    return "\n".join(output)