from django.conf.urls import patterns, include, url

from django.contrib import admin
from django.contrib.auth.decorators import login_required, \
    permission_required, user_passes_test

from django.views.generic.base import TemplateView
from django.views.generic.list import ListView
from models import User, Host, UserGroup, HostGroup, UserMap
from views import *

urlpatterns = patterns(

    'views',

    # Home page

    url(
        r"^$",
        login_required(
            TemplateView.as_view(
                template_name="skd/home.html"
            )
        ),
        name="home"
    ),

    # SKD setup

    url(
        r"^setup$",
        user_passes_test(lambda u: u.is_staff)(
            SetupView.as_view()
        ),
        name="setup"
    ),

    # Action Log

    url(
        r"^actionlog$",
        permission_required("skd.list_actionlog")(
            ListActionLogView.as_view()
        ),
        name="actionlog_list"
    ),

    url(
        r"^actionlog/delete",
        permission_required("skd.delete_actionlog")(
            DeleteActionLogView.as_view()
        ),
        name="actionlog_delete"
    ),

    # User management

    url(
        r"^users/list$",
        permission_required("skd.list_users")(
            ListView.as_view(
                queryset=User.objects.all(),
                context_object_name="users"
            )
        ),
        name="users_list"
    ),

    url(
        r"^users/create",
        permission_required("skd.add_user")(
            UserCreateView.as_view()
        ),
        name="users_create"
    ),

    url(
        r"^users/edit/(?P<pk>.*)$",
        permission_required("skd.change_user")(
            UserUpdateView.as_view()
        ),
        name="users_edit"
    ),

    url(
        r'^users/delete/(?P<pk>.*)$',
        permission_required("skd.delete_user")(
            UserDeleteView.as_view()
        ),
        name='users_delete'
    ),

    url(
        r"^users/keys/(?P<user>.*)/list$",
        permission_required("skd.list_users_keys")(
            UserKeyListView.as_view()
        ),
        name="users_keys_list"
    ),

    url(
        r"^users/keys/(?P<user>.*)/create$",
        permission_required("skd.add_key")(
            UserKeyCreateView.as_view()
        ),
        name="users_keys_create"
    ),

    url(
        r"^users/keys/(?P<user>.*)/generate$",
        permission_required("skd.add_key")(
            UserKeyGenerateView.as_view()
        ),
        name="users_keys_generate"
    ),

    url(
        r"^users/keys/(?P<user>.*)/edit/(?P<pk>.*)$",
        permission_required("skd.change_key")(
            UserKeyUpdateView.as_view()
        ),
        name="users_keys_edit"
    ),

    url(
        r"^users/keys/(?P<user>.*)/delete/(?P<pk>.*)$",
        permission_required("skd.delete_key")(
            UserKeyDeleteView.as_view()
        ),
        name="users_keys_delete"
    ),

    url(
        r"^users/maps/(?P<user>.*)/list$",
        permission_required("skd.list_usermaps")(
            UserNameMapListView.as_view()
        ),
        name="users_map_list"
    ),

    url(
        r"^users/maps/(?P<user>.*)/create",
        permission_required("skd.add_usermap")(
            UserNameMapCreateView.as_view()
        ),
        name="users_map_create"
    ),

    url(
        r"^users/maps/(?P<user>.*)/edit/(?P<pk>.*)$",
        permission_required("skd.change_usermap")(
            UserNameMapUpdateView.as_view()
        ),
        name="users_map_edit"
    ),

    url(
        r"^users/maps/(?P<user>.*)/delete/(?P<pk>.*)$",
        permission_required("skd.delete_usermap")(
            UserNameMapDeleteView.as_view()
        ),
        name="users_map_delete"
    ),

    url(
        r"^users/groups/(?P<user>.*)/list$",
        permission_required("skd.list_users_in_usergroups")(
            UserGroupListView.as_view()
        ),
        name="users_groups_list"
    ),

    url(
        r"^users/groups/(?P<user>.*)/assign$",
        permission_required("skd.add_useringroup")(
            UserGroupAssignView.as_view()
        ),
        name="users_groups_assign"
    ),

    url(
        r"^users/groups/(?P<user>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_useringroup")(
            UserGroupUnassignView.as_view()
        ),
        name="users_groups_unassign"
    ),

    # Usergroup management

    url(
        r"^usergroups/list$",
        permission_required("skd.list_usergroups")(
            ListView.as_view(
                queryset=UserGroup.objects.all(),
                context_object_name="usergroups"
            )
        ),
        name="usergroups_list"
    ),

    url(
        r"^usergroups/create$",
        permission_required("skd.add_usergroup")(
            UserGroupCreateView.as_view()
        ),
        name="usergroups_create"
    ),

    url(
        r"^usergroups/edit/(?P<pk>.*)$",
        permission_required("skd.change_usergroup")(
            UserGroupUpdateView.as_view()
        ),
        name="usergroups_edit"
    ),

    url(
        r"^usergroups/delete/(?P<pk>.*)$",
        permission_required("skd.delete_usergroup")(
            UserGroupDeleteView.as_view()
        ),
        name="usergroups_delete"
    ),

    url(
        r"^usergroups/users/(?P<usergroup>.*)/list$",
        permission_required("skd.list_users_in_usergroups")(
            UserGroupUserListView.as_view()
        ),
        name="usergroups_users_list"
    ),

    url(
        r"^usergroups/users/(?P<usergroup>.*)/assign$",
        permission_required("skd.add_useringroup")(
            UserGroupUserAssignView.as_view()
        ),
        name="usergroups_users_assign"
    ),

    url(
        r"^usergroups/users/(?P<usergroup>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_useringroup")(
            UserGroupUserUnassignView.as_view()
        ),
        name="usergroups_users_unassign"
    ),

    url(
        r"^usergroups/hostgroups/(?P<usergroup>.*)/list$",
        permission_required("skd.list_usergroups_in_hostgroups")(
            UserGroupHostGroupListView.as_view()
        ),
        name="usergroups_hostgroups_list"
    ),

    url(
        r"^usergroups/hostgroups/(?P<usergroup>.*)/assign$",
        permission_required("skd.add_usergroupinhostgroup")(
            UserGroupHostGroupAssignView.as_view()
        ),
        name="usergroups_hostgroups_assign"
    ),

    url(
        r"^usergroups/hostgroups/(?P<usergroup>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_usergroupinhostgroup")(
            UserGroupHostGroupUnassignView.as_view()
        ),
        name="usergroups_hostgroups_unassign"
    ),

    # Host management

    url(
        r"^hosts/list$",
        permission_required("skd.list_hosts")(
            ListView.as_view(
                queryset=Host.objects.all(),
                context_object_name="hosts"
            )
        ),
        name="hosts_list"
    ),

    url(
        r"^hosts/create$",
        permission_required("skd.add_host")(
            HostCreateView.as_view()
        ),
        name="hosts_create"
    ),

    url(
        r"^hosts/edit/(?P<pk>.*)$",
        permission_required("skd.change_host")(
            HostUpdateView.as_view()
        ),
        name="hosts_edit"
    ),

    url(
        r"^hosts/delete/(?P<pk>.*)$",
        permission_required("skd.delete_host")(
            HostDeleteView.as_view()
        ),
        name="hosts_delete"
    ),

    url(
        r"^hosts/setup/(?P<host>.*)$",
        permission_required("setup_host")(
            HostSetupView.as_view()
        ),
        name="hosts_setup"
    ),

    url(
        r"^hosts/groups/(?P<host>.*)/list$",
        permission_required("skd.list_hosts_in_groups")(
            HostGroupListView.as_view()
        ),
        name="hosts_groups_list"
    ),

    url(
        r"^hosts/groups/(?P<host>.*)/assign$",
        permission_required("skd.add_hostingroup")(
            HostGroupAssignView.as_view()
        ),
        name="hosts_groups_assign"
    ),

    url(
        r"^hosts/groups/(?P<host>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_hostingroup")(
            HostGroupUnassignView.as_view()
        ),
        name="hosts_groups_unassign"
    ),

    # Hostgroup management

    url(
        r"^hostgroups/list$",
        permission_required("skd.list_hostgroups")(
            ListView.as_view(
                queryset=HostGroup.objects.all(),
                context_object_name="hostgroups"
            )
        ),
        name="hostgroups_list"
    ),

    url(
        r"^hostgroups/create$",
        permission_required("skd.add_hostgroup")(
            HostGroupCreateView.as_view()
        ),
        name="hostgroups_create"
    ),

    url(
        r"^hostgroups/edit/(?P<pk>.*)$",
        permission_required("skd.change_host")(
            HostGroupUpdateView.as_view()
        ),
        name="hostgroups_edit"
    ),

    url(
        r"^hostgroups/delete/(?P<pk>.*)$",
        permission_required("skd.delete_host")(
            HostGroupDeleteView.as_view()
        ),
        name="hostgroups_delete"
    ),

    url(
        r"^hostgroups/hosts/(?P<hostgroup>.*)/list$",
        permission_required("skd.list_hosts_in_hostgroups")(
            HostGroupHostListView.as_view()
        ),
        name="hostgroups_hosts_list"
    ),

    url(
        r"^hostgroups/hosts/(?P<hostgroup>.*)/assign$",
        permission_required("skd.add_hostingroup")(
            HostGroupHostAssignView.as_view()
        ),
        name="hostgroups_hosts_assign"
    ),

    url(
        r"^hostgroups/hosts/(?P<hostgroup>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_hostingroup")(
            HostGroupHostUnassignView.as_view()
        ),
        name="hostgroups_hosts_unassign"
    ),

    url(
        r"^hostgroups/usergroups/(?P<hostgroup>.*)/list$",
        permission_required("skd.list_usergroups_in_hostgroups")(
            HostGroupUserGroupListView.as_view()
        ),
        name="hostgroups_usergroups_list"
    ),

    url(
        r"^hostgroups/usergroups/(?P<hostgroup>.*)/assign$",
        permission_required("skd.add_usergroupinhostgroup")(
            HostGroupUserGroupAssignView.as_view()
        ),
        name="hostgroups_usergroups_assign"
    ),

    url(
        r"^hostgroups/usergroups/(?P<hostgroup>.*)/unassign/(?P<pk>.*)$",
        permission_required("skd.delete_usergroupinhostgroup")(
            HostGroupUserGroupUnassignView.as_view()
        ),
        name="hostgroups_usergroups_unassign"
    ),

    url(
        r"^apply$",
        ApplyView.as_view(),
        name="apply"
    ),

)

urlpatterns += patterns('',

    url(
        r"^logout$",
        "django.contrib.auth.views.logout",
        {
            "next_page" : "/"
        },
        name="logout"
    ),

    url(
        r"^login$",
        "django.contrib.auth.views.login",
        name="login"
    ),

    url(
        r"^password/change$",
        "django.contrib.auth.views.password_change",
        name="password_change"
    ),

    url(
        r"^password/change/done$",
        "django.contrib.auth.views.password_change_done",
        name="password_change_done"
    ),

    url(
        r'^admin/',
        include(admin.site.urls)
    )

)