""" SKD-Views
"""

from django.views.generic import ListView
from skd.models import Configuration


class SkdListView(ListView):
    """SKD-specific List view

    Creates a ListView, but with benefits:

    Row-specific actions, a default output, when no rows are returned from
        the queryset and a list of basic actions

    This relies on three additional template tags inside skd_listview (see
    there for more information).
    """

    template_name = "skd/listbase.html"

    # Current category for menu
    current_category = ""

    # Text for empty lists
    no_rows = ""

    # Column-Headers
    list_columns = []

    # Context of this list
    list_context = ""

    # Paginator
    paginate_by = 10

    def __init__(self):

        super(SkdListView, self).__init__()

        if Configuration.objects.filter(key="pagination_max").exists():

            self.paginate_by = Configuration.objects.get(
                key="pagination_max"
            ).value

    def get_actions(self):
        """Returns an array of dicts with "title" and "url" for the general
        actions under the displayed table"""

        pass

    def get_context_data(self, **kwargs):
        # Call the base implementation first to get a context
        context = super(SkdListView, self).get_context_data(**kwargs)

        context["current_category"] = self.current_category
        context["no_rows"] = self.no_rows
        context["actions"] = self.get_actions()
        context["columns"] = self.list_columns
        context["list_context"] = self.list_context

        return context
