"""
Views for actionlog-handling
"""
from django.contrib import messages

from django.core.urlresolvers import reverse

from django.views.generic import TemplateView
from django.shortcuts import redirect
from skd.models import ActionLog
from skd.views import SkdListView
from django.utils.translation import ugettext_lazy as _


class ListActionLogView(SkdListView):
    """ List the Actionlog
    """

    model = ActionLog
    current_category = "actions"
    no_rows = _("No actions have been logged.")
    list_columns = [
        _("Timestamp"),
        _("User"),
        _("Action")
    ]

    def get_actions(self):

        return [
            {
                "title": _("Delete All"),
                "url": reverse(
                    "actionlog_delete"
                )
            }
        ]


class DeleteActionLogView(TemplateView):
    """ Clear the actionlog
    """

    def get(self, request, *args, **kwargs):

        ActionLog.objects.clean_actionlog(request.user)

        messages.success(
            request,
            _("Actionlog cleared.")
        )

        return redirect("actionlog_list")
