""" Apply-Views
"""

from datetime import datetime
from django.contrib import messages

from django.views.generic import TemplateView

from skd.models import ApplyLog


class ApplyView(TemplateView):
    """
    Applies the current configuration and delivers the authorized_keys-files.

    **Template:**

    :template:`skd/apply.html`

    """

    template_name = "skd/apply.html"

    mode = None

    affected_hosts = set()

    ssh_messages = []

    apply_status = None

    def get_context_data(self, **kwargs):
        context = super(ApplyView, self).get_context_data(**kwargs)

        context["mode"] = self.mode

        if not self.mode:
            context["affected_hosts"] = ApplyLog.objects.all()

        if self.apply_status:
            context["apply_status"] = self.apply_status

        return context

    def post(self, request, *args, **kwargs):

        if "do_apply" in request.POST:

            # We should apply the changes.

            self.mode = "applied"

            apply_result = ApplyLog.objects.apply_config(
                request.user,
                datetime.now(),
                request.POST.get("passphrase", "")
            )

            self.apply_status = apply_result['status']

            for ssh_message in apply_result["ssh_messages"]:

                if self.apply_status == "error":

                    messages.error(request, ssh_message)

                elif self.apply_status == "success":

                    messages.success(request, ssh_message)

        return self.get(request, *args, **kwargs)
