"""Home-Page"""
from django.contrib.auth.models import Group
from django.views.generic import TemplateView
from skd.models import Configuration
from django.utils.translation import ugettext_lazy as _


class HomeView(TemplateView):

    """
    Applies the current configuration and delivers the authorized_keys-files.

    **Template:**

    :template:`skd/home.html`

    """

    template_name = "skd/home.html"

    def get_context_data(self, **kwargs):
        context = super(HomeView, self).get_context_data(**kwargs)

        setup_workflow = []

        if not Configuration.objects.filter(key="sshkey_public"):

            setup_workflow.append(_("You haven't generated a master keypair "
                                    "for skd."))

        if not Group.objects.filter(name__istartswith="skd_").exists():

            setup_workflow.append(_("You haven't set up the skd "
                                    "administration groups."))

        context['setup_workflow'] = setup_workflow

        return context