#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""Setup script for django-slow-log."""

from setuptools import setup, find_packages
import sys, os

try:
    import django_slow_log
    version = '.'.join(map(str, django_slow_log.VERSION))
except:
    version = '0.1'

# some trove classifiers:

# License :: OSI Approved :: MIT License
# Intended Audience :: Developers
# Operating System :: POSIX

setup(
    name='django-slow-log',
    version=version,
    description="slow request log for django",
    long_description=open('README.rst').read(),
    # Get strings from http://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 4 - Beta',
        'Framework :: Django',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: Log Analysis',
        'License :: OSI Approved :: MIT License',
        'Intended Audience :: Developers',
        'Operating System :: POSIX',
    ],
    keywords='django profiling slow request',
    author='Jason Moiron',
    author_email='jmoiron@jmoiron.net',
    url='http://github.com/jmoiron/django-slow-log',
    license='MIT',
    packages=find_packages(exclude=['ez_setup', 'examples', 'tests']),
    include_package_data=True,
    test_suite="tests",
    install_requires=[
        'django',
      # -*- Extra requirements: -*-
    ],
    entry_points="""
    # -*- Entry points: -*-
    """,
)
