# -*- coding: utf-8 -*-
import re
from django import template
from django.template.defaultfilters import removetags
import settings


register = template.Library()
url_regex = re.compile(r"((^|\b)www\.([-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]))")
block_char = u'▉'


def is_censored(value):
    """Returns True or False if value contains links."""
    if url_regex.search(value):
        return True
    return False


def repl_blocks(matchobj):
    replace = block_char * len(matchobj.group())
    return replace


def censor(value, replace=None):
    """
    Strips <a> elements, and replace links with blocks or a given strings.

    Accepts a replacement string as an optional parameter. If not specified, it will use the SOPA_REPLACE setting (defaults to 'BLOCKS').

    The special value 'BLOCKS' will replace every char in the link with a black square.
    """
    value = removetags(value, 'a')
    if replace is None:
        replace = settings.SOPA_REPLACE
    if replace == 'BLOCKS':
        return url_regex.sub(repl_blocks, value)
    return url_regex.sub(replace, value)
