from ..sopa.templatetags.sopa import is_censored, censor
import unittest2


class SOPATest(unittest.TestCase):
    def setUp(self):
        self.text = """
        Lorem ipsum www.google.com and <a href="htpp://google.com">link</a>
        """
        self.text2 = """Lorem ipsum dolor sit amet"""

    def test_sopa(self):
        result = is_censored(self.text)
        self.assertTrue(result)

        result = is_censored(self.text2)
        self.assertFalse(result)

        result = censor(self.text)
        self.assertEqual(result, "")

        result = censor(self.text, '<em>redacted</em>')
        self.assertEqual(result, "")

        result = censor(self.text2)
        self.assertEqual(result, self.text2)

        result = censor(self.text2, '<em>redacted</em>')
        self.assertEqual(result, self.text2)

if __name__ == '__main__':
    unittest2.main()
