import os
from setuptools import setup, find_packages

from sopa import VERSION

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()
    
requirements = ['django']

setup(
    name = "django-sopa",
    version = ".".join(map(str, VERSION)),
    description = "A django app for all your censoring needs.",
    long_description = read('README.rst'),
    url = 'https://github.com/fcurella/django-sopa',
    license = 'MIT',
    author = 'Flavio Curella',
    author_email = 'flavio.curella@gmail.com',
    packages = find_packages(exclude=['tests']),
    classifiers = [
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Framework :: Django',
    ],
    install_requires = requirements,
    tests_require = ["unittest2",],
)
