# -*- coding: utf-8 -*-
from templatetags.sopa import is_censored, censor
import settings
import unittest2


class SOPATest(unittest2.TestCase):
    def setUp(self):
        self.text = 'Lorem ipsum www.google.com and <a href="http://google.com">link</a>'
        self.text2 = """Lorem ipsum dolor sit amet"""

    def test_sopa(self):
        result = is_censored(self.text)
        self.assertTrue(result)

        result = is_censored(self.text2)
        self.assertFalse(result)

        result = censor(self.text)
        self.assertEqual(result, u'Lorem ipsum ▉▉▉▉▉▉▉▉▉▉▉▉▉▉ and link')

        result = censor(self.text, '<em>redacted</em>')
        self.assertEqual(result, u'Lorem ipsum <em>redacted</em> and link')

        result = censor(self.text2)
        self.assertEqual(result, self.text2)

        result = censor(self.text2, '<em>redacted</em>')
        self.assertEqual(result, self.text2)

        settings.SOPA_REPLACE_MODE = 'ALL'
        result = censor(self.text)
        self.assertEqual(result, u'▉▉▉▉▉ ▉▉▉▉▉ ▉▉▉▉▉▉▉▉▉▉▉▉▉▉ ▉▉▉ ▉▉▉▉')

        settings.SOPA_REPLACE = '<redacted>'
        result = censor(self.text)
        self.assertEqual(result, u'<redacted>')


if __name__ == '__main__':
    unittest2.main()
