from __future__ import absolute_import, unicode_literals

from django.conf import settings
from django.utils.importlib import import_module

CONFIG_DEFAULTS = {
    'HTML_REPORT_PATH': None
}

USER_CONFIG = getattr(settings, 'SQL_DEBUG_CONFIG', {})


def prepend_to_setting(setting_name, value):
    """Insert value at the beginning of a list or tuple setting."""
    values = getattr(settings, setting_name)
    # Make a list [value] or tuple (value,)
    value = type(values)((value,))
    setattr(settings, setting_name, value + values)


def is_sqldebug_middleware(middleware_path):
    from .middleware import SQLDebugMiddleware
    # This could be replaced by import_by_path in Django >= 1.6.
    try:
        mod_path, cls_name = middleware_path.rsplit('.', 1)
        mod = import_module(mod_path)
        middleware_cls = getattr(mod, cls_name)
    except (AttributeError, ImportError, ValueError):
        return
    return issubclass(middleware_cls, SQLDebugMiddleware)


def is_sqldebug_middleware_installed():
    return any(is_sqldebug_middleware(middleware)
               for middleware in settings.MIDDLEWARE_CLASSES)


def patch_middleware_classes():
    if not is_sqldebug_middleware_installed():
        prepend_to_setting('MIDDLEWARE_CLASSES',
                           'django_sql_debug.middleware.SQLDebugMiddleware')


print(USER_CONFIG)
CONFIG = CONFIG_DEFAULTS.copy()
CONFIG.update(USER_CONFIG)
print(CONFIG)

def patch_all():
    patch_middleware_classes()
