# -*- coding: utf-8 -*-
from __future__ import absolute_import, unicode_literals

import re
import os
from setuptools import setup
from setuptools import find_packages

README = open(os.path.join(os.path.dirname(__file__), 'README.rst')).read()

os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))


def get_version():
    VERSIONFILE = 'django_sql_debug/__init__.py'
    initfile_lines = open(VERSIONFILE, 'rt').readlines()
    VSRE = r"^__version__ = ['\"]([^'\"]*)['\"]"
    for line in initfile_lines:
        mo = re.search(VSRE, line, re.M)
        if mo:
            return mo.group(1)
    raise RuntimeError('Unable to find version string in %s.' % (VERSIONFILE,))

setup(
    name='django-sql-debug',
    version=get_version(),
    packages=find_packages(exclude=('tests', 'example')),
    include_package_data=True,
    license='MIT',
    description='Django Sql Debug',
    long_description=README,
    url='https://github.com/socketubs/django-sql-debug',
    author='Geoffrey Lehée',
    author_email='hello@socketubs.org',
    install_requires=['django-debug-toolbar>=1.2.1'],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
)
