from __future__ import absolute_import
from __future__ import unicode_literals

import os

from django.template import loader
from django.template import Context
from django.contrib.staticfiles import finders


def render_sql_panel(panel, request):
    t = loader.get_template(os.path.join('django_sql_debug', 'report.html'))
    data = {'request': request}

    # Css
    data.update({
        'css': open(finders.find(
            'django_sql_debug/css/sql_debug.css')).read(),
        'jquery': open(finders.find(
            'django_sql_debug/js/jquery-2.1.1.min.js')).read(),
        'js': open(finders.find(
            'django_sql_debug/js/sql_debug.js')).read()})

    # Panel title
    data.update({"title": panel.title})
    data.update({"panel_id": panel.panel_id})

    # Panel data
    data.update(panel.get_stats())

    c = Context(data)
    rendered = t.render(c)
    return rendered
