from __future__ import absolute_import
from __future__ import unicode_literals

import os

from django.conf import settings
from django.template import loader
from django.template import Context
from django.contrib.staticfiles import finders
from django.views.debug import get_safe_settings

try:
    from collections import OrderedDict
except ImportError:
    from django.utils.datastructures import SortedDict as OrderedDict


def render_sql_panel(panel, request):
    t = loader.get_template(os.path.join('django_sql_debug', 'report.html'))
    data = {'request': request}

    # Css
    data.update({
        'css': open(finders.find(
            'django_sql_debug/css/sql_debug.css')).read(),
        'jquery': open(finders.find(
            'django_sql_debug/js/jquery-2.1.1.min.js')).read(),
        'js': open(finders.find(
            'django_sql_debug/js/sql_debug.js')).read()})

    # Panel title
    data.update({"title": panel.title})
    data.update({"panel_id": panel.panel_id})

    # Panel data
    data.update(panel.get_stats())

    # Settings
    data.update({
        'settings_title': '<code>%s</code>' % settings.SETTINGS_MODULE,
        'settings': OrderedDict(sorted(
            get_safe_settings().items(), key=lambda s: s[0]))})

    c = Context(data)
    rendered = t.render(c)
    return rendered
