#!/bin/sh
# Copyright (c) 2014, Clemson University
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
#
# * Neither the name of the {organization} nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

usage() {
  echo "Usage: $0 -a URL"
  echo "       $0 -u URL USERNAME"
  echo "       $0 -f URL FINGERPRINT"
  echo "       $0 URL [USERNAME]"
}

mode=x
while getopts ':hafu' opt; do
  case $opt in
    h)
      usage
      exit 0
    ;;
    a) mode=a ;;
    f) mode=f ;;
    u) mode=u ;;
    [?])
      exec 1>&2
      echo "Invalid option: -$OPTARG"
      usage
      exit 1
    ;;
  esac
done
shift $(($OPTIND-1))

if [ $# -eq 0 ]; then
  usage >&2
  exit 1
fi
url="$1"

case $mode in
  a)
    query=
  ;;
  f)
    if [ $# -lt 2 ]; then
      usage >&2
      exit 1
    fi
    query="fingerprint=$2"
  ;;
  u)
    if [ $# -lt 2 ]; then
      usage >&2
      exit 1
    fi
    query="username=$2"
  ;;
  x)
    if [ $# -eq 1 ]; then
      SSHKEY_LOOKUP_URL="${url}"
      export SSHKEY_LOOKUP_URL
      exec `dirname $0`/django-sshkey-lookup-by-fingerprint
    else
      query="username=$2"
    fi
  ;;
esac

if type curl >/dev/null 2>&1; then
  exec curl -s -G "${url}" --data-urlencode "${query}"
else
  exec wget -q -O - "${url}?${query}"
fi
