from django.conf import settings
from django.core.exceptions import ImproperlyConfigured

from staticfiles.utils import AppSettings


class StaticfilesSettings(AppSettings):
    # The directory in which the static files are collected in
    ROOT = ''
    # The URL path to STATIC_ROOT
    URL = None
    # A tuple of two-tuples with a name and the path of additional directories
    # which hold static files and should be taken into account
    DIRS = ()
    # Apps that shouldn't be taken into account when collecting app media
    EXCLUDED_APPS = ()
    # Destination storage
    STORAGE = 'staticfiles.storage.StaticFilesStorage'
    # List of finder classes that know how to find static files in
    # various locations.
    FINDERS = (
        'staticfiles.finders.FileSystemFinder',
        'staticfiles.finders.AppDirectoriesFinder',
    #    'staticfiles.finders.DefaultStorageFinder',
    )

    def configure_root(self, value):
        """
        Use STATIC_ROOT since it doesn't has the default prefix
        """
        root = value or getattr(settings, 'STATIC_ROOT', None)
        if (self.MEDIA_ROOT and root) and (self.MEDIA_ROOT == root):
            raise ImproperlyConfigured("The MEDIA_ROOT and STATIC_ROOT "
                                       "settings must have different values")
        self.STATIC_ROOT = root
        return root

    def configure_url(self, value):
        """
        Use STATIC_URL since it doesn't has the default prefix
        """
        url = value or getattr(settings, 'STATIC_URL', None)
        if not url:
            raise ImproperlyConfigured("You're using the staticfiles app "
                                       "without having set the required "
                                       "STATIC_URL setting.")
        if url == self.MEDIA_URL:
            raise ImproperlyConfigured("The MEDIA_URL and STATIC_URL "
                                       "settings must have different values")
        self.STATIC_URL = url
        return url
