# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import DataMigration
from django.db import models
from sts.utils import total_seconds

class Migration(DataMigration):

    def forwards(self, orm):
        "Write your forwards methods here."
        for t in orm['sts.Transition'].objects.filter(end_time__isnull=False):
            t.duration = int(round(total_seconds(t.end_time - t.start_time) * 1000))
            t.save()

    def backwards(self, orm):
        "Write your backwards methods here."
        for t in orm['sts.Transition'].objects.filter(end_time__isnull=False):
            t.duration = (t.end_time - t.start_time).seconds
            t.save()

    models = {
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'sts.event': {
            'Meta': {'object_name': 'Event'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'sts.state': {
            'Meta': {'object_name': 'State'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'sts.system': {
            'Meta': {'ordering': "('-modified',)", 'object_name': 'System'},
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']", 'null': 'True', 'blank': 'True'}),
            'created': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'modified': ('django.db.models.fields.DateTimeField', [], {'auto_now': 'True', 'blank': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100', 'null': 'True', 'blank': 'True'}),
            'object_id': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'sts.transition': {
            'Meta': {'ordering': "('start_time',)", 'object_name': 'Transition'},
            'duration': ('django.db.models.fields.PositiveIntegerField', [], {'null': 'True', 'blank': 'True'}),
            'end_time': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'event': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'transitions'", 'null': 'True', 'to': "orm['sts.Event']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'start_time': ('django.db.models.fields.DateTimeField', [], {}),
            'state': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'transitions'", 'to': "orm['sts.State']"}),
            'system': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'transitions'", 'to': "orm['sts.System']"})
        }
    }

    complete_apps = ['sts']
    symmetrical = True
