// Generated by CoffeeScript 1.8.0
(function() {
  var __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  define(function() {
    var ListFilter;
    return ListFilter = (function() {
      function ListFilter(filter, filter_skel) {
        this.filter = filter;
        this.filter_skel = filter_skel;
        this.onKeypress = __bind(this.onKeypress, this);
        this.resetFilter = __bind(this.resetFilter, this);
        this.filterCallback = __bind(this.filterCallback, this);
        this.drawFilterCallback = __bind(this.drawFilterCallback, this);
        this.drawFilterBOCallback = __bind(this.drawFilterBOCallback, this);
        this.drawFilter = __bind(this.drawFilter, this);
        this.showFilter = __bind(this.showFilter, this);
        this.hideFilter = __bind(this.hideFilter, this);
        this.mode = "django";
      }

      ListFilter.prototype.hideFilter = function() {
        if (this.filter == null) {
          return;
        }
        return $(this.filter).hide().addClass("hidden");
      };

      ListFilter.prototype.showFilter = function(all) {
        var br, hide, input, select, show, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2;
        if (this.filter == null) {
          return;
        }
        hide = function(elt) {
          var fom_group;
          fom_group = $(elt).closest(".form-group");
          if (fom_group.length > 0) {
            fom_group.hide();
          } else {
            $(elt).hide();
          }
          return $(elt.label).hide();
        };
        show = function(elt) {
          var fom_group;
          fom_group = $(elt).closest(".form-group");
          if (fom_group.length > 0) {
            fom_group.show();
          } else {
            $(elt).show();
          }
          return $(elt.label).show();
        };
        _ref = $("INPUT", this.form);
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          input = _ref[_i];
          if (input.getAttribute("type") === "checkbox") {
            if (!all && input.getAttribute("checked") !== "checked") {
              hide(input);
            } else {
              if (input.id !== "") {
                show(input);
              }
            }
          } else {
            if (!all && input.value === "") {
              hide(input);
            } else {
              show(input);
            }
          }
        }
        _ref1 = $("select", this.form);
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          select = _ref1[_j];
          if (!all && select.querySelectorAll("option[selected]").length === 0) {
            hide(select);
          } else {
            show(select);
          }
        }
        _ref2 = $("br", this.form);
        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
          br = _ref2[_k];
          if (all) {
            $(br).show();
          } else {
            $(br).hide();
          }
        }
        return $(this.filter).show().removeClass("hidden");
      };

      ListFilter.prototype.drawFilter = function(after) {
        var bocall;
        if (this.filter == null) {
          return;
        }
        this.hideFilter();
        bocall = new BOCall;
        bocall.done = (function(_this) {
          return function() {
            _this.drawFilterBOCallback(bocall);
            return typeof after === "function" ? after() : void 0;
          };
        })(this);
        return bocall.postFacet(null, this.filter_skel, this.mode);
      };

      ListFilter.prototype.drawFilterBOCallback = function(bocall) {
        if (bocall != null) {
          $(this.filter).html(bocall.responseText);
        }
        return this.drawFilterCallback();
      };

      ListFilter.prototype.drawFilterCallback = function() {
        var elem, form, label, _i, _len, _ref;
        form = $("form", this.filter);
        if (form.length === 0) {
          return;
        }
        this.form = form.get(0);
        $('#plus', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            return _this.showFilter(true);
          };
        })(this));
        $('#moins', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            _this.resetFilter();
            return _this.filterCallback(evt);
          };
        })(this));
        $('#go', this.filter).on("click", (function(_this) {
          return function(evt) {
            if (evt != null) {
              evt.preventDefault();
            }
            return _this.filterCallback(evt);
          };
        })(this));
        $(this.form).on('submit', this.filterCallback);
        $(this.form).on('keypress', this.onKeypress);
        _ref = $('label');
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          label = _ref[_i];
          if (!(label.htmlFor !== '')) {
            continue;
          }
          elem = document.getElementById(label.htmlFor);
          if (elem != null) {
            elem.label = label;
          }
        }
        return this.showFilter();
      };

      ListFilter.prototype.filterCallback = function(evt) {
        var data, _ref;
        if (evt != null) {
          evt.preventDefault();
        }
        if (this.form != null) {
          data = new FormData(this.form);
        }
        return (_ref = this.list) != null ? _ref.drawList(null, data, this.drawFilter) : void 0;
      };

      ListFilter.prototype.resetFilter = function() {
        var input, option, select, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _results;
        _ref = $("input", this.form);
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          input = _ref[_i];
          if (input.id !== 'nbre_ligne') {
            $(input).val('');
          }
        }
        _ref1 = $("select", this.form);
        _results = [];
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          select = _ref1[_j];
          _ref2 = $("option", select).val();
          for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
            option = _ref2[_k];
            option.selected = false;
          }
          _results.push(select.querySelector("option").selected = true);
        }
        return _results;
      };

      ListFilter.prototype.onKeypress = function(evt) {
        if (evt.which === 13) {
          return this.filterCallback(evt);
        }
      };

      return ListFilter;

    })();
  });

}).call(this);

//# sourceMappingURL=listFilter.js.map
