// Generated by CoffeeScript 1.3.3

(function($) {
  return $.sublimeScroll = function(options) {
    var $scroll, $scroll_bar, $scroll_overlay, onDrag, onDragEnd, scroll_bar_height, scroll_height, scroll_offset, settings, size_factor, window_height;
    settings = {
      scroll_width: 150,
      offset: 0,
      z_index: 50,
      content_width: 960,
      full_height: $('html').height(),
      opacity: 0.1,
      color: 'white'
    };
    settings = $.extend(settings, options);
    window_height = null;
    scroll_height = null;
    scroll_bar_height = null;
    size_factor = settings.scroll_width / settings.content_width;
    scroll_offset = settings.offset * size_factor;
    $scroll = $('<div>', {
      id: 'sublime-scroll'
    }).css({
      position: 'fixed',
      top: settings.offset,
      right: 0,
      width: settings.scroll_width,
      zIndex: settings.z_index,
      backgroundRepeat: 'no-repeat',
      backgroundPosition: "0 " + (scroll_offset * -1) + 'px'
    }).appendTo($('body'));
    $scroll_bar = $('<div>', {
      id: 'sublime-scroll-bar'
    }).css({
      position: 'absolute',
      right: 0,
      width: '100%',
      backgroundColor: settings.color,
      opacity: settings.opacity,
      zIndex: settings.z_index + 1
    }).appendTo($scroll);
    $scroll_overlay = $('<div>', {
      id: 'sublime-scroll-overlay'
    }).css({
      position: 'fixed',
      top: settings.offset,
      right: 0,
      width: settings.scroll_width,
      height: '100%',
      zIndex: settings.z_index + 2
    }).appendTo($scroll);
    onDragEnd = function(event) {
      event.preventDefault();
      $scroll_overlay.css({
        width: settings.scroll_width
      });
      return $(window).off('mousemove', onDrag);
    };
    onDrag = function(event) {
      var max_pos, pos, y;
      if (!(event.target === $scroll_overlay[0])) {
        return false;
      }
      y = event.offsetY - scroll_bar_height / 2;
      max_pos = scroll_height - scroll_bar_height - scroll_offset;
      if (y < 0) {
        y = 0;
      }
      if (y > max_pos) {
        y = max_pos;
      }
      $scroll_bar.css({
        top: y
      });
      pos = y / size_factor + scroll_offset;
      return $(window).scrollTop(pos);
    };
    $scroll.on('mousedown', function(event) {
      event.preventDefault();
      $scroll_overlay.css({
        width: '100%'
      });
      $(window).on('mousemove', onDrag).one('mouseup', onDragEnd);
      return onDrag(event);
    });
    $(window).resize(function() {
      var height;
      window_height = $(window).height() - settings.offset;
      scroll_height = settings.full_height * size_factor - scroll_offset;
      if (scroll_height < window_height) {
        height = window_height;
      } else {
        height = scroll_height;
      }
      $scroll.css({
        height: height,
        backgroundSize: "100% " + scroll_height + "px"
      });
      $scroll_overlay.css({
        height: height
      });
      scroll_bar_height = window_height * size_factor;
      $scroll_bar.css({
        height: scroll_bar_height
      });
      return $(window).scroll();
    }).resize();
    return $(window).scroll(function() {
      var f, margin, pos, scroll_top, y;
      scroll_top = $(window).scrollTop();
      pos = (scroll_top + settings.offset) * size_factor - scroll_offset;
      $scroll_bar.css({
        top: pos
      });
      if (scroll_height > window_height) {
        y = $scroll_bar.position().top;
        f = (scroll_bar_height / scroll_height) * y;
        margin = (y / scroll_height) * (window_height - scroll_height) - f;
      } else {
        margin = 0;
      }
      $scroll.css({
        marginTop: margin
      });
      return $scroll_overlay.css({
        marginTop: margin
      });
    }).scroll();
  };
})(jQuery);
