# -*- coding: utf-8 -*-
# Copyright (c) 2012 by Pablo Martín <goinnn@gmail.com>
#
# This software is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this software.  If not, see <http://www.gnu.org/licenses/>.


from django_tables2.views import SingleTableView

from django_tables2_reports.config import RequestConfigReport
from django_tables2_reports.utils import create_report_http_response


class ReportTableView(SingleTableView):

    def get_table(self):
        """
        Return a table object to use. The table has automatic support for
        sorting and pagination.
        """
        options = {}
        table_class = self.get_table_class()
        table = table_class(self.get_table_data())
        paginate = self.get_table_pagination()
        if paginate is not None:
            options['paginate'] = paginate
        self.table_to_csv = RequestConfigReport(self.request, **options).configure(table)
        return table

    def render_to_response(self, context, **response_kwargs):
        if self.table_to_csv:
            return create_report_http_response(self.table_to_csv, self.request)
        return super(ReportTableView, self).render_to_response(context, **response_kwargs)
